/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobProgressPoller
extends Thread {
    public static final long DEFAULT_INTERVAL_MSEC = 500L;
    private static final Logger logger = LoggerFactory.getLogger(JobProgressPoller.class);
    private Job job;
    private long intervalMs;

    public JobProgressPoller(Job job, long intervalMs) {
        super("JobProgressPoller, jobId=" + job.getId());
        this.job = job;
        if (intervalMs < 0L) {
            throw new IllegalArgumentException("polling interval can't be " + intervalMs);
        }
        this.intervalMs = intervalMs == 0L ? 500L : intervalMs;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                JobListener listener = this.job.getListener();
                if (listener != null) {
                    try {
                        if (this.job.isRunning()) {
                            listener.onProgressUpdate(this.job, this.job.progress());
                        }
                    }
                    catch (Exception e) {
                        logger.error("Can not get or update progress", (Throwable)e);
                    }
                }
                Thread.sleep(this.intervalMs);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

