/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.zeppelin.scheduler.SchedulerThreadFactory;

public class ExecutorFactory {
    private static ExecutorFactory instance;
    private static Long _executorLock;
    private Map<String, ExecutorService> executors = new HashMap<String, ExecutorService>();

    private ExecutorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorFactory singleton() {
        if (instance == null) {
            Long l = _executorLock;
            synchronized (l) {
                if (instance == null) {
                    instance = new ExecutorFactory();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService createOrGet(String name, int numThread) {
        Map<String, ExecutorService> map = this.executors;
        synchronized (map) {
            if (!this.executors.containsKey(name)) {
                this.executors.put(name, Executors.newScheduledThreadPool(numThread, new SchedulerThreadFactory(name)));
            }
            return this.executors.get(name);
        }
    }

    public ExecutorService getNoteJobExecutor() {
        return this.createOrGet("NoteJobThread-", 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String name) {
        Map<String, ExecutorService> map = this.executors;
        synchronized (map) {
            if (this.executors.containsKey(name)) {
                ExecutorService e = this.executors.get(name);
                e.shutdown();
                this.executors.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAll() {
        Map<String, ExecutorService> map = this.executors;
        synchronized (map) {
            for (String name : this.executors.keySet()) {
                this.shutdown(name);
            }
        }
    }

    static {
        _executorLock = new Long(0L);
    }
}

