/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduler
implements Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractScheduler.class);
    protected String name;
    protected volatile boolean terminate = false;
    protected BlockingQueue<Job> queue = new LinkedBlockingQueue<Job>();
    protected Map<String, Job> jobs = new ConcurrentHashMap<String, Job>();
    private Thread schedulerThread;

    public AbstractScheduler(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Job> getAllJobs() {
        return new ArrayList<Job>(this.jobs.values());
    }

    @Override
    public Job getJob(String jobId) {
        return this.jobs.get(jobId);
    }

    @Override
    public void submit(Job job) {
        job.setStatus(Job.Status.PENDING);
        try {
            this.queue.put(job);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(String.format("Unable to submit job %s", job.getId()), e);
        }
        this.jobs.put(job.getId(), job);
    }

    @Override
    public Job cancel(String jobId) {
        Job job = this.jobs.remove(jobId);
        job.abort();
        return job;
    }

    @Override
    public void run() {
        this.schedulerThread = Thread.currentThread();
        while (!this.terminate && !this.schedulerThread.isInterrupted()) {
            Job runningJob = null;
            try {
                runningJob = this.queue.take();
            }
            catch (InterruptedException e) {
                LOGGER.warn("{} is interrupted", (Object)this.getClass().getSimpleName());
                break;
            }
            this.runJobInScheduler(runningJob);
        }
    }

    public abstract void runJobInScheduler(Job var1);

    @Override
    public void stop() {
        this.terminate = true;
        for (Job job : this.queue) {
            job.aborted = true;
            job.jobAbort();
        }
        if (this.schedulerThread != null) {
            this.schedulerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runJob(Job runningJob) {
        if (runningJob.isAborted()) {
            LOGGER.info("Job {} is aborted", (Object)runningJob.getId());
            runningJob.setStatus(Job.Status.ABORT);
            runningJob.aborted = false;
            return;
        }
        LOGGER.info("Job " + runningJob.getId() + " started by scheduler " + this.name);
        if (!this.getClass().getSimpleName().equals("RemoteScheduler")) {
            runningJob.setStatus(Job.Status.RUNNING);
        }
        runningJob.run();
        Object jobResult = runningJob.getReturn();
        Job job = runningJob;
        synchronized (job) {
            if (runningJob.isAborted()) {
                runningJob.setStatus(Job.Status.ABORT);
                LOGGER.debug("Job Aborted, " + runningJob.getId() + ", " + runningJob.getErrorMessage());
            } else if (runningJob.getException() != null) {
                LOGGER.debug("Job Error, " + runningJob.getId() + ", " + runningJob.getReturn());
                runningJob.setStatus(Job.Status.ERROR);
            } else if (jobResult != null && jobResult instanceof InterpreterResult && ((InterpreterResult)jobResult).code() == InterpreterResult.Code.ERROR) {
                LOGGER.debug("Job Error, " + runningJob.getId() + ", " + runningJob.getReturn());
                runningJob.setStatus(Job.Status.ERROR);
            } else {
                LOGGER.debug("Job Finished, " + runningJob.getId() + ", Result: " + runningJob.getReturn());
                runningJob.setStatus(Job.Status.FINISHED);
            }
        }
        LOGGER.info("Job " + runningJob.getId() + " finished by scheduler " + this.name);
        runningJob.aborted = false;
        this.jobs.remove(runningJob.getId());
    }
}

