/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.zeppelin.interpreter.remote.RemoteClientFactory;
import org.apache.zeppelin.interpreter.remote.SupplierWithIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledRemoteClient<T extends TServiceClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledRemoteClient.class);
    private GenericObjectPool<T> clientPool;
    private RemoteClientFactory<T> remoteClientFactory;

    public PooledRemoteClient(SupplierWithIO<T> supplier) {
        this.remoteClientFactory = new RemoteClientFactory<T>(supplier);
        this.clientPool = new GenericObjectPool(this.remoteClientFactory);
    }

    public synchronized T getClient() throws Exception {
        return (T)((TServiceClient)this.clientPool.borrowObject(5000L));
    }

    public void shutdown() {
        if (this.remoteClientFactory != null) {
            this.remoteClientFactory.close();
        }
    }

    private void releaseClient(T client, boolean broken) {
        if (broken) {
            this.releaseBrokenClient(client);
        } else {
            try {
                this.clientPool.returnObject(client);
            }
            catch (Exception e) {
                LOGGER.warn("exception occurred during releasing thrift client", (Throwable)e);
            }
        }
    }

    private void releaseBrokenClient(T client) {
        try {
            LOGGER.warn("release broken client");
            this.clientPool.invalidateObject(client);
        }
        catch (Exception e) {
            LOGGER.warn("exception occurred during releasing thrift client", (Throwable)e);
        }
    }

    public <R> R callRemoteFunction(RemoteFunction<R, T> func) {
        T client = null;
        boolean broken = false;
        try {
            client = this.getClient();
            if (client != null) {
                R r = func.call(client);
                return r;
            }
        }
        catch (TException e) {
            broken = true;
            throw new RuntimeException(e);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        finally {
            if (client != null) {
                this.releaseClient(client, broken);
            }
        }
        return null;
    }

    public static interface RemoteFunction<R, T> {
        public R call(T var1) throws Exception;
    }
}

