/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.providers.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.utils.ProviderUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json", "application/javascript"})
@Produces(value={"application/json", "application/javascript"})
public class JsonProvider
implements MessageBodyWriter<JSONObject>,
MessageBodyReader<JSONObject> {
    private static final Logger logger = LoggerFactory.getLogger(JsonProvider.class);
    @Context
    private UriInfo uriInfo;

    public long getSize(JSONObject t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == JSONObject.class;
    }

    public void writeTo(JSONObject t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String jsonString = null;
        try {
            jsonString = t.toString(2);
        }
        catch (JSONException e) {
            logger.error(Messages.getMessage((String)"jsonFailWriteJSONObject"), (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        String callbackParam = null;
        try {
            callbackParam = (String)this.uriInfo.getQueryParameters().getFirst((Object)"callback");
        }
        catch (Exception e) {
            logger.trace("Could not get the URI callback param", (Throwable)e);
        }
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, (MediaType)mediaType);
        Charset charset = Charset.forName(ProviderUtils.getCharset((MediaType)mediaType));
        OutputStreamWriter writer = new OutputStreamWriter(entityStream, charset);
        if (callbackParam != null) {
            writer.write(callbackParam);
            writer.write("(");
        }
        writer.write(jsonString);
        if (callbackParam != null) {
            writer.write(")");
        }
        writer.flush();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == JSONObject.class;
    }

    public JSONObject readFrom(Class<JSONObject> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return new JSONObject(new JSONTokener(ProviderUtils.createReader((InputStream)entityStream, (MediaType)mediaType)));
        }
        catch (JSONException e) {
            logger.error(Messages.getMessage((String)"jsonFailReadJSONObject"), (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }
}

