/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.util.Locale;
import java.util.Objects;
import org.apache.tika.parser.microsoft.onenote.GUID;

class ExtendedGUID
implements Comparable<ExtendedGUID> {
    GUID guid;
    long n;

    public ExtendedGUID(GUID guid, long n) {
        this.guid = guid;
        this.n = n;
    }

    public static ExtendedGUID nil() {
        return new ExtendedGUID(GUID.nil(), 0L);
    }

    @Override
    public int compareTo(ExtendedGUID other) {
        if (other.guid.equals(this.guid)) {
            return Long.compare(this.n, other.n);
        }
        return this.guid.compareTo(other.guid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedGUID that = (ExtendedGUID)o;
        return this.n == that.n && Objects.equals(this.guid, that.guid);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.n);
    }

    public String toString() {
        return String.format(Locale.US, "%s [%d]", this.guid, this.n);
    }

    public GUID getGuid() {
        return this.guid;
    }

    public ExtendedGUID setGuid(GUID guid) {
        this.guid = guid;
        return this;
    }

    public String getExtendedGuidString() {
        return this.guid.toString() + " [" + this.n + "]";
    }

    public long getN() {
        return this.n;
    }

    public ExtendedGUID setN(long n) {
        this.n = n;
        return this;
    }
}

