/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UTF8StringBuilder;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.sparkproject.guava.primitives.Ints;

public final class UTF8String
implements Comparable<UTF8String>,
Externalizable,
KryoSerializable,
Cloneable {
    @Nonnull
    private Object base;
    private long offset;
    private int numBytes;
    private static byte[] bytesOfCodePointInUTF8 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final boolean IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final UTF8String COMMA_UTF8 = UTF8String.fromString(",");
    public static final UTF8String EMPTY_UTF8 = UTF8String.fromString("");
    private static final byte[] US_ENGLISH_MAPPING = new byte[]{48, 49, 50, 51, 48, 49, 50, 55, 48, 50, 50, 52, 53, 53, 48, 49, 50, 54, 50, 51, 48, 49, 55, 50, 48, 50};

    public Object getBaseObject() {
        return this.base;
    }

    public long getBaseOffset() {
        return this.offset;
    }

    public static UTF8String fromBytes(byte[] bytes) {
        if (bytes != null) {
            return new UTF8String(bytes, Platform.BYTE_ARRAY_OFFSET, bytes.length);
        }
        return null;
    }

    public static UTF8String fromBytes(byte[] bytes, int offset, int numBytes) {
        if (bytes != null) {
            return new UTF8String(bytes, Platform.BYTE_ARRAY_OFFSET + offset, numBytes);
        }
        return null;
    }

    public static UTF8String fromAddress(Object base, long offset, int numBytes) {
        return new UTF8String(base, offset, numBytes);
    }

    public static UTF8String fromString(String str) {
        return str == null ? null : UTF8String.fromBytes(str.getBytes(StandardCharsets.UTF_8));
    }

    public static UTF8String blankString(int length) {
        byte[] spaces = new byte[length];
        Arrays.fill(spaces, (byte)32);
        return UTF8String.fromBytes(spaces);
    }

    protected UTF8String(Object base, long offset, int numBytes) {
        this.base = base;
        this.offset = offset;
        this.numBytes = numBytes;
    }

    public UTF8String() {
        this(null, 0L, 0);
    }

    public void writeToMemory(Object target, long targetOffset) {
        Platform.copyMemory(this.base, this.offset, target, targetOffset, this.numBytes);
    }

    public void writeTo(ByteBuffer buffer) {
        assert (buffer.hasArray());
        byte[] target = buffer.array();
        int offset = buffer.arrayOffset();
        int pos = buffer.position();
        this.writeToMemory(target, Platform.BYTE_ARRAY_OFFSET + offset + pos);
        buffer.position(pos + this.numBytes);
    }

    @Nonnull
    public ByteBuffer getByteBuffer() {
        if (this.base instanceof byte[] && this.offset >= (long)Platform.BYTE_ARRAY_OFFSET) {
            byte[] bytes = (byte[])this.base;
            long arrayOffset = this.offset - (long)Platform.BYTE_ARRAY_OFFSET;
            if ((long)bytes.length < arrayOffset + (long)this.numBytes) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return ByteBuffer.wrap(bytes, (int)arrayOffset, this.numBytes);
        }
        return ByteBuffer.wrap(this.getBytes());
    }

    public void writeTo(OutputStream out) throws IOException {
        ByteBuffer bb = this.getByteBuffer();
        assert (bb.hasArray());
        out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
    }

    private static int numBytesForFirstByte(byte b) {
        int offset = b & 0xFF;
        byte numBytes = bytesOfCodePointInUTF8[offset];
        return numBytes == 0 ? (byte)1 : numBytes;
    }

    public int numBytes() {
        return this.numBytes;
    }

    public int numChars() {
        int len = 0;
        for (int i = 0; i < this.numBytes; i += UTF8String.numBytesForFirstByte(this.getByte(i))) {
            ++len;
        }
        return len;
    }

    public long getPrefix() {
        long p;
        long mask = 0L;
        if (IS_LITTLE_ENDIAN) {
            if (this.numBytes >= 8) {
                p = Platform.getLong(this.base, this.offset);
            } else if (this.numBytes > 4) {
                p = Platform.getLong(this.base, this.offset);
                mask = (1L << (8 - this.numBytes) * 8) - 1L;
            } else if (this.numBytes > 0) {
                p = Platform.getInt(this.base, this.offset);
                mask = (1L << (8 - this.numBytes) * 8) - 1L;
            } else {
                p = 0L;
            }
            p = Long.reverseBytes(p);
        } else if (this.numBytes >= 8) {
            p = Platform.getLong(this.base, this.offset);
        } else if (this.numBytes > 4) {
            p = Platform.getLong(this.base, this.offset);
            mask = (1L << (8 - this.numBytes) * 8) - 1L;
        } else if (this.numBytes > 0) {
            p = (long)Platform.getInt(this.base, this.offset) << 32;
            mask = (1L << (8 - this.numBytes) * 8) - 1L;
        } else {
            p = 0L;
        }
        return p &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public byte[] getBytes() {
        if (this.offset == (long)Platform.BYTE_ARRAY_OFFSET && this.base instanceof byte[] && ((byte[])this.base).length == this.numBytes) {
            return (byte[])this.base;
        }
        byte[] bytes = new byte[this.numBytes];
        Platform.copyMemory(this.base, this.offset, bytes, Platform.BYTE_ARRAY_OFFSET, this.numBytes);
        return bytes;
    }

    public UTF8String substring(int start, int until) {
        int c;
        if (until <= start || start >= this.numBytes) {
            return EMPTY_UTF8;
        }
        int i = 0;
        for (c = 0; i < this.numBytes && c < start; i += UTF8String.numBytesForFirstByte(this.getByte(i)), ++c) {
        }
        int j = i;
        while (i < this.numBytes && c < until) {
            i += UTF8String.numBytesForFirstByte(this.getByte(i));
            ++c;
        }
        if (i > j) {
            byte[] bytes = new byte[i - j];
            Platform.copyMemory(this.base, this.offset + (long)j, bytes, Platform.BYTE_ARRAY_OFFSET, i - j);
            return UTF8String.fromBytes(bytes);
        }
        return EMPTY_UTF8;
    }

    public UTF8String substringSQL(int pos, int length) {
        int len = this.numChars();
        int start = pos > 0 ? pos - 1 : (pos < 0 ? len + pos : 0);
        int end = length == Integer.MAX_VALUE ? len : start + length;
        return this.substring(start, end);
    }

    public boolean contains(UTF8String substring) {
        if (substring.numBytes == 0) {
            return true;
        }
        byte first = substring.getByte(0);
        for (int i = 0; i <= this.numBytes - substring.numBytes; ++i) {
            if (this.getByte(i) != first || !this.matchAt(substring, i)) continue;
            return true;
        }
        return false;
    }

    private byte getByte(int i) {
        return Platform.getByte(this.base, this.offset + (long)i);
    }

    private boolean matchAt(UTF8String s, int pos) {
        if (s.numBytes + pos > this.numBytes || pos < 0) {
            return false;
        }
        return ByteArrayMethods.arrayEquals(this.base, this.offset + (long)pos, s.base, s.offset, s.numBytes);
    }

    public boolean startsWith(UTF8String prefix) {
        return this.matchAt(prefix, 0);
    }

    public boolean endsWith(UTF8String suffix) {
        return this.matchAt(suffix, this.numBytes - suffix.numBytes);
    }

    public UTF8String toUpperCase() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        byte[] bytes = new byte[this.numBytes];
        bytes[0] = (byte)Character.toTitleCase(this.getByte(0));
        for (int i = 0; i < this.numBytes; ++i) {
            byte b = this.getByte(i);
            if (UTF8String.numBytesForFirstByte(b) != 1) {
                return this.toUpperCaseSlow();
            }
            int upper = Character.toUpperCase(b);
            if (upper > 127) {
                return this.toUpperCaseSlow();
            }
            bytes[i] = (byte)upper;
        }
        return UTF8String.fromBytes(bytes);
    }

    private UTF8String toUpperCaseSlow() {
        return UTF8String.fromString(this.toString().toUpperCase());
    }

    public UTF8String toLowerCase() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        byte[] bytes = new byte[this.numBytes];
        bytes[0] = (byte)Character.toTitleCase(this.getByte(0));
        for (int i = 0; i < this.numBytes; ++i) {
            byte b = this.getByte(i);
            if (UTF8String.numBytesForFirstByte(b) != 1) {
                return this.toLowerCaseSlow();
            }
            int lower = Character.toLowerCase(b);
            if (lower > 127) {
                return this.toLowerCaseSlow();
            }
            bytes[i] = (byte)lower;
        }
        return UTF8String.fromBytes(bytes);
    }

    private UTF8String toLowerCaseSlow() {
        return UTF8String.fromString(this.toString().toLowerCase());
    }

    public UTF8String toTitleCase() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        byte[] bytes = new byte[this.numBytes];
        for (int i = 0; i < this.numBytes; ++i) {
            byte b = this.getByte(i);
            if (i == 0 || this.getByte(i - 1) == 32) {
                if (UTF8String.numBytesForFirstByte(b) != 1) {
                    return this.toTitleCaseSlow();
                }
                int upper = Character.toTitleCase(b);
                if (upper > 127) {
                    return this.toTitleCaseSlow();
                }
                bytes[i] = (byte)upper;
                continue;
            }
            bytes[i] = b;
        }
        return UTF8String.fromBytes(bytes);
    }

    private UTF8String toTitleCaseSlow() {
        StringBuffer sb = new StringBuffer();
        String s = this.toString();
        sb.append(s);
        sb.setCharAt(0, Character.toTitleCase(sb.charAt(0)));
        for (int i = 1; i < s.length(); ++i) {
            if (sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toTitleCase(sb.charAt(i)));
        }
        return UTF8String.fromString(sb.toString());
    }

    public int findInSet(UTF8String match) {
        if (match.contains(COMMA_UTF8)) {
            return 0;
        }
        int n = 1;
        int lastComma = -1;
        for (int i = 0; i < this.numBytes; ++i) {
            if (this.getByte(i) != 44) continue;
            if (i - (lastComma + 1) == match.numBytes && ByteArrayMethods.arrayEquals(this.base, this.offset + (long)(lastComma + 1), match.base, match.offset, match.numBytes)) {
                return n;
            }
            lastComma = i;
            ++n;
        }
        if (this.numBytes - (lastComma + 1) == match.numBytes && ByteArrayMethods.arrayEquals(this.base, this.offset + (long)(lastComma + 1), match.base, match.offset, match.numBytes)) {
            return n;
        }
        return 0;
    }

    private UTF8String copyUTF8String(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        Platform.copyMemory(this.base, this.offset + (long)start, newBytes, Platform.BYTE_ARRAY_OFFSET, len);
        return UTF8String.fromBytes(newBytes);
    }

    public UTF8String trim() {
        int e;
        int s;
        for (s = 0; s < this.numBytes && this.getByte(s) == 32; ++s) {
        }
        if (s == this.numBytes) {
            return EMPTY_UTF8;
        }
        for (e = this.numBytes - 1; e > s && this.getByte(e) == 32; --e) {
        }
        if (s == 0 && e == this.numBytes - 1) {
            return this;
        }
        return this.copyUTF8String(s, e);
    }

    public UTF8String trim(UTF8String trimString) {
        if (trimString != null) {
            return this.trimLeft(trimString).trimRight(trimString);
        }
        return null;
    }

    public UTF8String trimLeft() {
        int s;
        for (s = 0; s < this.numBytes && this.getByte(s) == 32; ++s) {
        }
        if (s == 0) {
            return this;
        }
        if (s == this.numBytes) {
            return EMPTY_UTF8;
        }
        return this.copyUTF8String(s, this.numBytes - 1);
    }

    public UTF8String trimLeft(UTF8String trimString) {
        int srchIdx;
        int searchCharBytes;
        if (trimString == null) {
            return null;
        }
        int trimIdx = 0;
        for (srchIdx = 0; srchIdx < this.numBytes; srchIdx += searchCharBytes) {
            UTF8String searchChar = this.copyUTF8String(srchIdx, srchIdx + UTF8String.numBytesForFirstByte(this.getByte(srchIdx)) - 1);
            searchCharBytes = searchChar.numBytes;
            if (trimString.find(searchChar, 0) < 0) break;
            trimIdx += searchCharBytes;
        }
        if (srchIdx == 0) {
            return this;
        }
        if (trimIdx >= this.numBytes) {
            return EMPTY_UTF8;
        }
        return this.copyUTF8String(trimIdx, this.numBytes - 1);
    }

    public UTF8String trimRight() {
        int e;
        for (e = this.numBytes - 1; e >= 0 && this.getByte(e) == 32; --e) {
        }
        if (e == this.numBytes - 1) {
            return this;
        }
        if (e < 0) {
            return EMPTY_UTF8;
        }
        return this.copyUTF8String(0, e);
    }

    public UTF8String trimRight(UTF8String trimString) {
        UTF8String searchChar;
        if (trimString == null) {
            return null;
        }
        int charIdx = 0;
        int numChars = 0;
        int[] stringCharLen = new int[this.numBytes];
        int[] stringCharPos = new int[this.numBytes];
        while (charIdx < this.numBytes) {
            stringCharPos[numChars] = charIdx;
            stringCharLen[numChars] = UTF8String.numBytesForFirstByte(this.getByte(charIdx));
            charIdx += stringCharLen[numChars];
            ++numChars;
        }
        int trimEnd = this.numBytes - 1;
        while (numChars > 0 && trimString.find(searchChar = this.copyUTF8String(stringCharPos[numChars - 1], stringCharPos[numChars - 1] + stringCharLen[numChars - 1] - 1), 0) >= 0) {
            trimEnd -= stringCharLen[numChars - 1];
            --numChars;
        }
        if (trimEnd == this.numBytes - 1) {
            return this;
        }
        if (trimEnd < 0) {
            return EMPTY_UTF8;
        }
        return this.copyUTF8String(0, trimEnd);
    }

    public UTF8String reverse() {
        int len;
        byte[] result = new byte[this.numBytes];
        for (int i = 0; i < this.numBytes; i += len) {
            len = UTF8String.numBytesForFirstByte(this.getByte(i));
            Platform.copyMemory(this.base, this.offset + (long)i, result, Platform.BYTE_ARRAY_OFFSET + result.length - i - len, len);
        }
        return UTF8String.fromBytes(result);
    }

    public UTF8String repeat(int times) {
        int toCopy;
        if (times <= 0) {
            return EMPTY_UTF8;
        }
        byte[] newBytes = new byte[this.numBytes * times];
        Platform.copyMemory(this.base, this.offset, newBytes, Platform.BYTE_ARRAY_OFFSET, this.numBytes);
        for (int copied = 1; copied < times; copied += toCopy) {
            toCopy = Math.min(copied, times - copied);
            System.arraycopy(newBytes, 0, newBytes, copied * this.numBytes, this.numBytes * toCopy);
        }
        return UTF8String.fromBytes(newBytes);
    }

    public int indexOf(UTF8String v, int start) {
        int c;
        if (v.numBytes() == 0) {
            return 0;
        }
        int i = 0;
        for (c = 0; i < this.numBytes && c < start; i += UTF8String.numBytesForFirstByte(this.getByte(i)), ++c) {
        }
        do {
            if (i + v.numBytes > this.numBytes) {
                return -1;
            }
            if (ByteArrayMethods.arrayEquals(this.base, this.offset + (long)i, v.base, v.offset, v.numBytes)) {
                return c;
            }
            i += UTF8String.numBytesForFirstByte(this.getByte(i));
            ++c;
        } while (i < this.numBytes);
        return -1;
    }

    private int find(UTF8String str, int start) {
        assert (str.numBytes > 0);
        while (start <= this.numBytes - str.numBytes) {
            if (ByteArrayMethods.arrayEquals(this.base, this.offset + (long)start, str.base, str.offset, str.numBytes)) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private int rfind(UTF8String str, int start) {
        assert (str.numBytes > 0);
        while (start >= 0) {
            if (ByteArrayMethods.arrayEquals(this.base, this.offset + (long)start, str.base, str.offset, str.numBytes)) {
                return start;
            }
            --start;
        }
        return -1;
    }

    public UTF8String subStringIndex(UTF8String delim, int count) {
        if (delim.numBytes == 0 || count == 0) {
            return EMPTY_UTF8;
        }
        if (count > 0) {
            int idx = -1;
            while (count > 0) {
                if ((idx = this.find(delim, idx + 1)) >= 0) {
                    --count;
                    continue;
                }
                return this;
            }
            if (idx == 0) {
                return EMPTY_UTF8;
            }
            byte[] bytes = new byte[idx];
            Platform.copyMemory(this.base, this.offset, bytes, Platform.BYTE_ARRAY_OFFSET, idx);
            return UTF8String.fromBytes(bytes);
        }
        int idx = this.numBytes - delim.numBytes + 1;
        for (count = -count; count > 0; --count) {
            if ((idx = this.rfind(delim, idx - 1)) >= 0) {
                continue;
            }
            return this;
        }
        if (idx + delim.numBytes == this.numBytes) {
            return EMPTY_UTF8;
        }
        int size = this.numBytes - delim.numBytes - idx;
        byte[] bytes = new byte[size];
        Platform.copyMemory(this.base, this.offset + (long)idx + (long)delim.numBytes, bytes, Platform.BYTE_ARRAY_OFFSET, size);
        return UTF8String.fromBytes(bytes);
    }

    public UTF8String rpad(int len, UTF8String pad) {
        int spaces = len - this.numChars();
        if (spaces <= 0 || pad.numBytes() == 0) {
            return this.substring(0, len);
        }
        int padChars = pad.numChars();
        int count = spaces / padChars;
        UTF8String remain = pad.substring(0, spaces - padChars * count);
        byte[] data = new byte[this.numBytes + pad.numBytes * count + remain.numBytes];
        Platform.copyMemory(this.base, this.offset, data, Platform.BYTE_ARRAY_OFFSET, this.numBytes);
        int offset = this.numBytes;
        int idx = 0;
        while (idx < count) {
            Platform.copyMemory(pad.base, pad.offset, data, Platform.BYTE_ARRAY_OFFSET + offset, pad.numBytes);
            ++idx;
            offset += pad.numBytes;
        }
        Platform.copyMemory(remain.base, remain.offset, data, Platform.BYTE_ARRAY_OFFSET + offset, remain.numBytes);
        return UTF8String.fromBytes(data);
    }

    public UTF8String lpad(int len, UTF8String pad) {
        int spaces = len - this.numChars();
        if (spaces <= 0 || pad.numBytes() == 0) {
            return this.substring(0, len);
        }
        int padChars = pad.numChars();
        int count = spaces / padChars;
        UTF8String remain = pad.substring(0, spaces - padChars * count);
        byte[] data = new byte[this.numBytes + pad.numBytes * count + remain.numBytes];
        int offset = 0;
        int idx = 0;
        while (idx < count) {
            Platform.copyMemory(pad.base, pad.offset, data, Platform.BYTE_ARRAY_OFFSET + offset, pad.numBytes);
            ++idx;
            offset += pad.numBytes;
        }
        Platform.copyMemory(remain.base, remain.offset, data, Platform.BYTE_ARRAY_OFFSET + offset, remain.numBytes);
        Platform.copyMemory(this.base, this.offset, data, Platform.BYTE_ARRAY_OFFSET + (offset += remain.numBytes), this.numBytes());
        return UTF8String.fromBytes(data);
    }

    public static UTF8String concat(UTF8String ... inputs) {
        long totalLength = 0L;
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] != null) {
                totalLength += (long)inputs[i].numBytes;
                continue;
            }
            return null;
        }
        byte[] result = new byte[Ints.checkedCast((long)totalLength)];
        int offset = 0;
        for (int i = 0; i < inputs.length; ++i) {
            int len = inputs[i].numBytes;
            Platform.copyMemory(inputs[i].base, inputs[i].offset, result, Platform.BYTE_ARRAY_OFFSET + offset, len);
            offset += len;
        }
        return UTF8String.fromBytes(result);
    }

    public static UTF8String concatWs(UTF8String separator, UTF8String ... inputs) {
        if (separator == null) {
            return null;
        }
        int numInputBytes = 0;
        int numInputs = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            numInputBytes += inputs[i].numBytes;
            ++numInputs;
        }
        if (numInputs == 0) {
            return EMPTY_UTF8;
        }
        byte[] result = new byte[numInputBytes + (numInputs - 1) * separator.numBytes];
        int offset = 0;
        int j = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            int len = inputs[i].numBytes;
            Platform.copyMemory(inputs[i].base, inputs[i].offset, result, Platform.BYTE_ARRAY_OFFSET + offset, len);
            offset += len;
            if (++j >= numInputs) continue;
            Platform.copyMemory(separator.base, separator.offset, result, Platform.BYTE_ARRAY_OFFSET + offset, separator.numBytes);
            offset += separator.numBytes;
        }
        return UTF8String.fromBytes(result);
    }

    public UTF8String[] split(UTF8String pattern, int limit) {
        if (limit == 0) {
            limit = -1;
        }
        String[] splits = this.toString().split(pattern.toString(), limit);
        UTF8String[] res = new UTF8String[splits.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = UTF8String.fromString(splits[i]);
        }
        return res;
    }

    public UTF8String replace(UTF8String search, UTF8String replace) {
        if (this.numBytes == 0 || search.numBytes == 0) {
            return this;
        }
        int start = 0;
        int end = this.find(search, start);
        if (end == -1) {
            return this;
        }
        int increase = Math.max(0, replace.numBytes - search.numBytes) * 16;
        UTF8StringBuilder buf = new UTF8StringBuilder(this.numBytes + increase);
        while (end != -1) {
            buf.appendBytes(this.base, this.offset + (long)start, end - start);
            buf.append(replace);
            start = end + search.numBytes;
            end = this.find(search, start);
        }
        buf.appendBytes(this.base, this.offset + (long)start, this.numBytes - start);
        return buf.build();
    }

    public UTF8String translate(Map<Character, Character> dict) {
        String srcStr = this.toString();
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < srcStr.length(); ++k) {
            if (null == dict.get(Character.valueOf(srcStr.charAt(k)))) {
                sb.append(srcStr.charAt(k));
                continue;
            }
            if ('\u0000' == dict.get(Character.valueOf(srcStr.charAt(k))).charValue()) continue;
            sb.append(dict.get(Character.valueOf(srcStr.charAt(k))));
        }
        return UTF8String.fromString(sb.toString());
    }

    public boolean toLong(LongWrapper toLongResult) {
        if (this.numBytes == 0) {
            return false;
        }
        byte b = this.getByte(0);
        boolean negative = b == 45;
        int offset = 0;
        if (negative || b == 43) {
            ++offset;
            if (this.numBytes == 1) {
                return false;
            }
        }
        int separator = 46;
        int radix = 10;
        long stopValue = -922337203685477580L;
        long result = 0L;
        while (offset < this.numBytes) {
            b = this.getByte(offset);
            ++offset;
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return false;
            }
            int digit = b - 48;
            if (result < -922337203685477580L) {
                return false;
            }
            if ((result = result * 10L - (long)digit) <= 0L) continue;
            return false;
        }
        while (offset < this.numBytes) {
            byte currentByte = this.getByte(offset);
            if (currentByte < 48 || currentByte > 57) {
                return false;
            }
            ++offset;
        }
        if (!negative && (result = -result) < 0L) {
            return false;
        }
        toLongResult.value = result;
        return true;
    }

    public boolean toInt(IntWrapper intWrapper) {
        if (this.numBytes == 0) {
            return false;
        }
        byte b = this.getByte(0);
        boolean negative = b == 45;
        int offset = 0;
        if (negative || b == 43) {
            ++offset;
            if (this.numBytes == 1) {
                return false;
            }
        }
        int separator = 46;
        int radix = 10;
        int stopValue = -214748364;
        int result = 0;
        while (offset < this.numBytes) {
            b = this.getByte(offset);
            ++offset;
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return false;
            }
            int digit = b - 48;
            if (result < -214748364) {
                return false;
            }
            if ((result = result * 10 - digit) <= 0) continue;
            return false;
        }
        while (offset < this.numBytes) {
            byte currentByte = this.getByte(offset);
            if (currentByte < 48 || currentByte > 57) {
                return false;
            }
            ++offset;
        }
        if (!negative && (result = -result) < 0) {
            return false;
        }
        intWrapper.value = result;
        return true;
    }

    public boolean toShort(IntWrapper intWrapper) {
        int intValue;
        short result;
        return this.toInt(intWrapper) && (result = (short)(intValue = intWrapper.value)) == intValue;
    }

    public boolean toByte(IntWrapper intWrapper) {
        int intValue;
        byte result;
        return this.toInt(intWrapper) && (result = (byte)(intValue = intWrapper.value)) == intValue;
    }

    public String toString() {
        return new String(this.getBytes(), StandardCharsets.UTF_8);
    }

    public UTF8String clone() {
        return UTF8String.fromBytes(this.getBytes());
    }

    public UTF8String copy() {
        byte[] bytes = new byte[this.numBytes];
        Platform.copyMemory(this.base, this.offset, bytes, Platform.BYTE_ARRAY_OFFSET, this.numBytes);
        return UTF8String.fromBytes(bytes);
    }

    @Override
    public int compareTo(@Nonnull UTF8String other) {
        int i;
        int len = Math.min(this.numBytes, other.numBytes);
        int wordMax = len / 8 * 8;
        long roffset = other.offset;
        Object rbase = other.base;
        for (i = 0; i < wordMax; i += 8) {
            long right;
            long left = Platform.getLong(this.base, this.offset + (long)i);
            if (left == (right = Platform.getLong(rbase, roffset + (long)i))) continue;
            if (IS_LITTLE_ENDIAN) {
                return Long.compareUnsigned(Long.reverseBytes(left), Long.reverseBytes(right));
            }
            return Long.compareUnsigned(left, right);
        }
        for (i = wordMax; i < len; ++i) {
            int res = (this.getByte(i) & 0xFF) - (Platform.getByte(rbase, roffset + (long)i) & 0xFF);
            if (res == 0) continue;
            return res;
        }
        return this.numBytes - other.numBytes;
    }

    public int compare(UTF8String other) {
        return this.compareTo(other);
    }

    public boolean equals(Object other) {
        if (other instanceof UTF8String) {
            UTF8String o = (UTF8String)other;
            if (this.numBytes != o.numBytes) {
                return false;
            }
            return ByteArrayMethods.arrayEquals(this.base, this.offset, o.base, o.offset, this.numBytes);
        }
        return false;
    }

    public int levenshteinDistance(UTF8String other) {
        int i;
        UTF8String t;
        UTF8String s;
        int n = this.numChars();
        int m = other.numChars();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n <= m) {
            s = this;
            t = other;
        } else {
            s = other;
            t = this;
            int swap = n;
            n = m;
            m = swap;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        int j_bytes = 0;
        for (int j = 0; j < m; ++j) {
            int num_bytes_j = UTF8String.numBytesForFirstByte(t.getByte(j_bytes));
            d[0] = j + 1;
            int i_bytes = 0;
            for (i = 0; i < n; ++i) {
                int cost = s.getByte(i_bytes) != t.getByte(j_bytes) || num_bytes_j != UTF8String.numBytesForFirstByte(s.getByte(i_bytes)) ? 1 : (ByteArrayMethods.arrayEquals(t.base, t.offset + (long)j_bytes, s.base, s.offset + (long)i_bytes, num_bytes_j) ? 0 : 1);
                d[i + 1] = Math.min(Math.min(d[i] + 1, p[i + 1] + 1), p[i] + cost);
                i_bytes += UTF8String.numBytesForFirstByte(s.getByte(i_bytes));
            }
            int[] swap = p;
            p = d;
            d = swap;
            j_bytes += num_bytes_j;
        }
        return p[n];
    }

    public int hashCode() {
        return Murmur3_x86_32.hashUnsafeBytes(this.base, this.offset, this.numBytes, 42);
    }

    public UTF8String soundex() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        byte b = this.getByte(0);
        if (97 <= b && b <= 122) {
            b = (byte)(b - 32);
        } else if (b < 65 || 90 < b) {
            return this;
        }
        byte[] sx = new byte[]{48, 48, 48, 48};
        sx[0] = b;
        int sxi = 1;
        int idx = b - 65;
        int lastCode = US_ENGLISH_MAPPING[idx];
        for (int i = 1; i < this.numBytes; ++i) {
            b = this.getByte(i);
            if (97 <= b && b <= 122) {
                b = (byte)(b - 32);
            } else if (b < 65 || 90 < b) {
                lastCode = 48;
                continue;
            }
            idx = b - 65;
            int code = US_ENGLISH_MAPPING[idx];
            if (code == 55) continue;
            if (code != 48 && code != lastCode) {
                sx[sxi++] = code;
                if (sxi > 3) break;
            }
            lastCode = code;
        }
        return UTF8String.fromBytes(sx);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] bytes = this.getBytes();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.offset = Platform.BYTE_ARRAY_OFFSET;
        this.numBytes = in.readInt();
        this.base = new byte[this.numBytes];
        in.readFully((byte[])this.base);
    }

    public void write(Kryo kryo, Output out) {
        byte[] bytes = this.getBytes();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public void read(Kryo kryo, Input in) {
        this.offset = Platform.BYTE_ARRAY_OFFSET;
        this.numBytes = in.readInt();
        this.base = new byte[this.numBytes];
        in.read((byte[])this.base);
    }

    public static class IntWrapper
    implements Serializable {
        public transient int value = 0;
    }

    public static class LongWrapper
    implements Serializable {
        public transient long value = 0L;
    }
}

