/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import java.io.Serializable;

public final class CalendarInterval
implements Serializable {
    public static final long MICROS_PER_MILLI = 1000L;
    public static final long MICROS_PER_SECOND = 1000000L;
    public static final long MICROS_PER_MINUTE = 60000000L;
    public static final long MICROS_PER_HOUR = 3600000000L;
    public static final long MICROS_PER_DAY = 86400000000L;
    public static final long MICROS_PER_WEEK = 604800000000L;
    public final int months;
    public final long microseconds;

    public long milliseconds() {
        return this.microseconds / 1000L;
    }

    public CalendarInterval(int months, long microseconds) {
        this.months = months;
        this.microseconds = microseconds;
    }

    public CalendarInterval add(CalendarInterval that) {
        int months = this.months + that.months;
        long microseconds = this.microseconds + that.microseconds;
        return new CalendarInterval(months, microseconds);
    }

    public CalendarInterval subtract(CalendarInterval that) {
        int months = this.months - that.months;
        long microseconds = this.microseconds - that.microseconds;
        return new CalendarInterval(months, microseconds);
    }

    public CalendarInterval negate() {
        return new CalendarInterval(-this.months, -this.microseconds);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof CalendarInterval)) {
            return false;
        }
        CalendarInterval o = (CalendarInterval)other;
        return this.months == o.months && this.microseconds == o.microseconds;
    }

    public int hashCode() {
        return 31 * this.months + (int)this.microseconds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("interval");
        if (this.months != 0) {
            this.appendUnit(sb, this.months / 12, "year");
            this.appendUnit(sb, this.months % 12, "month");
        }
        if (this.microseconds != 0L) {
            long rest = this.microseconds;
            this.appendUnit(sb, rest / 604800000000L, "week");
            this.appendUnit(sb, (rest %= 604800000000L) / 86400000000L, "day");
            this.appendUnit(sb, (rest %= 86400000000L) / 3600000000L, "hour");
            this.appendUnit(sb, (rest %= 3600000000L) / 60000000L, "minute");
            this.appendUnit(sb, (rest %= 60000000L) / 1000000L, "second");
            this.appendUnit(sb, (rest %= 1000000L) / 1000L, "millisecond");
            this.appendUnit(sb, rest %= 1000L, "microsecond");
        } else if (this.months == 0) {
            sb.append(" 0 microseconds");
        }
        return sb.toString();
    }

    private void appendUnit(StringBuilder sb, long value, String unit) {
        if (value != 0L) {
            sb.append(' ').append(value).append(' ').append(unit).append('s');
        }
    }
}

