/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Queue;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0001\u0002\u0001\t1\u0011\u0011#U;fk\u0016Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!A\u0004egR\u0014X-Y7\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WCA\u0007\u0015'\t\u0001a\u0002E\u0002\u0010!Ii\u0011AA\u0005\u0003#\t\u0011A\"\u00138qkR$5\u000b\u001e:fC6\u0004\"a\u0005\u000b\r\u0001\u0011)Q\u0003\u0001b\u0001/\t\tAk\u0001\u0001\u0012\u0005aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"a\u0002(pi\"Lgn\u001a\t\u00033}I!\u0001\t\u000e\u0003\u0007\u0005s\u0017\u0010\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\r\u00198o\u0019\t\u0003I\u0015j\u0011\u0001B\u0005\u0003M\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011!\u0002!Q1A\u0005\u0002%\nQ!];fk\u0016,\u0012A\u000b\t\u0004WA\u0012T\"\u0001\u0017\u000b\u00055r\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003_i\t!bY8mY\u0016\u001cG/[8o\u0013\t\tDFA\u0003Rk\u0016,X\rE\u00024mIi\u0011\u0001\u000e\u0006\u0003k\u0019\t1A\u001d3e\u0013\t9DGA\u0002S\t\u0012C\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0007cV,W/\u001a\u0011\t\u0011m\u0002!\u0011!Q\u0001\nq\n!b\u001c8f\u0003R\fE+[7f!\tIR(\u0003\u0002?5\t9!i\\8mK\u0006t\u0007\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0015\u0011,g-Y;miJ#E\t\u0003\u0005C\u0001\t\r\t\u0015a\u0003D\u0003))g/\u001b3f]\u000e,G%\r\t\u0004\t\u001e\u0013R\"A#\u000b\u0005\u0019S\u0012a\u0002:fM2,7\r^\u0005\u0003\u0011\u0016\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006\u0015\u0002!\taS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1{\u0005+\u0015*\u0015\u00055s\u0005cA\b\u0001%!)!)\u0013a\u0002\u0007\")!%\u0013a\u0001G!)\u0001&\u0013a\u0001U!)1(\u0013a\u0001y!)\u0001)\u0013a\u0001e!)A\u000b\u0001C!+\u0006)1\u000f^1siR\ta\u000b\u0005\u0002\u001a/&\u0011\u0001L\u0007\u0002\u0005+:LG\u000fC\u0003[\u0001\u0011\u0005S+\u0001\u0003ti>\u0004\b\"\u0002/\u0001\t\u0013i\u0016A\u0003:fC\u0012|%M[3diR\u0011aK\u0018\u0005\u0006?n\u0003\r\u0001Y\u0001\u0003S:\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u0005%|'\"A3\u0002\t)\fg/Y\u0005\u0003O\n\u0014\u0011c\u00142kK\u000e$\u0018J\u001c9viN#(/Z1n\u0011\u0015I\u0007\u0001\"\u0003k\u0003-9(/\u001b;f\u001f\nTWm\u0019;\u0015\u0005Y[\u0007\"\u00027i\u0001\u0004i\u0017aA8pgB\u0011\u0011M\\\u0005\u0003_\n\u0014!c\u00142kK\u000e$x*\u001e;qkR\u001cFO]3b[\")\u0011\u000f\u0001C!e\u000691m\\7qkR,GCA:w!\rIBOM\u0005\u0003kj\u0011aa\u00149uS>t\u0007\"B<q\u0001\u0004A\u0018!\u0003<bY&$G+[7f!\t!\u00130\u0003\u0002{\t\t!A+[7f\u0001")
public class QueueInputDStream<T>
extends InputDStream<T> {
    private final StreamingContext ssc;
    private final Queue<RDD<T>> queue;
    private final boolean oneAtATime;
    private final RDD<T> defaultRDD;
    private final ClassTag<T> evidence$1;

    public Queue<RDD<T>> queue() {
        return this.queue;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private void readObject(ObjectInputStream in) {
        throw new NotSerializableException("queueStream doesn't support checkpointing. Please don't use queueStream when checkpointing is enabled.");
    }

    private void writeObject(ObjectOutputStream oos) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "queueStream doesn't support checkpointing";
            }
        });
    }

    @Override
    public Option<RDD<T>> compute(Time validTime) {
        ArrayBuffer buffer = new ArrayBuffer();
        Queue<RDD<T>> queue = this.queue();
        synchronized (queue) {
            ArrayBuffer arrayBuffer;
            if (this.oneAtATime && this.queue().nonEmpty()) {
                arrayBuffer = buffer.$plus$eq(this.queue().dequeue());
            } else {
                buffer.$plus$plus$eq(this.queue());
                this.queue().clear();
                arrayBuffer = BoxedUnit.UNIT;
            }
            return buffer.nonEmpty() ? (this.oneAtATime ? new Some(buffer.head()) : new Some((Object)new UnionRDD(this.context().sc(), buffer.toSeq(), this.evidence$1))) : (this.defaultRDD == null ? new Some((Object)this.ssc.sparkContext().emptyRDD(this.evidence$1)) : new Some(this.defaultRDD));
        }
    }

    public QueueInputDStream(StreamingContext ssc, Queue<RDD<T>> queue, boolean oneAtATime, RDD<T> defaultRDD, ClassTag<T> evidence$1) {
        this.ssc = ssc;
        this.queue = queue;
        this.oneAtATime = oneAtATime;
        this.defaultRDD = defaultRDD;
        this.evidence$1 = evidence$1;
        super(ssc, evidence$1);
    }
}

