/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\t\u0012\u0001yA\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\")Q\u000b\u0001C\u0001-\"9\u0011\n\u0001b\u0001\n#Q\u0006B\u00020\u0001A\u0003%1\fC\u0003`\u0001\u0011\u0005\u0003\rC\u0003n\u0001\u0011\u0005c\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0003z\u0001\u0011\u0005#\u0010C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t)\u0004\u0001C!\u0003o\u0011AER5mKNK8\u000f^3n\u0005\u0006\u001cX\rZ\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM\u001d\u0006\u0003%M\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005Q)\u0012!C3yK\u000e,H/[8o\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\u0015\u0001q$J\u0015@!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002#%\u0011\u0001&\u0005\u0002\u0016\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s!\tQCH\u0004\u0002,u9\u0011A&\u000f\b\u0003[ar!AL\u001c\u000f\u0005=2dB\u0001\u00196\u001d\t\tD'D\u00013\u0015\t\u0019T$\u0001\u0004=e>|GOP\u0005\u00029%\u0011!dG\u0005\u00031eI!AF\f\n\u0005Q)\u0012B\u0001\n\u0014\u0013\tY\u0014#A\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\n\u0005ur$a\u0005*f]\u0006lW\rS3ma\u0016\u0014X*\u001a;i_\u0012\u001c(BA\u001e\u0012!\t\u00015)D\u0001B\u0015\t\u0011u#\u0001\u0005j]R,'O\\1m\u0013\t!\u0015IA\u0004M_\u001e<\u0017N\\4\u0002\tA\fG\u000f\u001b\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b!AZ:\u000b\u0005-K\u0012A\u00025bI>|\u0007/\u0003\u0002N\u0011\n!\u0001+\u0019;i\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003!Nk\u0011!\u0015\u0006\u0003%*\u000bAaY8oM&\u0011A+\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r9\u0006,\u0017\t\u0003M\u0001AQ!R\u0002A\u0002\u0019CQAT\u0002A\u0002=+\u0012a\u0017\t\u0003\u000frK!!\u0018%\u0003\u0015\u0019KG.Z*zgR,W.A\u0002gg\u0002\nA\u0001\\5tiR\u0019\u0011m\u001a5\u0011\u0007\u0001\u0012G-\u0003\u0002dC\t)\u0011I\u001d:bsB\u0011q)Z\u0005\u0003M\"\u0013!BR5mKN#\u0018\r^;t\u0011\u0015)e\u00011\u0001G\u0011\u0015Ig\u00011\u0001k\u0003\u00191\u0017\u000e\u001c;feB\u0011qi[\u0005\u0003Y\"\u0013!\u0002U1uQ\u001aKG\u000e^3s\u0003\u0019i7\u000eZ5sgR\u0011qN\u001d\t\u0003AAL!!]\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000b\u001e\u0001\rAR\u0001\u000fGJ,\u0017\r^3UK6\u0004h)\u001b7f)\t)\b\u0010\u0005\u0002Hm&\u0011q\u000f\u0013\u0002\u0013\rN#\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003F\u0011\u0001\u0007a)\u0001\u0007de\u0016\fG/Z!u_6L7\r\u0006\u0003|\u007f\u0006\u0005\u0001C\u0001?~\u001d\t1#(\u0003\u0002\u007f}\ti2)\u00198dK2d\u0017M\u00197f\rN#\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003F\u0013\u0001\u0007a\tC\u0004\u0002\u0004%\u0001\r!!\u0002\u0002'=4XM]<sSR,\u0017J\u001a)pgNL'\r\\3\u0011\u0007\u0001\n9!C\u0002\u0002\n\u0005\u0012qAQ8pY\u0016\fg.\u0001\u0003pa\u0016tG\u0003BA\b\u0003+\u00012aRA\t\u0013\r\t\u0019\u0002\u0013\u0002\u0012\rN#\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007\"B#\u000b\u0001\u00041\u0015AB3ySN$8\u000f\u0006\u0003\u0002\u0006\u0005m\u0001\"B#\f\u0001\u00041\u0015A\u0004:f]\u0006lW\rV3na\u001aKG.\u001a\u000b\b_\u0006\u0005\u0012QEA\u0015\u0011\u0019\t\u0019\u0003\u0004a\u0001\r\u000691O]2QCRD\u0007BBA\u0014\u0019\u0001\u0007a)A\u0004egR\u0004\u0016\r\u001e5\t\u000f\u0005\rA\u00021\u0001\u0002\u0006\u00051A-\u001a7fi\u0016$2a\\A\u0018\u0011\u0015)U\u00021\u0001G\u0003\u001dI7\u000fT8dC2,\"!!\u0002\u00023\r\u0014X-\u0019;f\u0007\",7m\u001b9pS:$H)\u001b:fGR|'/\u001f\u000b\u0002\r\u0002")
public class FileSystemBasedCheckpointFileManager
implements CheckpointFileManager,
CheckpointFileManager.RenameHelperMethods,
Logging {
    private final Path path;
    private final FileSystem fs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public FileStatus[] list(Path path) {
        return CheckpointFileManager.list$(this, path);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileSystem fs() {
        return this.fs;
    }

    @Override
    public FileStatus[] list(Path path, PathFilter filter) {
        return this.fs().listStatus(path, filter);
    }

    @Override
    public void mkdirs(Path path) {
        this.fs().mkdirs(path, FsPermission.getDirDefault());
    }

    @Override
    public FSDataOutputStream createTempFile(Path path) {
        return this.fs().create(path, true);
    }

    @Override
    public CheckpointFileManager.CancellableFSDataOutputStream createAtomic(Path path, boolean overwriteIfPossible) {
        return new CheckpointFileManager.RenameBasedFSDataOutputStream(this, path, overwriteIfPossible);
    }

    @Override
    public FSDataInputStream open(Path path) {
        return this.fs().open(path);
    }

    @Override
    public boolean exists(Path path) {
        boolean bl;
        block3: {
            try {
                if (this.fs().getFileStatus(path) != null) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void renameTempFile(Path srcPath, Path dstPath, boolean overwriteIfPossible) {
        if (!overwriteIfPossible && this.fs().exists(dstPath)) {
            throw QueryExecutionErrors$.MODULE$.renamePathAsExistsPathError(srcPath, dstPath);
        }
        if (!this.fs().rename(srcPath, dstPath)) {
            if (this.fs().exists(dstPath)) {
                if (!overwriteIfPossible) {
                    throw QueryExecutionErrors$.MODULE$.renameAsExistsPathError(dstPath);
                }
                return;
            }
            if (!this.fs().exists(srcPath)) {
                throw QueryExecutionErrors$.MODULE$.renameSrcPathNotFoundError(srcPath);
            }
            Throwable e = QueryExecutionErrors$.MODULE$.failedRenameTempFileError(srcPath, dstPath);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            throw e;
        }
    }

    @Override
    public void delete(Path path) {
        try {
            this.fs().delete(path, true);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    @Override
    public boolean isLocal() {
        FileSystem fileSystem = this.fs();
        return fileSystem instanceof LocalFileSystem ? true : fileSystem instanceof RawLocalFileSystem;
    }

    @Override
    public Path createCheckpointDirectory() {
        Path qualifiedPath = this.fs().makeQualified(this.path);
        this.fs().mkdirs(qualifiedPath, FsPermission.getDirDefault());
        return qualifiedPath;
    }

    public FileSystemBasedCheckpointFileManager(Path path, Configuration hadoopConf) {
        this.path = path;
        CheckpointFileManager.$init$(this);
        CheckpointFileManager.RenameHelperMethods.$init$(this);
        Logging.$init$((Logging)this);
        this.fs = path.getFileSystem(hadoopConf);
    }
}

