/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class DerbyDialect$
extends JdbcDialect {
    public static DerbyDialect$ MODULE$;

    static {
        new DerbyDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:derby");
    }

    @Override
    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return super.compileAggregate(aggFunction).orElse((Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            GeneralAggregateFunc generalAggregateFunc = null;
            AggregateFunc aggregateFunc = aggFunction;
            if (aggregateFunc instanceof GeneralAggregateFunc) {
                bl = true;
                generalAggregateFunc = (GeneralAggregateFunc)aggregateFunc;
                String string = generalAggregateFunc.name();
                String string2 = "VAR_POP";
                if (!(string != null ? !string.equals(string2) : string2 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(9).append("VAR_POP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string3 = "VAR_SAMP";
                if (!(string != null ? !string.equals(string3) : string3 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(10).append("VAR_SAMP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string4 = "STDDEV_POP";
                if (!(string != null ? !string.equals(string4) : string4 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(12).append("STDDEV_POP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (!bl) return None$.MODULE$;
            String string = generalAggregateFunc.name();
            String string5 = "STDDEV_SAMP";
            if (string == null) {
                if (string5 != null) {
                    return None$.MODULE$;
                }
            } else if (!string.equals(string5)) return None$.MODULE$;
            if (generalAggregateFunc.isDistinct()) return None$.MODULE$;
            Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
            return new Some((Object)new StringBuilder(13).append("STDDEV_SAMP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
        });
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return sqlType == 7 ? Option$.MODULE$.apply((Object)FloatType$.MODULE$) : None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        Object object = StringType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005)) : (ByteType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5)) : (ShortType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5)) : (BooleanType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("BOOLEAN", 16)) : (dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() > 31 ? Option$.MODULE$.apply((Object)new JdbcType("DECIMAL(31,5)", 3)) : None$.MODULE$))));
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(oldTable).append(" TO ").append(newTable).toString();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        throw QueryExecutionErrors$.MODULE$.commentOnTableUnsupportedError();
    }

    @Override
    public String getLimitClause(Integer limit) {
        return "";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DerbyDialect$() {
        MODULE$ = this;
    }
}

