/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.ui;

import java.io.Serializable;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlanInfo;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.execution.ui.LiveExecutionData;
import org.apache.spark.sql.execution.ui.LiveStageMetrics;
import org.apache.spark.sql.execution.ui.LiveTaskMetrics;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SQLPlanMetric;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.sql.execution.ui.SparkPlanGraph;
import org.apache.spark.sql.execution.ui.SparkPlanGraph$;
import org.apache.spark.sql.execution.ui.SparkPlanGraphCluster;
import org.apache.spark.sql.execution.ui.SparkPlanGraphClusterWrapper;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNode;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNodeWrapper;
import org.apache.spark.sql.execution.ui.SparkPlanGraphWrapper;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.status.config$;
import org.apache.spark.util.kvstore.KVStoreView;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\u0010 \u00011B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!AQ\t\u0001B\u0001B\u0003%a\tC\u0003M\u0001\u0011\u0005Q\nC\u0004T\u0001\t\u0007I\u0011\u0002+\t\ra\u0003\u0001\u0015!\u0003V\u0011\u001dI\u0006A1A\u0005\niCa\u0001\u001b\u0001!\u0002\u0013Y\u0006bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007e\u0002\u0001\u000b\u0011B6\t\rM\u0004A\u0011A\u0012u\u0011\u0015)\b\u0001\"\u0011w\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\f\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAU\u0001\u0011%\u00111\u0016\u0005\b\u0003_\u0003A\u0011BAY\u0011\u001d\tY\f\u0001C!\u0003{Cq!a2\u0001\t\u0013\tI\rC\u0004\u0002N\u0002!I!a4\t\u0013\u0005]\u0007!%A\u0005\n\u0005e\u0007bBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0003k\u0004A\u0011BA|\u0005Q\u0019\u0016\u000bT!qaN#\u0018\r^;t\u0019&\u001cH/\u001a8fe*\u0011\u0001%I\u0001\u0003k&T!AI\u0012\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u00011c\u0001\u0001.gA\u0011a&M\u0007\u0002_)\u0011\u0001'J\u0001\ng\u000eDW\rZ;mKJL!AM\u0018\u0003\u001bM\u0003\u0018M]6MSN$XM\\3s!\t!t'D\u00016\u0015\t1T%\u0001\u0005j]R,'O\\1m\u0013\tATGA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gN\u001a\t\u0003wqj\u0011!J\u0005\u0003{\u0015\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u000f-48\u000f^8sKB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!)J\u0001\u0007gR\fG/^:\n\u0005\u0011\u000b%\u0001F#mK6,g\u000e\u001e+sC\u000e\\\u0017N\\4Ti>\u0014X-\u0001\u0003mSZ,\u0007CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\t9\u0003\u0016K\u0015\t\u0003\u001f\u0002i\u0011a\b\u0005\u0006s\u0011\u0001\rA\u000f\u0005\u0006}\u0011\u0001\ra\u0010\u0005\u0006\u000b\u0012\u0001\rAR\u0001\u0013Y&4X-\u00169eCR,\u0007+\u001a:j_\u0012t5/F\u0001V!\t9e+\u0003\u0002X\u0011\n!Aj\u001c8h\u0003Ma\u0017N^3Va\u0012\fG/\u001a)fe&|GMT:!\u00039a\u0017N^3Fq\u0016\u001cW\u000f^5p]N,\u0012a\u0017\t\u00059\u000e,V-D\u0001^\u0015\tqv,\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001Y1\u0002\tU$\u0018\u000e\u001c\u0006\u0002E\u0006!!.\u0019<b\u0013\t!WLA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"a\u00144\n\u0005\u001d|\"!\u0005'jm\u0016,\u00050Z2vi&|g\u000eR1uC\u0006yA.\u001b<f\u000bb,7-\u001e;j_:\u001c\b%\u0001\u0007ti\u0006<W-T3ue&\u001c7/F\u0001l!\u0011a6\r\\8\u0011\u0005\u001dk\u0017B\u00018I\u0005\rIe\u000e\u001e\t\u0003\u001fBL!!]\u0010\u0003!1Kg/Z*uC\u001e,W*\u001a;sS\u000e\u001c\u0018!D:uC\u001e,W*\u001a;sS\u000e\u001c\b%\u0001\u0006o_2Kg/\u001a#bi\u0006$\u0012AR\u0001\u000b_:TuNY*uCJ$HCA<{!\t9\u00050\u0003\u0002z\u0011\n!QK\\5u\u0011\u0015YH\u00021\u0001}\u0003\u0015)g/\u001a8u!\tqS0\u0003\u0002\u007f_\t)2\u000b]1sW2K7\u000f^3oKJTuNY*uCJ$\u0018\u0001E8o'R\fw-Z*vE6LG\u000f^3e)\r9\u00181\u0001\u0005\u0007w6\u0001\r!!\u0002\u0011\u00079\n9!C\u0002\u0002\n=\u00121d\u00159be.d\u0015n\u001d;f]\u0016\u00148\u000b^1hKN+(-\\5ui\u0016$\u0017\u0001C8o\u0015>\u0014WI\u001c3\u0015\u0007]\fy\u0001\u0003\u0004|\u001d\u0001\u0007\u0011\u0011\u0003\t\u0004]\u0005M\u0011bAA\u000b_\t\u00192\u000b]1sW2K7\u000f^3oKJTuNY#oI\u00069rN\\#yK\u000e,Ho\u001c:NKR\u0014\u0018nY:Va\u0012\fG/\u001a\u000b\u0004o\u0006m\u0001BB>\u0010\u0001\u0004\ti\u0002E\u0002/\u0003?I1!!\t0\u0005\t\u001a\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0016CXmY;u_JlU\r\u001e:jGN,\u0006\u000fZ1uK\u0006IqN\u001c+bg.,e\u000e\u001a\u000b\u0004o\u0006\u001d\u0002BB>\u0011\u0001\u0004\tI\u0003E\u0002/\u0003WI1!!\f0\u0005Q\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feR\u000b7o[#oI\u0006!B.\u001b<f\u000bb,7-\u001e;j_:lU\r\u001e:jGN$B!a\r\u0002VA)q)!\u000e\u0002:%\u0019\u0011q\u0007%\u0003\r=\u0003H/[8o!\u001d\tY$!\u0013V\u0003\u001frA!!\u0010\u0002FA\u0019\u0011q\b%\u000e\u0005\u0005\u0005#bAA\"W\u00051AH]8pizJ1!a\u0012I\u0003\u0019\u0001&/\u001a3fM&!\u00111JA'\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u000fB\u0005\u0003BA\u001e\u0003#JA!a\u0015\u0002N\t11\u000b\u001e:j]\u001eDa!a\u0016\u0012\u0001\u0004)\u0016aC3yK\u000e,H/[8o\u0013\u0012\f\u0001#Y4he\u0016<\u0017\r^3NKR\u0014\u0018nY:\u0015\t\u0005e\u0012Q\f\u0005\u0007\u0003?\u0012\u0002\u0019A3\u0002\t\u0015DXmY\u0001\u0013kB$\u0017\r^3Ti\u0006<W-T3ue&\u001c7\u000fF\u0006x\u0003K\nI'!\u001c\u0002r\u00055\u0005BBA4'\u0001\u0007A.A\u0004ti\u0006<W-\u00133\t\r\u0005-4\u00031\u0001m\u0003%\tG\u000f^3naRLE\r\u0003\u0004\u0002pM\u0001\r!V\u0001\u0007i\u0006\u001c8.\u00133\t\u000f\u0005M4\u00031\u0001\u0002v\u0005a\u0011mY2v[V\u0003H-\u0019;fgB1\u0011qOAA\u0003\u000fsA!!\u001f\u0002~9!\u0011qHA>\u0013\u0005I\u0015bAA@\u0011\u00069\u0001/Y2lC\u001e,\u0017\u0002BAB\u0003\u000b\u00131aU3r\u0015\r\ty\b\u0013\t\u0004]\u0005%\u0015bAAF_\ty\u0011iY2v[Vd\u0017M\u00197f\u0013:4w\u000e\u0003\u0004\u0002\u0010N\u0001\rAR\u0001\ngV\u001c7-Z3eK\u0012\f\u0001c\u001c8Fq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;\u0015\u0007]\f)\n\u0003\u0004|)\u0001\u0007\u0011q\u0013\t\u0004\u001f\u0006e\u0015bAAN?\tq2\u000b]1sW2K7\u000f^3oKJ\u001c\u0016\u000bT#yK\u000e,H/[8o'R\f'\u000f^\u0001\u000f_:,\u00050Z2vi&|g.\u00128e)\r9\u0018\u0011\u0015\u0005\u0007wV\u0001\r!a)\u0011\u0007=\u000b)+C\u0002\u0002(~\u0011Ad\u00159be.d\u0015n\u001d;f]\u0016\u00148+\u0015'Fq\u0016\u001cW\u000f^5p]\u0016sG-\u0001\fsK6|g/Z*uC2,W*\u001a;sS\u000e\u001cH)\u0019;b)\r9\u0018Q\u0016\u0005\u0007\u0003?2\u0002\u0019A3\u0002)=tGI]5wKJ\f5mY;n+B$\u0017\r^3t)\r9\u00181\u0017\u0005\u0007w^\u0001\r!!.\u0011\u0007=\u000b9,C\u0002\u0002:~\u0011qd\u00159be.d\u0015n\u001d;f]\u0016\u0014HI]5wKJ\f5mY;n+B$\u0017\r^3t\u00031ygn\u0014;iKJ,e/\u001a8u)\r9\u0018q\u0018\u0005\u0007wb\u0001\r!!1\u0011\u00079\n\u0019-C\u0002\u0002F>\u0012!c\u00159be.d\u0015n\u001d;f]\u0016\u0014XI^3oi\u0006!r-\u001a;Pe\u000e\u0013X-\u0019;f\u000bb,7-\u001e;j_:$2!ZAf\u0011\u0019\t9&\u0007a\u0001+\u00061Q\u000f\u001d3bi\u0016$Ra^Ai\u0003'Da!a\u0018\u001b\u0001\u0004)\u0007\u0002CAk5A\u0005\t\u0019\u0001$\u0002\u000b\u0019|'oY3\u0002!U\u0004H-\u0019;fI\u0011,g-Y;mi\u0012\u0012TCAAnU\r1\u0015Q\\\u0016\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001e%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0006\r(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Q\u0011n]*R\u0019N#\u0018mZ3\u0015\u0007\u0019\u000b\u0019\u0010\u0003\u0004\u0002hq\u0001\r\u0001\\\u0001\u0012G2,\u0017M\\;q\u000bb,7-\u001e;j_:\u001cHcA<\u0002z\"1\u00111`\u000fA\u0002U\u000bQaY8v]R\u0004")
public class SQLAppStatusListener
extends SparkListener
implements Logging {
    private final SparkConf conf;
    private final ElementTrackingStore kvstore;
    private final boolean live;
    private final long liveUpdatePeriodNs;
    private final ConcurrentHashMap<Object, LiveExecutionData> liveExecutions;
    private final ConcurrentHashMap<Object, LiveStageMetrics> stageMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long liveUpdatePeriodNs() {
        return this.liveUpdatePeriodNs;
    }

    private ConcurrentHashMap<Object, LiveExecutionData> liveExecutions() {
        return this.liveExecutions;
    }

    private ConcurrentHashMap<Object, LiveStageMetrics> stageMetrics() {
        return this.stageMetrics;
    }

    public boolean noLiveData() {
        return this.liveExecutions().isEmpty() && this.stageMetrics().isEmpty();
    }

    public void onJobStart(SparkListenerJobStart event) {
        String executionIdString = event.properties().getProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
        if (executionIdString == null) {
            return;
        }
        long executionId = new StringOps(Predef$.MODULE$.augmentString(executionIdString)).toLong();
        int jobId = event.jobId();
        LiveExecutionData exec = (LiveExecutionData)((Object)Option$.MODULE$.apply((Object)this.liveExecutions().get(BoxesRunTime.boxToLong((long)executionId))).orElse((Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            try {
                SQLExecutionUIData sqlStoreData = (SQLExecutionUIData)$this.kvstore.read(SQLExecutionUIData.class, (Object)BoxesRunTime.boxToLong((long)executionId));
                LiveExecutionData executionData = new LiveExecutionData(executionId);
                executionData.description_$eq(sqlStoreData.description());
                executionData.details_$eq(sqlStoreData.details());
                executionData.physicalPlanDescription_$eq(sqlStoreData.physicalPlanDescription());
                executionData.metrics_$eq(sqlStoreData.metrics());
                executionData.submissionTime_$eq(sqlStoreData.submissionTime());
                executionData.completionTime_$eq(sqlStoreData.completionTime());
                executionData.jobs_$eq(sqlStoreData.jobs());
                executionData.stages_$eq(sqlStoreData.stages());
                executionData.metricsValues_$eq(sqlStoreData.metricValues());
                executionData.endEvents_$eq(sqlStoreData.jobs().size() + 1);
                this.liveExecutions().put(BoxesRunTime.boxToLong((long)executionId), executionData);
                none$ = new Some((Object)executionData);
            }
            catch (NoSuchElementException noSuchElementException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getOrCreateExecution(executionId)));
        List accumIds = ((TraversableOnce)((SeqLike)exec.metrics().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.accumulatorId()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$)).toList();
        event.stageIds().foreach((Function1 & Serializable & scala.Serializable)id -> SQLAppStatusListener.$anonfun$onJobStart$4(this, accumIds, BoxesRunTime.unboxToInt((Object)id)));
        exec.jobs_$eq((Map<Object, JobExecutionStatus>)exec.jobs().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)jobId)), (Object)JobExecutionStatus.RUNNING)));
        exec.stages_$eq((Set<Object>)((Set)exec.stages().$plus$plus((GenTraversableOnce)event.stageIds().toSet())));
        this.update(exec, true);
    }

    public void onStageSubmitted(SparkListenerStageSubmitted event) {
        if (!this.isSQLStage(event.stageInfo().stageId())) {
            return;
        }
        Option$.MODULE$.apply((Object)this.stageMetrics().get(BoxesRunTime.boxToInteger((int)event.stageInfo().stageId()))).foreach((Function1 & Serializable & scala.Serializable)metrics -> {
            SQLAppStatusListener.$anonfun$onStageSubmitted$1(event, metrics);
            return BoxedUnit.UNIT;
        });
    }

    public void onJobEnd(SparkListenerJobEnd event) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveExecutions().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)exec -> {
            SQLAppStatusListener.$anonfun$onJobEnd$1(this, event, exec);
            return BoxedUnit.UNIT;
        });
    }

    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate event) {
        event.accumUpdates().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SQLAppStatusListener.$anonfun$onExecutorMetricsUpdate$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void onTaskEnd(SparkListenerTaskEnd event) {
        if (!this.isSQLStage(event.stageId())) {
            return;
        }
        TaskInfo info = event.taskInfo();
        Seq accums = this.live && event.taskMetrics() != null ? (Seq)event.taskMetrics().externalAccums().flatMap((Function1 & Serializable & scala.Serializable)a -> {
            Iterable iterable;
            try {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)a.toInfo((Option)new Some(a.value()), (Option)None$.MODULE$)));
            }
            catch (IllegalAccessError illegalAccessError) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, ArrayBuffer$.MODULE$.canBuildFrom()) : info.accumulables();
        this.updateStageMetrics(event.stageId(), event.stageAttemptId(), info.taskId(), (Seq<AccumulableInfo>)accums, info.successful());
    }

    public Option<Map<Object, String>> liveExecutionMetrics(long executionId) {
        return Option$.MODULE$.apply((Object)this.liveExecutions().get(BoxesRunTime.boxToLong((long)executionId))).map((Function1 & Serializable & scala.Serializable)exec -> exec.metricsValues() != null ? exec.metricsValues() : this.aggregateMetrics((LiveExecutionData)((Object)exec)));
    }

    private Map<Object, String> aggregateMetrics(LiveExecutionData exec) {
        Seq metricIds = (Seq)((SeqLike)exec.metrics().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.accumulatorId()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$);
        Map metricTypes = ((TraversableOnce)exec.metrics().map((Function1 & Serializable & scala.Serializable)m -> new Tuple2((Object)BoxesRunTime.boxToLong((long)m.accumulatorId()), (Object)m.metricType()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq metrics2 = (Seq)((TraversableLike)((TraversableLike)exec.stages().toSeq().flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.stageMetrics().get(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)stageId))))), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$3.taskMetrics().values()).asScala(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)metrics -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(metrics.ids())).zip((GenIterable)Predef$.MODULE$.wrapLongArray(metrics.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))), Seq$.MODULE$.canBuildFrom());
        Map<Object, String> aggregatedMetrics = (Map<Object, String>)((TraversableLike)((TraversableLike)metrics2.$plus$plus((GenTraversableOnce)exec.driverAccumUpdates().toSeq(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SQLAppStatusListener.$anonfun$aggregateMetrics$6(metricIds, x0$1)))).groupBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4._1$mcJ$sp())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            Seq values = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), (Object)SQLMetrics$.MODULE$.stringValue((String)metricTypes.apply((Object)BoxesRunTime.boxToLong((long)id)), (Seq<Object>)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).toSeq()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return exec.metricsValues() != null ? exec.metricsValues() : aggregatedMetrics;
    }

    private void updateStageMetrics(int stageId, int attemptId, long taskId, Seq<AccumulableInfo> accumUpdates, boolean succeeded) {
        Object object = new Object();
        try {
            Option$.MODULE$.apply((Object)this.stageMetrics().get(BoxesRunTime.boxToInteger((int)stageId))).foreach((Function1 & Serializable & scala.Serializable)metrics -> {
                if (metrics.attemptId() != attemptId || new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(metrics.accumulatorIds())).isEmpty()) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                LiveTaskMetrics oldTaskMetrics = metrics.taskMetrics().get(BoxesRunTime.boxToLong((long)taskId));
                if (oldTaskMetrics != null && oldTaskMetrics.succeeded()) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                Seq updates = (Seq)((SeqLike)accumUpdates.filter((Function1 & Serializable & scala.Serializable)acc -> BoxesRunTime.boxToBoolean((boolean)SQLAppStatusListener.$anonfun$updateStageMetrics$2(metrics, acc)))).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.id()), (Ordering)Ordering.Long$.MODULE$);
                if (updates.isEmpty()) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                long[] ids = new long[updates.size()];
                long[] values = new long[updates.size()];
                ((IterableLike)updates.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SQLAppStatusListener.$anonfun$updateStageMetrics$4(ids, values, x0$1);
                    return BoxedUnit.UNIT;
                });
                return metrics.taskMetrics().put(BoxesRunTime.boxToLong((long)taskId), new LiveTaskMetrics(ids, values, succeeded));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void onExecutionStart(SparkListenerSQLExecutionStart event) {
        SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = event;
        if (sparkListenerSQLExecutionStart == null) {
            throw new MatchError((Object)sparkListenerSQLExecutionStart);
        }
        long executionId = sparkListenerSQLExecutionStart.executionId();
        String description = sparkListenerSQLExecutionStart.description();
        String details = sparkListenerSQLExecutionStart.details();
        String physicalPlanDescription = sparkListenerSQLExecutionStart.physicalPlanDescription();
        SparkPlanInfo sparkPlanInfo = sparkListenerSQLExecutionStart.sparkPlanInfo();
        long time = sparkListenerSQLExecutionStart.time();
        Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToLong((long)executionId), (Object)description, (Object)details, (Object)physicalPlanDescription, (Object)sparkPlanInfo, (Object)BoxesRunTime.boxToLong((long)time));
        Tuple6 tuple62 = tuple6;
        long executionId2 = BoxesRunTime.unboxToLong((Object)tuple62._1());
        String description2 = (String)tuple62._2();
        String details2 = (String)tuple62._3();
        String physicalPlanDescription2 = (String)tuple62._4();
        SparkPlanInfo sparkPlanInfo2 = (SparkPlanInfo)tuple62._5();
        long time2 = BoxesRunTime.unboxToLong((Object)tuple62._6());
        SparkPlanGraph planGraph = SparkPlanGraph$.MODULE$.apply(sparkPlanInfo2);
        List sqlPlanMetrics = ((TraversableOnce)planGraph.allNodes().flatMap((Function1 & Serializable & scala.Serializable)node -> (Seq)node.metrics().map((Function1 & Serializable & scala.Serializable)metric -> new Tuple2((Object)BoxesRunTime.boxToLong((long)metric.accumulatorId()), metric), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).values().toList();
        SparkPlanGraphWrapper graphToStore = new SparkPlanGraphWrapper(executionId2, (Seq<SparkPlanGraphNodeWrapper>)SQLAppStatusListener.toStoredNodes$1(planGraph.nodes()), planGraph.edges());
        this.kvstore.write((Object)graphToStore);
        LiveExecutionData exec = this.getOrCreateExecution(executionId2);
        exec.description_$eq(description2);
        exec.details_$eq(details2);
        exec.physicalPlanDescription_$eq(physicalPlanDescription2);
        exec.metrics_$eq((Seq<SQLPlanMetric>)sqlPlanMetrics);
        exec.submissionTime_$eq(time2);
        this.update(exec, this.update$default$2());
    }

    private void onExecutionEnd(SparkListenerSQLExecutionEnd event) {
        SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = event;
        if (sparkListenerSQLExecutionEnd == null) {
            throw new MatchError((Object)sparkListenerSQLExecutionEnd);
        }
        long executionId = sparkListenerSQLExecutionEnd.executionId();
        long time = sparkListenerSQLExecutionEnd.time();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(executionId, time);
        Tuple2.mcJJ.sp sp3 = sp2;
        long executionId2 = sp3._1$mcJ$sp();
        long time2 = sp3._2$mcJ$sp();
        Option$.MODULE$.apply((Object)this.liveExecutions().get(BoxesRunTime.boxToLong((long)executionId2))).foreach((Function1 & Serializable & scala.Serializable)exec -> {
            SQLAppStatusListener.$anonfun$onExecutionEnd$1(this, time2, exec);
            return BoxedUnit.UNIT;
        });
    }

    private void removeStaleMetricsData(LiveExecutionData exec) {
        Set activeStages = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveExecutions().values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)other -> {
            LiveExecutionData liveExecutionData = other;
            LiveExecutionData liveExecutionData2 = exec;
            return (liveExecutionData == null ? liveExecutionData2 != null : !((Object)((Object)liveExecutionData)).equals((Object)liveExecutionData2)) ? other.stages() : Nil$.MODULE$;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.stageMetrics().keySet()).asScala()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> !activeStages.contains((Object)BoxesRunTime.boxToInteger((int)x$9)))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> this.stageMetrics().remove(x$1));
    }

    private void onDriverAccumUpdates(SparkListenerDriverAccumUpdates event) {
        SparkListenerDriverAccumUpdates sparkListenerDriverAccumUpdates = event;
        if (sparkListenerDriverAccumUpdates == null) {
            throw new MatchError((Object)sparkListenerDriverAccumUpdates);
        }
        long executionId = sparkListenerDriverAccumUpdates.executionId();
        Seq<Tuple2<Object, Object>> accumUpdates = sparkListenerDriverAccumUpdates.accumUpdates();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)executionId), accumUpdates);
        Tuple2 tuple22 = tuple2;
        long executionId2 = tuple22._1$mcJ$sp();
        Seq accumUpdates2 = (Seq)tuple22._2();
        Option$.MODULE$.apply((Object)this.liveExecutions().get(BoxesRunTime.boxToLong((long)executionId2))).foreach((Function1 & Serializable & scala.Serializable)exec -> {
            SQLAppStatusListener.$anonfun$onDriverAccumUpdates$1(this, accumUpdates2, exec);
            return BoxedUnit.UNIT;
        });
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            this.onExecutionStart(sparkListenerSQLExecutionStart);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            this.onExecutionEnd(sparkListenerSQLExecutionEnd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerDriverAccumUpdates) {
            SparkListenerDriverAccumUpdates sparkListenerDriverAccumUpdates = (SparkListenerDriverAccumUpdates)sparkListenerEvent;
            this.onDriverAccumUpdates(sparkListenerDriverAccumUpdates);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private LiveExecutionData getOrCreateExecution(long executionId) {
        return this.liveExecutions().computeIfAbsent(BoxesRunTime.boxToLong((long)executionId), new Function<Object, LiveExecutionData>(null, executionId){
            private final long executionId$2;

            public <V> Function<V, LiveExecutionData> compose(Function<? super V, ? extends Object> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Object, V> andThen(Function<? super LiveExecutionData, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public LiveExecutionData apply(long key) {
                return new LiveExecutionData(this.executionId$2);
            }
            {
                this.executionId$2 = executionId$2;
            }
        });
    }

    private void update(LiveExecutionData exec, boolean force) {
        block1: {
            long now;
            block2: {
                block0: {
                    now = System.nanoTime();
                    if (exec.endEvents() < exec.jobs().size() + 1) break block0;
                    exec.write(this.kvstore, now, exec.write$default$3());
                    this.removeStaleMetricsData(exec);
                    this.liveExecutions().remove(BoxesRunTime.boxToLong((long)exec.executionId()));
                    break block1;
                }
                if (!force) break block2;
                exec.write(this.kvstore, now, exec.write$default$3());
                break block1;
            }
            if (this.liveUpdatePeriodNs() < 0L || now - exec.lastWriteTime() <= this.liveUpdatePeriodNs()) break block1;
            exec.write(this.kvstore, now, exec.write$default$3());
        }
    }

    private boolean update$default$2() {
        return false;
    }

    private boolean isSQLStage(int stageId) {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveExecutions().values()).asScala()).exists((Function1 & Serializable & scala.Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)SQLAppStatusListener.$anonfun$isSQLStage$1(stageId, exec)));
    }

    private void cleanupExecutions(long count) {
        long countToDelete = count - (long)BoxesRunTime.unboxToInt((Object)this.conf.get(StaticSQLConf$.MODULE$.UI_RETAINED_EXECUTIONS()));
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(SQLExecutionUIData.class).index("completionTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SQLAppStatusListener.$anonfun$cleanupExecutions$1(x$11)));
        toDelete.foreach((Function1 & Serializable & scala.Serializable)e -> {
            SQLAppStatusListener.$anonfun$cleanupExecutions$2(this, e);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$3(SQLAppStatusListener $this, long now$1, LiveExecutionData exec) {
        exec.metricsValues_$eq($this.aggregateMetrics(exec));
        exec.write($this.kvstore, now$1, exec.write$default$3());
    }

    public static final /* synthetic */ LiveStageMetrics $anonfun$onJobStart$4(SQLAppStatusListener $this, List accumIds$1, int id) {
        return $this.stageMetrics().put(BoxesRunTime.boxToInteger((int)id), new LiveStageMetrics(id, 0, (long[])accumIds$1.toArray(ClassTag$.MODULE$.Long()), new ConcurrentHashMap<Object, LiveTaskMetrics>()));
    }

    public static final /* synthetic */ void $anonfun$onStageSubmitted$1(SparkListenerStageSubmitted event$1, LiveStageMetrics metrics) {
        metrics.taskMetrics().clear();
        metrics.attemptId_$eq(event$1.stageInfo().attemptNumber());
    }

    public static final /* synthetic */ void $anonfun$onJobEnd$1(SQLAppStatusListener $this, SparkListenerJobEnd event$2, LiveExecutionData exec) {
        block0: {
            if (!exec.jobs().contains((Object)BoxesRunTime.boxToInteger((int)event$2.jobId()))) break block0;
            JobResult jobResult = event$2.jobResult();
            JobExecutionStatus jobExecutionStatus = JobSucceeded$.MODULE$.equals(jobResult) ? JobExecutionStatus.SUCCEEDED : JobExecutionStatus.FAILED;
            JobExecutionStatus result = jobExecutionStatus;
            exec.jobs_$eq((Map<Object, JobExecutionStatus>)exec.jobs().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)event$2.jobId())), (Object)result)));
            exec.endEvents_$eq(exec.endEvents() + 1);
            $this.update(exec, $this.update$default$2());
        }
    }

    public static final /* synthetic */ void $anonfun$onExecutorMetricsUpdate$1(SQLAppStatusListener $this, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        long taskId = BoxesRunTime.unboxToLong((Object)tuple4._1());
        int stageId = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int attemptId = BoxesRunTime.unboxToInt((Object)tuple4._3());
        Seq accumUpdates = (Seq)tuple4._4();
        $this.updateStageMetrics(stageId, attemptId, taskId, (Seq<AccumulableInfo>)accumUpdates, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$aggregateMetrics$6(Seq metricIds$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long id = tuple2._1$mcJ$sp();
        boolean bl = metricIds$1.contains((Object)BoxesRunTime.boxToLong((long)id));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$updateStageMetrics$2(LiveStageMetrics metrics$1, AccumulableInfo acc) {
        return acc.update().isDefined() && new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(metrics$1.accumulatorIds())).contains((Object)BoxesRunTime.boxToLong((long)acc.id()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$updateStageMetrics$4(long[] ids$1, long[] values$1, Tuple2 x0$1) {
        long l;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        AccumulableInfo acc = (AccumulableInfo)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        ids$1[idx] = acc.id();
        Object object = acc.update().get();
        if (object instanceof String) {
            String string = (String)object;
            l = new StringOps(Predef$.MODULE$.augmentString(string)).toLong();
        } else {
            long l2;
            if (!(object instanceof Long)) throw new IllegalArgumentException(new StringBuilder(12).append("Unexpected: ").append(object).toString());
            l = l2 = BoxesRunTime.unboxToLong((Object)object);
        }
        values$1[idx] = l;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Seq toStoredNodes$1(Seq nodes) {
        return (Seq)nodes.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkPlanGraphNodeWrapper sparkPlanGraphNodeWrapper;
            SparkPlanGraphNode sparkPlanGraphNode = x0$1;
            if (sparkPlanGraphNode instanceof SparkPlanGraphCluster) {
                SparkPlanGraphCluster sparkPlanGraphCluster = (SparkPlanGraphCluster)sparkPlanGraphNode;
                SparkPlanGraphClusterWrapper storedCluster = new SparkPlanGraphClusterWrapper(sparkPlanGraphCluster.id(), sparkPlanGraphCluster.name(), sparkPlanGraphCluster.desc(), (Seq<SparkPlanGraphNodeWrapper>)SQLAppStatusListener.toStoredNodes$1(sparkPlanGraphCluster.nodes()), sparkPlanGraphCluster.metrics());
                sparkPlanGraphNodeWrapper = new SparkPlanGraphNodeWrapper(null, storedCluster);
            } else {
                sparkPlanGraphNodeWrapper = new SparkPlanGraphNodeWrapper(sparkPlanGraphNode, null);
            }
            return sparkPlanGraphNodeWrapper;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$onExecutionEnd$1(SQLAppStatusListener $this, long time$1, LiveExecutionData exec) {
        exec.metricsValues_$eq($this.aggregateMetrics(exec));
        exec.completionTime_$eq((Option<Date>)new Some((Object)new Date(time$1)));
        exec.endEvents_$eq(exec.endEvents() + 1);
        $this.update(exec, $this.update$default$2());
        $this.removeStaleMetricsData(exec);
    }

    public static final /* synthetic */ void $anonfun$onDriverAccumUpdates$1(SQLAppStatusListener $this, Seq accumUpdates$2, LiveExecutionData exec) {
        exec.driverAccumUpdates_$eq((Map<Object, Object>)exec.driverAccumUpdates().$plus$plus((GenTraversableOnce)accumUpdates$2));
        $this.update(exec, $this.update$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$isSQLStage$1(int stageId$1, LiveExecutionData exec) {
        return exec.stages().contains((Object)BoxesRunTime.boxToInteger((int)stageId$1));
    }

    public static final /* synthetic */ boolean $anonfun$cleanupExecutions$1(SQLExecutionUIData x$11) {
        return x$11.completionTime().isDefined();
    }

    public static final /* synthetic */ void $anonfun$cleanupExecutions$2(SQLAppStatusListener $this, SQLExecutionUIData e) {
        $this.kvstore.delete(e.getClass(), (Object)BoxesRunTime.boxToLong((long)e.executionId()));
        $this.kvstore.delete(SparkPlanGraphWrapper.class, (Object)BoxesRunTime.boxToLong((long)e.executionId()));
    }

    public SQLAppStatusListener(SparkConf conf, ElementTrackingStore kvstore, boolean live) {
        this.conf = conf;
        this.kvstore = kvstore;
        this.live = live;
        Logging.$init$((Logging)this);
        this.liveUpdatePeriodNs = live ? BoxesRunTime.unboxToLong((Object)conf.get(config$.MODULE$.LIVE_ENTITY_UPDATE_PERIOD())) : -1L;
        this.liveExecutions = new ConcurrentHashMap();
        this.stageMetrics = new ConcurrentHashMap();
        kvstore.addTrigger(SQLExecutionUIData.class, (long)BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.UI_RETAINED_EXECUTIONS())), (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)count -> this.cleanupExecutions(count));
        kvstore.onFlush((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if ($this.live) break block0;
                long now = System.nanoTime();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveExecutions().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)exec -> {
                    SQLAppStatusListener.$anonfun$new$3(this, now, exec);
                    return BoxedUnit.UNIT;
                });
            }
        });
    }
}

