/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.StreamMetadata;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ManifestFactory$;
import scala.util.control.NonFatal$;

public final class StreamMetadata$
implements Logging,
scala.Serializable {
    public static StreamMetadata$ MODULE$;
    private final Formats format;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StreamMetadata$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Formats format() {
        return this.format;
    }

    public Option<StreamMetadata> read(Path metadataFile, Configuration hadoopConf) {
        None$ none$;
        FileSystem fs = metadataFile.getFileSystem(hadoopConf);
        if (fs.exists(metadataFile)) {
            FSDataInputStream input = null;
            try {
                try {
                    input = fs.open(metadataFile);
                    InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);
                    StreamMetadata metadata = (StreamMetadata)Serialization$.MODULE$.read((Reader)reader, this.format(), ManifestFactory$.MODULE$.classType(StreamMetadata.class));
                    none$ = new Some((Object)metadata);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error reading stream metadata from ").append(metadataFile).toString(), e);
                        throw e;
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void write(StreamMetadata metadata, Path metadataFile, Configuration hadoopConf) {
        CheckpointFileManager.CancellableFSDataOutputStream output = null;
        try {
            CheckpointFileManager fileManager = CheckpointFileManager$.MODULE$.create(metadataFile.getParent(), hadoopConf);
            output = fileManager.createAtomic(metadataFile, false);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)output));
            Serialization$.MODULE$.write((Object)metadata, (Writer)writer, this.format());
            writer.close();
        }
        catch (FileAlreadyExistsException e) {
            if (output != null) {
                output.cancel();
            }
            throw new ConcurrentModificationException(new StringBuilder(50).append("Multiple streaming queries are concurrently using ").append(metadataFile).toString(), e);
        }
        catch (Throwable e) {
            if (output != null) {
                output.cancel();
            }
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Error writing stream metadata ").append(metadata).append(" to ").append(metadataFile).toString(), e);
            throw e;
        }
    }

    public StreamMetadata apply(String id) {
        return new StreamMetadata(id);
    }

    public Option<String> unapply(StreamMetadata x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.id());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StreamMetadata$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.format = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

