/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.CodegenSupport;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.FileSourceStrategy$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.BitSet;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class FileSourceStrategy$
extends SparkStrategy {
    public static final FileSourceStrategy$ MODULE$;

    static {
        new FileSourceStrategy$();
    }

    private boolean shouldPruneBuckets(Option<BucketSpec> bucketSpec) {
        Option<BucketSpec> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = bucketSpec;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    BucketSpec spec = (BucketSpec)some.x();
                    bl = spec.bucketColumnNames().length() == 1 && spec.numBuckets() > 1;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BitSet getExpressionBuckets(Expression expr, String bucketColumnName, int numBuckets) {
        IsNull isNull;
        Expression a;
        BinaryComparison binaryComparison;
        Option option;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a2 = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a2 instanceof Attribute) {
                Attribute attribute = (Attribute)a2;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    String string = attribute.name();
                    String string2 = bucketColumnName;
                    if (string == null) {
                        if (string2 == null) return this.getBucketSetFromValue$1(attribute, v, numBuckets);
                    } else if (string.equals(string2)) {
                        return this.getBucketSetFromValue$1(attribute, v, numBuckets);
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression a3 = in.value();
            Seq list = in.list();
            if (a3 instanceof Attribute) {
                Attribute attribute = (Attribute)a3;
                if (list.forall((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Expression x$1) {
                        return x$1 instanceof Literal;
                    }
                })) {
                    String string = attribute.name();
                    String string3 = bucketColumnName;
                    if (string == null) {
                        if (string3 == null) return this.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Object apply(Expression e) {
                                return e.eval(package$.MODULE$.EmptyRow());
                            }
                        }, Seq$.MODULE$.canBuildFrom()), numBuckets);
                    } else if (string.equals(string3)) {
                        return this.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1)new /* invalid duplicate definition of identical inner class */, Seq$.MODULE$.canBuildFrom()), numBuckets);
                    }
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression a4 = inSet.child();
            Set hset = inSet.hset();
            if (a4 instanceof Attribute) {
                Attribute attribute = (Attribute)a4;
                String string = attribute.name();
                String string4 = bucketColumnName;
                if (string == null) {
                    if (string4 == null) return this.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                } else if (string.equals(string4)) {
                    return this.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                }
            }
        }
        if (expression instanceof IsNull && (a = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a;
            String string = attribute.name();
            String string5 = bucketColumnName;
            if (string == null) {
                if (string5 == null) return this.getBucketSetFromValue$1(attribute, null, numBuckets);
            } else if (string.equals(string5)) {
                return this.getBucketSetFromValue$1(attribute, null, numBuckets);
            }
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            return this.getExpressionBuckets(left, bucketColumnName, numBuckets).$amp(this.getExpressionBuckets(right, bucketColumnName, numBuckets));
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.getExpressionBuckets(left, bucketColumnName, numBuckets).$bar(this.getExpressionBuckets(right, bucketColumnName, numBuckets));
        }
        BitSet matchedBuckets = new BitSet(numBuckets);
        matchedBuckets.setUntil(numBuckets);
        return matchedBuckets;
    }

    private Option<BitSet> genBucketSet(Seq<Expression> normalizedFilters, BucketSpec bucketSpec) {
        if (normalizedFilters.isEmpty()) {
            return None$.MODULE$;
        }
        String bucketColumnName = (String)bucketSpec.bucketColumnNames().head();
        int numBuckets = bucketSpec.numBuckets();
        Expression normalizedFiltersAndExpr = (Expression)normalizedFilters.reduce((Function2)And$.MODULE$);
        BitSet matchedBuckets = this.getExpressionBuckets(normalizedFiltersAndExpr, bucketColumnName, numBuckets);
        int numBucketsSelected = matchedBuckets.cardinality();
        this.logInfo((Function0)new Serializable(numBuckets, numBucketsSelected){
            public static final long serialVersionUID = 0L;
            private final int numBuckets$2;
            private final int numBucketsSelected$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pruned ", " out of ", " buckets."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.numBuckets$2 - this.numBucketsSelected$1)), BoxesRunTime.boxToInteger((int)this.numBuckets$2)}));
            }
            {
                this.numBuckets$2 = numBuckets$2;
                this.numBucketsSelected$1 = numBucketsSelected$1;
            }
        });
        return numBucketsSelected == numBuckets ? None$.MODULE$ : new Some((Object)matchedBuckets);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<SparkPlan> apply(LogicalPlan plan) {
        CodegenSupport withProjections;
        LogicalPlan logicalPlan2 = plan;
        Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan2);
        if (option.isEmpty()) return Nil$.MODULE$;
        Seq projects = (Seq)((Tuple3)option.get())._1();
        Seq filters = (Seq)((Tuple3)option.get())._2();
        LogicalPlan l = (LogicalPlan)((Tuple3)option.get())._3();
        if (!(l instanceof LogicalRelation)) return Nil$.MODULE$;
        LogicalRelation logicalRelation = (LogicalRelation)l;
        BaseRelation fsRelation = logicalRelation.relation();
        Option<CatalogTable> table = logicalRelation.catalogTable();
        if (!(fsRelation instanceof HadoopFsRelation)) return Nil$.MODULE$;
        HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
        ExpressionSet filterSet = ExpressionSet$.MODULE$.apply((TraversableOnce)filters);
        Seq normalizedFilters = (Seq)filters.map((Function1)new Serializable(logicalRelation){
            public static final long serialVersionUID = 0L;
            public final LogicalRelation x3$1;

            public final Expression apply(Expression e) {
                return (Expression)e.transform((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof AttributeReference) {
                            AttributeReference attributeReference = (AttributeReference)A1;
                            object = attributeReference.withName(((AttributeReference)this.$outer.x3$1.output().find((Function1)new Serializable(this, attributeReference){
                                public static final long serialVersionUID = 0L;
                                private final AttributeReference x2$1;

                                public final boolean apply(AttributeReference x$2) {
                                    return x$2.semanticEquals((Expression)this.x2$1);
                                }
                                {
                                    this.x2$1 = x2$1;
                                }
                            }).get()).name());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x1) {
                        Expression expression = x1;
                        boolean bl = expression instanceof AttributeReference;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.x3$1 = x3$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq partitionColumns = logicalRelation.resolve(hadoopFsRelation.partitionSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply((Iterable)partitionColumns);
        ExpressionSet partitionKeyFilters = ExpressionSet$.MODULE$.apply((TraversableOnce)((TraversableLike)normalizedFilters.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$3) {
                return SubqueryExpression$.MODULE$.hasSubquery(x$3);
            }
        })).filter((Function1)new Serializable(partitionSet){
            public static final long serialVersionUID = 0L;
            private final AttributeSet partitionSet$1;

            public final boolean apply(Expression x$4) {
                return x$4.references().subsetOf(this.partitionSet$1);
            }
            {
                this.partitionSet$1 = partitionSet$1;
            }
        }));
        this.logInfo((Function0)new Serializable(partitionKeyFilters){
            public static final long serialVersionUID = 0L;
            private final ExpressionSet partitionKeyFilters$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pruning directories with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionKeyFilters$1.mkString(",")}));
            }
            {
                this.partitionKeyFilters$1 = partitionKeyFilters$1;
            }
        });
        Option<BucketSpec> bucketSpec = hadoopFsRelation.bucketSpec();
        Option<BitSet> bucketSet = this.shouldPruneBuckets(bucketSpec) ? this.genBucketSet((Seq<Expression>)normalizedFilters, (BucketSpec)bucketSpec.get()) : None$.MODULE$;
        Seq dataColumns = logicalRelation.resolve(hadoopFsRelation.dataSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
        Seq dataFilters = (Seq)normalizedFilters.filter((Function1)new Serializable(partitionSet){
            public static final long serialVersionUID = 0L;
            private final AttributeSet partitionSet$1;

            public final boolean apply(Expression x$5) {
                return x$5.references().intersect(this.partitionSet$1).isEmpty();
            }
            {
                this.partitionSet$1 = partitionSet$1;
            }
        });
        Set afterScanFilters = (Set)filterSet.$minus$minus((GenTraversableOnce)partitionKeyFilters.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$6) {
                return x$6.references().nonEmpty();
            }
        }));
        this.logInfo((Function0)new Serializable(afterScanFilters){
            public static final long serialVersionUID = 0L;
            private final Set afterScanFilters$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Post-Scan Filters: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.afterScanFilters$1.mkString(",")}));
            }
            {
                this.afterScanFilters$1 = afterScanFilters$1;
            }
        });
        AttributeSet filterAttributes = AttributeSet$.MODULE$.apply((Iterable)afterScanFilters);
        Seq requiredExpressions = (Seq)filterAttributes.toSeq().$plus$plus((GenTraversableOnce)projects, Seq$.MODULE$.canBuildFrom());
        AttributeSet requiredAttributes = AttributeSet$.MODULE$.apply((Iterable)requiredExpressions);
        Seq readDataColumns = (Seq)((TraversableLike)dataColumns.filter((Function1)new Serializable(requiredAttributes){
            public static final long serialVersionUID = 0L;
            private final AttributeSet requiredAttributes$1;

            public final boolean apply(NamedExpression elem) {
                return this.requiredAttributes$1.contains(elem);
            }
            {
                this.requiredAttributes$1 = requiredAttributes$1;
            }
        })).filterNot((Function1)new Serializable(partitionColumns){
            public static final long serialVersionUID = 0L;
            private final Seq partitionColumns$1;

            public final boolean apply(Object elem) {
                return this.partitionColumns$1.contains(elem);
            }
            {
                this.partitionColumns$1 = partitionColumns$1;
            }
        });
        StructType outputSchema = package$.MODULE$.AttributeSeq(readDataColumns).toStructType();
        this.logInfo((Function0)new Serializable(outputSchema){
            public static final long serialVersionUID = 0L;
            private final StructType outputSchema$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output Data Schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputSchema$1.simpleString(5)}));
            }
            {
                this.outputSchema$1 = outputSchema$1;
            }
        });
        Seq outputAttributes = (Seq)readDataColumns.$plus$plus((GenTraversableOnce)partitionColumns, Seq$.MODULE$.canBuildFrom());
        FileSourceScanExec scan = new FileSourceScanExec(hadoopFsRelation, (Seq<Attribute>)outputAttributes, outputSchema, (Seq<Expression>)partitionKeyFilters.toSeq(), bucketSet, (Seq<Expression>)dataFilters, (Option<TableIdentifier>)table.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TableIdentifier apply(CatalogTable x$7) {
                return x$7.identifier();
            }
        }));
        Option afterScanFilter = afterScanFilters.toSeq().reduceOption((Function2)And$.MODULE$);
        CodegenSupport withFilter = (CodegenSupport)afterScanFilter.map((Function1)new Serializable(scan){
            public static final long serialVersionUID = 0L;
            private final FileSourceScanExec scan$1;

            public final FilterExec apply(Expression x$8) {
                return new FilterExec(x$8, this.scan$1);
            }
            {
                this.scan$1 = scan$1;
            }
        }).getOrElse((Function0)new Serializable(scan){
            public static final long serialVersionUID = 0L;
            private final FileSourceScanExec scan$1;

            public final FileSourceScanExec apply() {
                return this.scan$1;
            }
            {
                this.scan$1 = scan$1;
            }
        });
        Seq seq = projects;
        Seq seq2 = ((QueryPlan)withFilter).output();
        CodegenSupport codegenSupport = withProjections = !(seq != null ? !seq.equals(seq2) : seq2 != null) ? withFilter : new ProjectExec((Seq<NamedExpression>)projects, (SparkPlan)((Object)withFilter));
        return Nil$.MODULE$.$colon$colon((Object)codegenSupport);
    }

    public final int org$apache$spark$sql$execution$datasources$FileSourceStrategy$$getBucketNumber$1(Attribute attr, Object v, int numBuckets$1) {
        return BucketingUtils$.MODULE$.getBucketIdFromValue(attr, numBuckets$1, v);
    }

    private final BitSet getBucketSetFromIterable$1(Attribute attr, Iterable iter, int numBuckets$1) {
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        ((IterableLike)iter.map((Function1)new Serializable(numBuckets$1, attr){
            public static final long serialVersionUID = 0L;
            private final int numBuckets$1;
            private final Attribute attr$1;

            public final int apply(Object v) {
                return FileSourceStrategy$.MODULE$.org$apache$spark$sql$execution$datasources$FileSourceStrategy$$getBucketNumber$1(this.attr$1, v, this.numBuckets$1);
            }
            {
                this.numBuckets$1 = numBuckets$1;
                this.attr$1 = attr$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(matchedBuckets){
            public static final long serialVersionUID = 0L;
            private final BitSet matchedBuckets$1;

            public final void apply(int bucketNum) {
                this.apply$mcVI$sp(bucketNum);
            }

            public void apply$mcVI$sp(int bucketNum) {
                this.matchedBuckets$1.set(bucketNum);
            }
            {
                this.matchedBuckets$1 = matchedBuckets$1;
            }
        });
        return matchedBuckets;
    }

    private final BitSet getBucketSetFromValue$1(Attribute attr, Object v, int numBuckets$1) {
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        matchedBuckets.set(this.org$apache$spark$sql$execution$datasources$FileSourceStrategy$$getBucketNumber$1(attr, v, numBuckets$1));
        return matchedBuckets;
    }

    private FileSourceStrategy$() {
        MODULE$ = this;
    }
}

