/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasStepSize$class;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol$class;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTParams$class;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.GBTRegressorParams$class;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleModel$class;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.TreeRegressorParams$class;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u0001\u0003\u00015\u0011!c\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fY*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\b\u001bA\u0019b\u0003\u0003B\b\u0011%ai\u0011\u0001B\u0005\u0003#\u0011\u0011q\u0002\u0015:fI&\u001cG/[8o\u001b>$W\r\u001c\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\ta\u0001\\5oC2<\u0017BA\f\u0015\u0005\u00191Vm\u0019;peB\u0011\u0011\u0004A\u0007\u0002\u0005A\u00111DH\u0007\u00029)\u0011Q\u0004B\u0001\u0005iJ,W-\u0003\u0002 9\t\u0011rI\u0011+SK\u001e\u0014Xm]:peB\u000b'/Y7t!\rY\u0012eI\u0005\u0003Eq\u0011\u0011\u0003\u0016:fK\u0016s7/Z7cY\u0016lu\u000eZ3m!\tIB%\u0003\u0002&\u0005\tYB)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003W!\u0012!\"\u0014'Xe&$\u0018M\u00197f!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\u0019\u0004A!b\u0001\n\u0003\"\u0014aA;jIV\tQ\u0007\u0005\u00027s9\u0011QfN\u0005\u0003q9\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001H\f\u0005\t{\u0001\u0011\t\u0011)A\u0005k\u0005!Q/\u001b3!\u0011!y\u0004A!b\u0001\n\u0013\u0001\u0015AB0ue\u0016,7/F\u0001B!\ri#iI\u0005\u0003\u0007:\u0012Q!\u0011:sCfD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006I!Q\u0001\b?R\u0014X-Z:!\u0011!9\u0005A!b\u0001\n\u0013A\u0015\u0001D0ue\u0016,w+Z5hQR\u001cX#A%\u0011\u00075\u0012%\n\u0005\u0002.\u0017&\u0011AJ\f\u0002\u0007\t>,(\r\\3\t\u00119\u0003!\u0011!Q\u0001\n%\u000bQb\u0018;sK\u0016<V-[4iiN\u0004\u0003\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011I)\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002%B\u0011QfU\u0005\u0003):\u00121!\u00138u\u0011!1\u0006A!A!\u0002\u0013\u0011\u0016\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003B\u0002-\u0001\t\u0003!\u0011,\u0001\u0004=S:LGO\u0010\u000b\u00061i[F,\u0018\u0005\u0006g]\u0003\r!\u000e\u0005\u0006\u007f]\u0003\r!\u0011\u0005\u0006\u000f^\u0003\r!\u0013\u0005\u0006!^\u0003\rA\u0015\u0005\u00061\u0002!\ta\u0018\u000b\u00051\u0001\f'\rC\u00034=\u0002\u0007Q\u0007C\u0003@=\u0002\u0007\u0011\tC\u0003H=\u0002\u0007\u0011\nK\u0002_I*\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002jM\n)1+\u001b8dK\u0006\n1.A\u00032]Qr\u0003\u0007C\u0003n\u0001\u0011\u0005\u0003)A\u0003ue\u0016,7\u000fK\u0002mI*Dq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011+A\u0006hKRtU/\u001c+sK\u0016\u001c\bfA8ee\u0006\n1/A\u00033]Ar\u0003\u0007\u0003\u0004v\u0001\u0001\u0006IAU\u0001\rO\u0016$h*^7Ue\u0016,7\u000f\t\u0015\u0004i\u0012\u0014\b\"\u0002=\u0001\t\u0003B\u0015a\u0003;sK\u0016<V-[4iiND3a\u001e3k\u0011\u0015Y\b\u0001\"\u0015}\u00035!(/\u00198tM>\u0014X.S7qYR\u0019Q0a\t\u0011\u0007y\fiBD\u0002\u0000\u0003/qA!!\u0001\u0002\u00149!\u00111AA\t\u001d\u0011\t)!a\u0004\u000f\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0004\u0003+1\u0011aA:rY&!\u0011\u0011DA\u000e\u0003\u001d\u0001\u0018mY6bO\u0016T1!!\u0006\u0007\u0013\u0011\ty\"!\t\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA\r\u00037Aq!!\n{\u0001\u0004\t9#A\u0004eCR\f7/\u001a;1\t\u0005%\u0012Q\u0007\t\u0007\u0003W\ti#!\r\u000e\u0005\u0005m\u0011\u0002BA\u0018\u00037\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u00024\u0005UB\u0002\u0001\u0003\r\u0003o\t\u0019#!A\u0001\u0002\u000b\u0005\u0011\u0011\b\u0002\u0004?\u0012\u0012\u0014\u0003BA\u001e\u0003\u0003\u00022!LA\u001f\u0013\r\tyD\f\u0002\b\u001d>$\b.\u001b8h!\ri\u00131I\u0005\u0004\u0003\u000br#aA!os\"9\u0011\u0011\n\u0001\u0005B\u0005-\u0013a\u00029sK\u0012L7\r\u001e\u000b\u0004\u0015\u00065\u0003bBA(\u0003\u000f\u0002\rAE\u0001\tM\u0016\fG/\u001e:fg\"A\u00111\u000b\u0001C\u0002\u0013\u0005\u0011+\u0001\u0005ok6$&/Z3t\u0011\u001d\t9\u0006\u0001Q\u0001\nI\u000b\u0011B\\;n)J,Wm\u001d\u0011\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005!1m\u001c9z)\rA\u0012q\f\u0005\t\u0003C\nI\u00061\u0001\u0002d\u0005)Q\r\u001f;sCB!\u0011QMA6\u001b\t\t9GC\u0002\u0002j\u0011\tQ\u0001]1sC6LA!!\u001c\u0002h\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002Z\u0011T\u0007bBA:\u0001\u0011\u0005\u0013QO\u0001\ti>\u001cFO]5oOR\tQ\u0007\u000b\u0003\u0002r\u0011T\u0007BCA>\u0001!\u0015\r\u0011\"\u0001\u0002~\u0005\u0011b-Z1ukJ,\u0017*\u001c9peR\fgnY3t+\u0005\u0011\u0002\u0006BA=IJD\u0011\"a!\u0001\u0011\u0003\u0005\u000b\u0015\u0002\n\u0002'\u0019,\u0017\r^;sK&k\u0007o\u001c:uC:\u001cWm\u001d\u0011)\t\u0005\u0005EM\u001d\u0005\t\u0003\u0013\u0003A\u0011\u0001\u0003\u0002\f\u0006)Ao\\(mIV\u0011\u0011Q\u0012\t\u0005\u0003\u001f\u000bY*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003\u0015iw\u000eZ3m\u0015\ri\u0012q\u0013\u0006\u0004\u000333\u0011!B7mY&\u0014\u0017\u0002BAO\u0003#\u0013\u0011d\u0012:bI&,g\u000e\u001e\"p_N$X\r\u001a+sK\u0016\u001cXj\u001c3fY\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0016!F3wC2,\u0018\r^3FC\u000eD\u0017\n^3sCRLwN\u001c\u000b\u0006\u0013\u0006\u0015\u0016\u0011\u0017\u0005\t\u0003K\ty\n1\u0001\u0002(B\"\u0011\u0011VAW!\u0019\tY#!\f\u0002,B!\u00111GAW\t1\ty+!*\u0002\u0002\u0003\u0005)\u0011AA\u001d\u0005\ryFe\r\u0005\b\u0003g\u000by\n1\u00016\u0003\u0011awn]:)\u000b\u0005}E-a.\"\u0005\u0005e\u0016!\u0002\u001a/i9\u0002\u0004bBA_\u0001\u0011\u0005\u0013qX\u0001\u0006oJLG/Z\u000b\u0003\u0003\u0003\u00042aJAb\u0013\r\t)\r\u000b\u0002\t\u001b2;&/\u001b;fe\"\"\u00111\u00183sQ\r\u0001AM[\u0004\b\u0003\u001b\u0014\u0001\u0012AAh\u0003I9%\t\u0016*fOJ,7o]5p]6{G-\u001a7\u0011\u0007e\t\tN\u0002\u0004\u0002\u0005!\u0005\u00111[\n\b\u0003#\f).a7-!\ri\u0013q[\u0005\u0004\u00033t#AB!osJ+g\r\u0005\u0003(\u0003;D\u0012bAApQ\tQQ\n\u0014*fC\u0012\f'\r\\3\t\u000fa\u000b\t\u000e\"\u0001\u0002dR\u0011\u0011q\u001a\u0005\t\u0003O\f\t\u000e\"\u0011\u0002j\u0006!!/Z1e+\t\tY\u000f\u0005\u0003(\u0003[D\u0012bAAxQ\tAQ\n\u0014*fC\u0012,'\u000f\u000b\u0003\u0002f\u0012\u0014\b\u0002CA{\u0003#$\t%a>\u0002\t1|\u0017\r\u001a\u000b\u00041\u0005e\bbBA~\u0003g\u0004\r!N\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u0002t\u0012\u0014h!\u0003B\u0001\u0003#\u0004\u0011\u0011\u001bB\u0002\u0005a9%\t\u0016*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u0005\u0003\u007f\f\t\r\u0003\u0006\u0003\b\u0005}(\u0011!Q\u0001\na\t\u0001\"\u001b8ti\u0006t7-\u001a\u0005\b1\u0006}H\u0011\u0001B\u0006)\u0011\u0011iA!\u0005\u0011\t\t=\u0011q`\u0007\u0003\u0003#DqAa\u0002\u0003\n\u0001\u0007\u0001\u0004\u0003\u0005\u0003\u0016\u0005}H\u0011\u000bB\f\u0003!\u0019\u0018M^3J[BdG\u0003\u0002B\r\u0005?\u00012!\fB\u000e\u0013\r\u0011iB\f\u0002\u0005+:LG\u000fC\u0004\u0002|\nM\u0001\u0019A\u001b\u0007\u000f\t\r\u0012\u0011\u001b\u0003\u0003&\tArI\u0011+SK\u001e\u0014Xm]:j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\t\t\u0005\u00121\u001e\u0005\b1\n\u0005B\u0011\u0001B\u0015)\t\u0011Y\u0003\u0005\u0003\u0003\u0010\t\u0005\u0002B\u0003B\u0018\u0005C\u0011\r\u0011\"\u0003\u00032\u0005I1\r\\1tg:\u000bW.Z\u000b\u0003\u0005g\u0001BA!\u000e\u0003@5\u0011!q\u0007\u0006\u0005\u0005s\u0011Y$\u0001\u0003mC:<'B\u0001B\u001f\u0003\u0011Q\u0017M^1\n\u0007i\u00129\u0004C\u0005\u0003D\t\u0005\u0002\u0015!\u0003\u00034\u0005Q1\r\\1tg:\u000bW.\u001a\u0011\t\u0015\t\u001d#\u0011\u0005b\u0001\n\u0013\u0011\t$A\u0007ue\u0016,7\t\\1tg:\u000bW.\u001a\u0005\n\u0005\u0017\u0012\t\u0003)A\u0005\u0005g\ta\u0002\u001e:fK\u000ec\u0017m]:OC6,\u0007\u0005\u0003\u0005\u0002v\n\u0005B\u0011\tB()\rA\"\u0011\u000b\u0005\b\u0003w\u0014i\u00051\u00016\u0011%\u0011)&!5\u0005\u0002\u0011\u00119&A\u0004ge>lw\n\u001c3\u0015\u0013a\u0011IF!\u0018\u0003h\tE\u0004\u0002\u0003B.\u0005'\u0002\r!!$\u0002\u0011=dG-T8eK2D\u0001Ba\u0018\u0003T\u0001\u0007!\u0011M\u0001\u0007a\u0006\u0014XM\u001c;\u0011\u0007e\u0011\u0019'C\u0002\u0003f\t\u0011Ab\u0012\"U%\u0016<'/Z:t_JD\u0001B!\u001b\u0003T\u0001\u0007!1N\u0001\u0014G\u0006$XmZ8sS\u000e\fGNR3biV\u0014Xm\u001d\t\u0006m\t5$KU\u0005\u0004\u0005_Z$aA'ba\"A\u0001Ka\u0015\u0011\u0002\u0003\u0007!\u000b\u0003\u0006\u0003v\u0005E\u0017\u0013!C\u0001\u0005o\n\u0011C\u001a:p[>cG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011IHK\u0002S\u0005wZ#A! \u0011\t\t}$qQ\u0007\u0003\u0005\u0003SAAa!\u0003\u0006\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003O:JAA!#\u0003\u0002\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\t5\u0015\u0011[A\u0001\n\u0013\u0011y)A\u0006sK\u0006$'+Z:pYZ,GC\u0001BI!\u0011\u0011)Da%\n\t\tU%q\u0007\u0002\u0007\u001f\nTWm\u0019;)\t\u0005EGM\u001d\u0015\u0005\u0003\u0017$'\u000f")
public class GBTRegressionModel
extends PredictionModel<Vector, GBTRegressionModel>
implements GBTRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private final String uid;
    private final DecisionTreeRegressionModel[] org$apache$spark$ml$regression$GBTRegressionModel$$_trees;
    private final double[] org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights;
    private final int numFeatures;
    private final int getNumTrees;
    private final int numTrees;
    private Vector featureImportances;
    private final int totalNumNodes;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam validationTol;
    private final DoubleParam stepSize;
    private final Param<String> validationIndicatorCol;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static int fromOld$default$4() {
        return GBTRegressionModel$.MODULE$.fromOld$default$4();
    }

    public static GBTRegressionModel load(String string) {
        return GBTRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GBTRegressionModel> read() {
        return GBTRegressionModel$.MODULE$.read();
    }

    private Vector featureImportances$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.featureImportances;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    private int totalNumNodes$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel$class.totalNumNodes(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.totalNumNodes;
        }
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel$class.javaTreeWeights(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel$class.toDebugString(this);
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param x$1) {
        this.lossType = x$1;
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams$class.getLossType(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams$class.getOldLossType(this);
    }

    @Override
    public Loss convertToOldLossType(String loss2) {
        return GBTRegressorParams$class.convertToOldLossType(this, loss2);
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public TreeRegressorParams setImpurity(String value) {
        return TreeRegressorParams$class.setImpurity(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams$class.getOldImpurity(this);
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final double getValidationTol() {
        return GBTParams$class.getValidationTol(this);
    }

    @Override
    public GBTParams setMaxIter(int value) {
        return GBTParams$class.setMaxIter(this, value);
    }

    @Override
    public GBTParams setStepSize(double value) {
        return GBTParams$class.setStepSize(this, value);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol$class.getValidationIndicatorCol(this);
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final double getStepSize() {
        return HasStepSize$class.getStepSize(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams$class.setFeatureSubsetStrategy(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams$class.getFeatureSubsetStrategy(this);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams$class.setSeed(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public DecisionTreeRegressionModel[] org$apache$spark$ml$regression$GBTRegressionModel$$_trees() {
        return this.org$apache$spark$ml$regression$GBTRegressionModel$$_trees;
    }

    public double[] org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights() {
        return this.org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this.org$apache$spark$ml$regression$GBTRegressionModel$$_trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this.org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTRegressionModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this, bcastModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcastModel$1;

            public final double apply(Object features) {
                return ((GBTRegressionModel)this.bcastModel$1.value()).predict((Vector)features);
            }
            {
                this.bcastModel$1 = bcastModel$1;
            }
        }, ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public double predict(Vector features) {
        double[] treePredictions = (double[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$ml$regression$GBTRegressionModel$$_trees()).map((Function1)new Serializable(this, features){
            public static final long serialVersionUID = 0L;
            private final Vector features$1;

            public final double apply(DecisionTreeRegressionModel x$3) {
                return x$3.rootNode().predictImpl(this.features$1).prediction();
            }
            {
                this.features$1 = features$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.numTrees(), treePredictions, 1, this.org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights(), 1);
    }

    public int numTrees() {
        return this.numTrees;
    }

    @Override
    public GBTRegressionModel copy(ParamMap extra) {
        return (GBTRegressionModel)((Model)this.copyValues(new GBTRegressionModel(this.uid(), this.org$apache$spark$ml$regression$GBTRegressionModel$$_trees(), this.org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTRegressionModel (uid=", ") with ", " trees"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uid(), BoxesRunTime.boxToInteger((int)this.numTrees())}));
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$ml$regression$GBTRegressionModel$$_trees()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DecisionTreeModel apply(DecisionTreeRegressionModel x$4) {
                return x$4.toOld();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), this.org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights());
    }

    public double[] evaluateEachIteration(Dataset<?> dataset, String loss2) {
        RDD data = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object features = ((SeqLike)some.get()).apply(1);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (features instanceof Vector) {
                            Vector vector = (Vector)features;
                            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
                            return labeledPoint;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration((RDD<LabeledPoint>)data, this.trees(), this.treeWeights(), this.convertToOldLossType(loss2), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new GBTRegressionModelWriter(this);
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights2, int numFeatures) {
        this.uid = uid;
        this.org$apache$spark$ml$regression$GBTRegressionModel$$_trees = _trees;
        this.org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights = _treeWeights2;
        this.numFeatures = numFeatures;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasStepSize$class.$init$(this);
        HasValidationIndicatorCol$class.$init$(this);
        GBTParams$class.$init$(this);
        TreeRegressorParams$class.$init$(this);
        GBTRegressorParams$class.$init$(this);
        TreeEnsembleModel$class.$init$(this);
        MLWritable$class.$init$(this);
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])_trees).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "GBTRegressionModel requires at least 1 tree.";
            }
        });
        Predef$.MODULE$.require(_trees.length == _treeWeights2.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressionModel $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"GBTRegressionModel given trees, treeWeights of").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" non-matching lengths (", ", ", ", respectively)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$regression$GBTRegressionModel$$_trees().length), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$regression$GBTRegressionModel$$_treeWeights().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.getNumTrees = this.trees().length;
        this.numTrees = this.trees().length;
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights2) {
        this(uid, _trees, _treeWeights2, -1);
    }

    public static class GBTRegressionModelWriter
    extends MLWriter {
        private final GBTRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            });
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTRegressionModelWriter(GBTRegressionModel instance) {
            this.instance = instance;
        }
    }

    public static class GBTRegressionModelReader
    extends MLReader<GBTRegressionModel> {
        private final String className = GBTRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTRegressionModel load(String path) {
            DefaultFormats$ format2 = DefaultFormats$.MODULE$;
            Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
            if (tuple3 != null) {
                DefaultParamsReader.Metadata metadata = (DefaultParamsReader.Metadata)tuple3._1();
                Tuple2[] treesData = (Tuple2[])tuple3._2();
                double[] treeWeights = (double[])tuple3._3();
                if (metadata != null) {
                    DefaultParamsReader.Metadata metadata2 = metadata;
                    if (treesData != null) {
                        Tuple2[] tuple2Array = treesData;
                        if (treeWeights != null) {
                            DecisionTreeRegressionModel[] trees;
                            Tuple3 tuple32;
                            double[] dArray = treeWeights;
                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)metadata2, (Object)tuple2Array, (Object)dArray);
                            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple33._1();
                            Tuple2[] treesData2 = (Tuple2[])tuple33._2();
                            double[] treeWeights2 = (double[])tuple33._3();
                            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                            int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                            Predef$.MODULE$.require(numTrees == (trees = (DecisionTreeRegressionModel[])Predef$.MODULE$.refArrayOps((Object[])treesData2).map((Function1)new Serializable(this, numFeatures){
                                public static final long serialVersionUID = 0L;
                                private final int numFeatures$1;

                                public final DecisionTreeRegressionModel apply(Tuple2<DefaultParamsReader.Metadata, Node> x0$2) {
                                    Tuple2<DefaultParamsReader.Metadata, Node> tuple2 = x0$2;
                                    if (tuple2 != null) {
                                        DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                                        Node root = (Node)tuple2._2();
                                        DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, this.numFeatures$1);
                                        treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                                        DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                                        return decisionTreeRegressionModel;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.numFeatures$1 = numFeatures$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)))).length, (Function0)new Serializable(this, numTrees, trees){
                                public static final long serialVersionUID = 0L;
                                private final int numTrees$1;
                                private final DecisionTreeRegressionModel[] trees$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTRegressionModel.load expected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" trees based on metadata but found ", " trees."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.trees$1.length)}))).toString();
                                }
                                {
                                    this.numTrees$1 = numTrees$1;
                                    this.trees$1 = trees$1;
                                }
                            });
                            GBTRegressionModel model = new GBTRegressionModel(metadata3.uid(), trees, treeWeights2, numFeatures);
                            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
                            return model;
                        }
                    }
                }
            }
            throw new MatchError(tuple3);
        }
    }
}

