/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\n\u0015\u0001\u0005B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\ty\u0001\u0011\t\u0011)A\u0005[!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u00191\u0005\u0001\"\u0001\u0019\u001f\"9q\f\u0001b\u0001\n\u0013\u0001\u0007BB1\u0001A\u0003%\u0011\u000b\u0003\u0006c\u0001A\u0005\t1!Q\u0001\n\rDqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004i\u0001\u0001\u0006I\u0001\u0018\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019Y\u0007\u0001)A\u00051\")A\u000e\u0001C\u0001[\")\u0011\u000f\u0001C\u0001e\"1A\u000e\u0001C\u00011UDa!\u001d\u0001\u0005\u0002aI\b\"B>\u0001\t\u0013a(\u0001F'vYRLg/\u0019:jCR,w)Y;tg&\fgN\u0003\u0002\u0016-\u0005aA-[:ue&\u0014W\u000f^5p]*\u0011q\u0003G\u0001\u0005gR\fGO\u0003\u0002\u001a5\u0005\u0011Q\u000e\u001c\u0006\u00037q\tQa\u001d9be.T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"aI\u0015\n\u0005)\"#\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001B7fC:,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0003aa\ta\u0001\\5oC2<\u0017B\u0001\u001a0\u0005\u00191Vm\u0019;pe\"\u001a\u0011\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]R\u0012AC1o]>$\u0018\r^5p]&\u0011\u0011H\u000e\u0002\u0006'&t7-Z\u0011\u0002w\u0005)!G\f\u0019/a\u0005)Q.Z1oA!\u001a!\u0001\u000e\u001e\u0002\u0007\r|g/F\u0001A!\tq\u0013)\u0003\u0002C_\t1Q*\u0019;sSbD3a\u0001\u001b;\u0003\u0011\u0019wN\u001e\u0011)\u0007\u0011!$(\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011*c\u0005CA%\u0001\u001b\u0005!\u0002\"B\u0016\u0006\u0001\u0004i\u0003f\u0001&5u!)a(\u0002a\u0001\u0001\"\u001aA\n\u000e\u001e)\u0007\u0015!$\bF\u0002I!nCQa\u000b\u0004A\u0002E\u00032A\u0015,Y\u001b\u0005\u0019&B\u0001\u0019U\u0015\u0005)\u0016A\u00022sK\u0016TX-\u0003\u0002X'\nYA)\u001a8tKZ+7\r^8s!\t\u0019\u0013,\u0003\u0002[I\t1Ai\\;cY\u0016DQA\u0010\u0004A\u0002q\u00032AU/Y\u0013\tq6KA\u0006EK:\u001cX-T1ue&D\u0018\u0001\u00032sK\u0016TX-T;\u0016\u0003E\u000b\u0011B\u0019:fKj,W*\u001e\u0011\u0002\u0007a$\u0013\u0007\u0005\u0003$IrC\u0016BA3%\u0005\u0019!V\u000f\u001d7fe\u0005a!o\\8u'&<W.Y%omV\tA,A\u0007s_>$8+[4nC&sg\u000fI\u0001\u0002kV\t\u0001,\u0001\u0002vA\u0005\u0019\u0001\u000f\u001a4\u0015\u0005as\u0007\"B8\u000f\u0001\u0004i\u0013!\u0001=)\u00079!$(\u0001\u0004m_\u001e\u0004HM\u001a\u000b\u00031NDQa\\\bA\u00025B3a\u0004\u001b;)\tAf\u000fC\u0003p!\u0001\u0007q\u000fE\u0002SqbK!AM*\u0015\u0005aS\b\"B8\u0012\u0001\u00049\u0018\u0001H2bY\u000e,H.\u0019;f\u0007>4\u0018M]5b]\u000e,7i\u001c8ti\u0006tGo]\u000b\u0002G\"\u0012\u0001A \t\u0003k}L1!!\u00017\u00051!UM^3m_B,'/\u00119jQ\r\u0001AG\u000f")
public class MultivariateGaussian
implements scala.Serializable {
    private final Vector mean;
    private final Matrix cov;
    private final DenseVector<Object> breezeMu;
    private final /* synthetic */ Tuple2 x$1;
    private final DenseMatrix<Object> rootSigmaInv;
    private final double u;

    public Vector mean() {
        return this.mean;
    }

    public Matrix cov() {
        return this.cov;
    }

    private DenseVector<Object> breezeMu() {
        return this.breezeMu;
    }

    private DenseMatrix<Object> rootSigmaInv() {
        return this.rootSigmaInv;
    }

    private double u() {
        return this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.asBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.asBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times((Object)v, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) * -0.5;
    }

    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.cov().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) {
            throw new MatchError((Object)eigSym2);
        }
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = new Tuple2((Object)d, (Object)u);
        Tuple2 tuple23 = tuple22;
        DenseVector d2 = (DenseVector)tuple23._1();
        DenseMatrix u2 = (DenseMatrix)tuple23._2();
        double tol = Utils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 > tol).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> v > tol ? package$.MODULE$.sqrt(1.0 / v) : 0.0, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            tuple2 = new Tuple2(pinvS.$times(u2.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mean().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException uex) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
        return tuple2;
    }

    public MultivariateGaussian(Vector mean, Matrix cov) {
        double u;
        DenseMatrix rootSigmaInv;
        block3: {
            Tuple2<DenseMatrix<Object>, Object> tuple2;
            block2: {
                this.mean = mean;
                this.cov = cov;
                Predef$.MODULE$.require(cov.numCols() == cov.numRows(), (Function0 & Serializable & scala.Serializable)() -> "Covariance matrix must be square");
                Predef$.MODULE$.require(mean.size() == cov.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Mean vector length must match covariance matrix size");
                this.breezeMu = mean.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                tuple2 = this.calculateCovarianceConstants();
                if (tuple2 == null) break block2;
                rootSigmaInv = (DenseMatrix)tuple2._1();
                u = tuple2._2$mcD$sp();
                if (rootSigmaInv != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        DenseMatrix denseMatrix = rootSigmaInv;
        double d = u;
        Tuple2 tuple2 = new Tuple2((Object)denseMatrix, (Object)BoxesRunTime.boxToDouble((double)d));
        this.x$1 = tuple2;
        this.rootSigmaInv = (DenseMatrix)this.x$1._1();
        this.u = this.x$1._2$mcD$sp();
    }

    public MultivariateGaussian(DenseVector<Object> mean, DenseMatrix<Object> cov) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mean), Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)cov));
    }
}

