/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\r\u001b\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t%\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u00039\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b=\u0003A\u0011\u0001)\t\u000ba\u0003A\u0011I-\t\u000b\u0015\u0004A\u0011I$\t\u000b\u0019\u0004A\u0011I4\t\r!\u0004A\u0011\t\u0010j\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aa!!\u0004\u0001\t\u0003\n\u0004BBA\b\u0001\u0011\u0005\u0013\u0007\u0003\u0005\u0002\u0012\u0001!\tEGA\n\u0011\u0019\tI\u0002\u0001C!c!A\u00111\u0004\u0001\u0005\u0002y\tibB\u0004\u0002&iA\t!a\n\u0007\reQ\u0002\u0012AA\u0015\u0011\u0019yU\u0003\"\u0001\u00022!9\u00111G\u000b\u0005\u0002\u0005U\u0002\"CA%+\u0005\u0005I\u0011BA&\u00051\u0019\u0006/\u0019:tKZ+7\r^8s\u0015\tYB$\u0001\u0004mS:\fGn\u001a\u0006\u0003;y\t!!\u001c7\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u0017/\u001b\u0005Q\u0012BA\u0018\u001b\u0005\u00191Vm\u0019;pe\u0006!1/\u001b>f+\u0005\u0011\u0004CA\u00144\u0013\t!\u0004FA\u0002J]R\fQa]5{K\u0002\nq!\u001b8eS\u000e,7/F\u00019!\r9\u0013HM\u0005\u0003u!\u0012Q!\u0011:sCfD3a\u0001\u001fC!\ti\u0004)D\u0001?\u0015\tyd$\u0001\u0006b]:|G/\u0019;j_:L!!\u0011 \u0003\u000bMKgnY3\"\u0003\r\u000bQA\r\u00181]A\n\u0001\"\u001b8eS\u000e,7\u000f\t\u0015\u0004\tq\u0012\u0015A\u0002<bYV,7/F\u0001I!\r9\u0013(\u0013\t\u0003O)K!a\u0013\u0015\u0003\r\u0011{WO\u00197fQ\r)AHQ\u0001\bm\u0006dW/Z:!Q\r1AHQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\tE\u00136+\u0016\t\u0003[\u0001AQ\u0001M\u0004A\u0002IBQAN\u0004A\u0002aB3a\u0015\u001fC\u0011\u00151u\u00011\u0001IQ\r)FH\u0011\u0015\u0004\u000fq\u0012\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003i\u0003\"a\u00172\u000f\u0005q\u0003\u0007CA/)\u001b\u0005q&BA0%\u0003\u0019a$o\\8u}%\u0011\u0011\rK\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002bQ\u00059Ao\\!se\u0006L\u0018\u0001B2paf,\u0012!U\u0001\tCN\u0014%/Z3{KV\t!\u000eE\u0002l_&k\u0011\u0001\u001c\u0006\u000375T\u0011A\\\u0001\u0007EJ,WM_3\n\u0005=b\u0017!\u00044pe\u0016\f7\r[!di&4X\r\u0006\u0002skB\u0011qe]\u0005\u0003i\"\u0012A!\u00168ji\")a\u000f\u0004a\u0001o\u0006\ta\rE\u0003(qJJ%/\u0003\u0002zQ\tIa)\u001e8di&|gNM\u0001\u0007KF,\u0018\r\\:\u0015\u0005q|\bCA\u0014~\u0013\tq\bFA\u0004C_>dW-\u00198\t\u000f\u0005\u0005Q\u00021\u0001\u0002\u0004\u0005)q\u000e\u001e5feB\u0019q%!\u0002\n\u0007\u0005\u001d\u0001FA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002e\u0005Qa.^7BGRLg/Z:\u0002\u00179,XNT8ou\u0016\u0014xn]\u0001\u0011i>\u001c\u0006/\u0019:tK^KG\u000f[*ju\u0016$2!UA\u000b\u0011\u0019\t9\"\u0005a\u0001e\u0005\u0019aN\u001c>\u0002\r\u0005\u0014x-\\1y\u0003\u0015\u0019H.[2f)\r\t\u0016q\u0004\u0005\u0007\u0003C\u0019\u0002\u0019\u0001\u001d\u0002\u001fM,G.Z2uK\u0012Le\u000eZ5dKND3\u0001\u0001\u001fC\u00031\u0019\u0006/\u0019:tKZ+7\r^8s!\tiSc\u0005\u0003\u0016M\u0005-\u0002cA\u0014\u0002.%\u0019\u0011q\u0006\u0015\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005\u001d\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\t\u0019\u0005E\u0003(\u0003s\ti$C\u0002\u0002<!\u0012aa\u00149uS>t\u0007CB\u0014\u0002@IB\u0004*C\u0002\u0002B!\u0012a\u0001V;qY\u0016\u001c\u0004BBA#/\u0001\u0007\u0011+\u0001\u0002tm\"\u001aq\u0003\u0010\"\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002Z5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0003mC:<'BAA,\u0003\u0011Q\u0017M^1\n\t\u0005m\u0013\u0011\u000b\u0002\u0007\u001f\nTWm\u0019;)\u0007Ua$\tK\u0002\u0015y\t\u0003")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public double apply(int i) {
        return Vector.apply$(this, i);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringBuilder(4).append("(").append(this.size()).append(",").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).mkString("[", ",", "]")).append(",").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).mkString("[", ",", "]")).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> {
            block0: {
                if (v == 0.0) break block0;
                ++nnz$3.elem;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, v) -> {
                block0: {
                    if (v == 0.0) break block0;
                    ii$2[k$2.elem] = i;
                    vv$2[k$2.elem] = v;
                    ++k$2.elem;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedIndices)).flatMap((Function1 & Serializable & scala.Serializable)origIdx -> SparseVector.$anonfun$slice$1(this, currentIdx, BoxesRunTime.unboxToInt((Object)origIdx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] sliceInds = (int[])tuple2._1();
        double[] sliceVals = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
        Tuple2 tuple23 = tuple22;
        int[] sliceInds2 = (int[])tuple23._1();
        double[] sliceVals2 = (double[])tuple23._2();
        return new SparseVector(selectedIndices.length, (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sliceInds2)).toArray(ClassTag$.MODULE$.Int()), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sliceVals2)).toArray(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ Iterator $anonfun$slice$1(SparseVector $this, IntRef currentIdx$1, int origIdx) {
        int iIdx = Arrays.binarySearch($this.indices(), origIdx);
        Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(currentIdx$1.elem, $this.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        ++currentIdx$1.elem;
        return i_v;
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0 & Serializable & scala.Serializable)() -> "The size of the requested sparse vector must be no less than 0.");
        Predef$.MODULE$.require(indices.length == values.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Sparse vectors require that the dimension of the").append(new StringBuilder(70).append(" indices match the dimension of the values. You provided ").append(this.indices().length).append(" indices and ").toString()).append(new StringBuilder(9).append(" ").append(this.values().length).append(" values.").toString()).toString());
        Predef$.MODULE$.require(indices.length <= size, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("You provided ").append(this.indices().length).append(" indices and values, ").append(new StringBuilder(41).append("which exceeds the specified vector size ").append(this.size()).append(".").toString()).toString());
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).nonEmpty()) {
            Predef$.MODULE$.require(indices[0] >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Found negative index: ").append(this.indices()[0]).append(".").toString());
        }
        IntRef prev = IntRef.create((int)-1);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Predef$.MODULE$.require(prev$1.elem < i, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Index ").append(i).append(" follows ").append(prev$1.elem).append(" and is not strictly increasing").toString());
            prev$1.elem = i;
        });
        Predef$.MODULE$.require(prev.elem < size, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Index ").append(prev$1.elem).append(" out of bounds for vector of size ").append(this.size()).toString());
    }
}

