/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="\n    The function is non-deterministic.\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u0014)\u0001VB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005d\u0001\tE\t\u0015!\u0003^\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015!\u0007\u0001\"\u0001j\u0011\u0015Y\u0007\u0001\"\u0011W\u0011\u0015a\u0007\u0001\"\u0011n\u0011!\u0001\b\u0001#b\u0001\n\u0003\n\b\"B;\u0001\t\u00032\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\u000b\u0003\u0017\u0001\u0001R1A\u0005\u0002\u0005\r\u0001bCA\u000b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/Aq!!\n\u0001\t#\n9\u0003C\u0004\u0002:\u0001!\t&a\u000f\t\u000f\u0005=\u0003\u0001\"\u0015\u0002R!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011%\t)\nAA\u0001\n\u0003\t9\nC\u0005\u0002\u001e\u0002\t\n\u0011\"\u0001\u0002 \"I\u0011Q\u0017\u0001\u0012\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003w\u0003\u0011\u0011!C!\u0003{C\u0011\"!4\u0001\u0003\u0003%\t!a4\t\u0013\u0005E\u0007!!A\u0005\u0002\u0005M\u0007\"CAm\u0001\u0005\u0005I\u0011IAn\u0011%\tI\u000fAA\u0001\n\u0003\tY\u000fC\u0005\u0002p\u0002\t\t\u0011\"\u0011\u0002r\"I\u0011Q\u001f\u0001\u0002\u0002\u0013\u0005\u0013q_\u0004\n\u0005CA\u0013\u0011!E\u0001\u0005G1\u0001b\n\u0015\u0002\u0002#\u0005!Q\u0005\u0005\u0007I~!\tA!\u0010\t\u0013\t}r$!A\u0005F\t\u0005\u0003\"\u0003B\"?\u0005\u0005I\u0011\u0011B#\u0011%\u0011YeHI\u0001\n\u0003\t9\fC\u0005\u0003N}\t\t\u0011\"!\u0003P!I!QL\u0010\u0012\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0005?z\u0012\u0011!C\u0005\u0005C\u0012qa\u00155vM\u001adWM\u0003\u0002*U\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tYC&\u0001\u0005dCR\fG._:u\u0015\tic&A\u0002tc2T!a\f\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0002\u0001'\u001d\u0001aGO\u001fA\u0007&\u0003\"a\u000e\u001d\u000e\u0003!J!!\u000f\u0015\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"aN\u001e\n\u0005qB#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011qGP\u0005\u0003\u007f!\u0012\u0001b\u0015;bi\u00164W\u000f\u001c\t\u0003o\u0005K!A\u0011\u0015\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUIA\u0004Qe>$Wo\u0019;\u0011\u0005)\u0013fBA&Q\u001d\tau*D\u0001N\u0015\tqE'\u0001\u0004=e>|GOP\u0005\u0002\r&\u0011\u0011+R\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019FK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002R\u000b\u0006)1\r[5mIV\tq\u000b\u0005\u000281&\u0011\u0011\f\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0006sC:$w.\\*fK\u0012,\u0012!\u0018\t\u0004\tz\u0003\u0017BA0F\u0005\u0019y\u0005\u000f^5p]B\u0011A)Y\u0005\u0003E\u0016\u0013A\u0001T8oO\u0006Y!/\u00198e_6\u001cV-\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0019am\u001a5\u0011\u0005]\u0002\u0001\"B+\u0006\u0001\u00049\u0006bB.\u0006!\u0003\u0005\r!\u0018\u000b\u0003M*DQ!\u0016\u0004A\u0002]\u000bab]3fI\u0016C\bO]3tg&|g.A\u0006xSRDg*Z<TK\u0016$GC\u00014o\u0011\u0015y\u0007\u00021\u0001a\u0003\u0011\u0019X-\u001a3\u0002\u0011I,7o\u001c7wK\u0012,\u0012A\u001d\t\u0003\tNL!\u0001^#\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003]\u00042A\u0013={\u0013\tIHKA\u0002TKF\u0004\"a\u001f@\u000e\u0003qT!! \u0017\u0002\u000bQL\b/Z:\n\u0005}d(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA\u0003!\rY\u0018qA\u0005\u0004\u0003\u0013a(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0017\u0015dW-\\3oiRK\b/\u001a\u0015\u0004\u0019\u0005=\u0001c\u0001#\u0002\u0012%\u0019\u00111C#\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u0002:b]\u0012|W\u000e\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiBK\u0001\u0005kRLG.\u0003\u0003\u0002\"\u0005m!A\u0006*b]\u0012|W.\u00138eS\u000e,7oR3oKJ\fGo\u001c:)\u00075\ty!\u0001\nj]&$\u0018.\u00197ju\u0016Le\u000e^3s]\u0006dG\u0003BA\u0015\u0003_\u00012\u0001RA\u0016\u0013\r\ti#\u0012\u0002\u0005+:LG\u000fC\u0004\u000229\u0001\r!a\r\u0002\u001dA\f'\u000f^5uS>t\u0017J\u001c3fqB\u0019A)!\u000e\n\u0007\u0005]RIA\u0002J]R\fA\"\u001a<bY&sG/\u001a:oC2$B!!\u0010\u0002DA\u0019A)a\u0010\n\u0007\u0005\u0005SIA\u0002B]fDq!!\u0012\u0010\u0001\u0004\t9%A\u0003j]B,H\u000f\u0005\u0003\u0002J\u0005-S\"\u0001\u0016\n\u0007\u00055#FA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\u0019&a\u0018\u0002jA!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z!\nqaY8eK\u001e,g.\u0003\u0003\u0002^\u0005]#\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0005\u0004\u00031\u0001\u0002d\u0005\u00191\r\u001e=\u0011\t\u0005U\u0013QM\u0005\u0005\u0003O\n9F\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005-\u0004\u00031\u0001\u0002T\u0005\u0011QM^\u0001\u0014g\",hM\u001a7f\u0003J\u0014\u0018-_\"pI\u0016<UM\u001c\u000b\t\u0003c\n\t)a!\u0002\u0006B!\u00111OA>\u001d\u0011\t)(a\u001e\u0011\u00051+\u0015bAA=\u000b\u00061\u0001K]3eK\u001aLA!! \u0002\u0000\t11\u000b\u001e:j]\u001eT1!!\u001fF\u0011\u001d\t\t'\u0005a\u0001\u0003GBq!a\u001b\u0012\u0001\u0004\t\u0019\u0006C\u0004\u0002\bF\u0001\r!!\u001d\u0002\u0013\rD\u0017\u000e\u001c3OC6,\u0017!\u00034sKND7i\u001c9z)\u00051\u0017\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002g\u0003#Ca!a%\u0014\u0001\u00049\u0016\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0006M\u0006e\u00151\u0014\u0005\b+R\u0001\n\u00111\u0001X\u0011\u001dYF\u0003%AA\u0002u\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\"*\u001aq+a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002:*\u001aQ,a)\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\f\u0005\u0003\u0002B\u0006-WBAAb\u0015\u0011\t)-a2\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\fAA[1wC&!\u0011QPAb\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u\u0012Q\u001b\u0005\n\u0003/L\u0012\u0011!a\u0001\u0003g\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAo!\u0019\ty.!:\u0002>5\u0011\u0011\u0011\u001d\u0006\u0004\u0003G,\u0015AC2pY2,7\r^5p]&!\u0011q]Aq\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007I\fi\u000fC\u0005\u0002Xn\t\t\u00111\u0001\u0002>\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ty,a=\t\u0013\u0005]G$!AA\u0002\u0005M\u0012AB3rk\u0006d7\u000fF\u0002s\u0003sD\u0011\"a6\u001e\u0003\u0003\u0005\r!!\u0010)/\u0001\tiPa\u0001\u0003\u0006\t%!1\u0002B\b\u0005#\u0011)Ba\u0006\u0003\u001c\tu\u0001cA\u001c\u0002\u0000&\u0019!\u0011\u0001\u0015\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!qA\u0001A?\u001a+fjQ0)CJ\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t:b]\u0012|W\u000e\t9fe6,H/\u0019;j_:\u0004sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\n'O]1z]\u0005AQ\r_1na2,7/\t\u0002\u0003\u000e\u0005\t\u0019C\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AI\u0002D\u0006I\u001a-AUJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\g1\nD&\u000e\u00173auS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113a1\u0002c.\u001e7mY\u0001\u001a\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7J\u0002DF\\;mY2\u001aD&M/\u000bA\u0001\nAA\\8uK\u0006\u0012!1C\u0001+\u0015\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001cgF\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011I\"A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u0010\u0003\u0015\u0011d\u0006\u000e\u00181\u0003\u001d\u0019\u0006.\u001e4gY\u0016\u0004\"aN\u0010\u0014\u000b}\u00119Ca\r\u0011\u000f\t%\"qF,^M6\u0011!1\u0006\u0006\u0004\u0005[)\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005c\u0011YCA\tBEN$(/Y2u\rVt7\r^5p]J\u0002BA!\u000e\u0003<5\u0011!q\u0007\u0006\u0005\u0005s\t9-\u0001\u0002j_&\u00191Ka\u000e\u0015\u0005\t\r\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0016!B1qa2LH#\u00024\u0003H\t%\u0003\"B+#\u0001\u00049\u0006bB.#!\u0003\u0005\r!X\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003\u0002B)\u00053\u0002B\u0001\u00120\u0003TA)AI!\u0016X;&\u0019!qK#\u0003\rQ+\b\u000f\\33\u0011!\u0011Y\u0006JA\u0001\u0002\u00041\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0019\u0011\t\u0005\u0005'QM\u0005\u0005\u0005O\n\u0019M\u0001\u0004PE*,7\r\u001e")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Stateful,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private transient DataType elementType;
    private final Expression child;
    private final Option<Object> randomSeed;
    private transient RandomIndicesGenerator random;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle x$0) {
        return Shuffle$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<Object>)x$1);
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        return !this.bitmap$trans$0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        GenericArrayData genericArrayData;
        Object value = this.child().eval(input);
        if (value == null) {
            genericArrayData = null;
        } else {
            ArrayData source = (ArrayData)value;
            int numElements = source.numElements();
            int[] indices = this.random.getNextIndices(numElements);
            genericArrayData = new GenericArrayData((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(indices), (Function1 & Serializable)x$18 -> source.get(BoxesRunTime.unboxToInt((Object)x$18), this.elementType()), ClassTag$.MODULE$.apply(Object.class)));
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> this.shuffleArrayCodeGen(ctx, ev, (String)c));
    }

    private String shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$1 = randomClass = RandomIndicesGenerator.class.getName();
        String x$2 = "rand";
        boolean x$3 = true;
        Function1<String, String> x$4 = ctx.addMutableState$default$3();
        boolean x$5 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$1, "rand", x$4, true, x$5);
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rand).append(" = new ").append(randomClass).append("(").append(this.randomSeed().get()).append("L + partitionIndex);").toString());
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, new StringBuilder(2).append(indices).append("[").append(i).append("]").toString(), ((ArrayType)this.dataType()).containsNull());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n       |int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |int[] ").append(indices).append(" = ").append(rand).append(".getNextIndices(").append(numElements).append(");\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString()));
    }

    @Override
    public Shuffle freshCopy() {
        return new Shuffle(this.child(), this.randomSeed());
    }

    @Override
    public Shuffle withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.randomSeed();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "randomSeed";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes.$init$(this);
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        Statics.releaseFence();
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }
}

