/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('{\"teacher\": \"Alice\", \"student\": [{\"name\": \"Bob\", \"rank\": 1}, {\"name\": \"Charlie\", \"rank\": 2}]}', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\tMh\u0001B\u001a5\u0001\u0006C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\te\u0002\u0011\t\u0012)A\u0005Y\"A1\u000f\u0001BK\u0002\u0013\u0005A\u000fC\u0005\u0002\u0002\u0001\u0011\t\u0012)A\u0005k\"Q\u00111\u0001\u0001\u0003\u0016\u0004%\t!!\u0002\t\u0015\u00055\u0001A!E!\u0002\u0013\t9\u0001\u0003\u0006\u0002\u0010\u0001\u0011)\u001a!C\u0001\u0003#A!\"!\u0007\u0001\u0005#\u0005\u000b\u0011BA\n\u0011\u001d\tY\u0002\u0001C\u0001\u0003;A\u0001\"!\u000b\u0001\u0005\u0004%\ta\u001b\u0005\b\u0003W\u0001\u0001\u0015!\u0003m\u0011\u001d\ti\u0003\u0001C!\u0003_Aq!a\u000e\u0001\t\u000b\nI\u0004C\u0004\u0002\u001c\u0001!\t!a\u001b\t\u000f\u0005m\u0001\u0001\"\u0001\u0002t!9\u00111\u0004\u0001\u0005\u0002\u0005e\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\u000b\u0003#\u0003\u0001R1A\u0005\u0002\u0005M\u0005\"CAi\u0001\t\u0007I\u0011AAj\u0011\u001d\t)\u000e\u0001Q\u0001\nuD!\"a6\u0001\u0011\u000b\u0007I\u0011AAm\u0011\u0019\t9\u0010\u0001C!W\"9\u0011\u0011 \u0001\u0005B\u0005m\bbBA\u0000\u0001\u0011\u0005#\u0011\u0001\u0005\b\u0005\u001b\u0001A\u0011\tB\b\u0011\u0019I\u0004\u0001\"\u0011\u0002T\"9!\u0011\u0004\u0001\u0005B\u0005M\u0007b\u0002B\u000e\u0001\u0011E#Q\u0004\u0005\n\u0005G\u0001\u0011\u0011!C\u0001\u0005KA\u0011Ba\f\u0001#\u0003%\tA!\r\t\u0013\t\u001d\u0003!%A\u0005\u0002\t%\u0003\"\u0003B'\u0001E\u0005I\u0011\u0001B(\u0011%\u0011\u0019\u0006AI\u0001\n\u0003\u0011)\u0006C\u0005\u0003Z\u0001\t\t\u0011\"\u0011\u0003\\!I!\u0011\r\u0001\u0002\u0002\u0013\u0005!1\r\u0005\n\u0005W\u0002\u0011\u0011!C\u0001\u0005[B\u0011Ba\u001d\u0001\u0003\u0003%\tE!\u001e\t\u0013\t\u0005\u0005!!A\u0005\u0002\t\r\u0005\"\u0003BD\u0001\u0005\u0005I\u0011\tBE\u0011%\u0011i\tAA\u0001\n\u0003\u0012y\t\u0003\b\u0003\u0014\u0002\u0001\n1!A\u0001\n\u0013\t\u0019I!&\b\u0013\t]F'!A\t\u0002\tef\u0001C\u001a5\u0003\u0003E\tAa/\t\u000f\u0005m1\u0006\"\u0001\u0003J\"I!1Z\u0016\u0002\u0002\u0013\u0015#Q\u001a\u0005\n\u0005\u001f\\\u0013\u0011!CA\u0005#D\u0011Ba7,#\u0003%\tA!\u0016\t\u0013\tu7&!A\u0005\u0002\n}\u0007\"\u0003BwWE\u0005I\u0011\u0001B+\u0011%\u0011yoKA\u0001\n\u0013\u0011\tPA\u0007Kg>tGk\\*ueV\u001cGo\u001d\u0006\u0003kY\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0007O\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011HO\u0001\u0004gFd'BA\u001e=\u0003\u0015\u0019\b/\u0019:l\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\u0004\u0001MA\u0001A\u0011$J\u001fJKv\f\u0005\u0002D\t6\tA'\u0003\u0002Fi\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002D\u000f&\u0011\u0001\n\u000e\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"AS'\u000e\u0003-S!\u0001\u0014\u001b\u0002\u000f\r|G-Z4f]&\u0011aj\u0013\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u00111\tU\u0005\u0003#R\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t\u0019fK\u0004\u0002D)&\u0011Q\u000bN\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006L\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005U#\u0004C\u0001.^\u001b\u0005Y&\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005y[&a\u0002)s_\u0012,8\r\u001e\t\u0003A\u001et!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011\u0004\u0015A\u0002\u001fs_>$h(C\u0001]\u0013\t)6,\u0003\u0002iS\na1+\u001a:jC2L'0\u00192mK*\u0011QkW\u0001\u0007g\u000eDW-\\1\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\u001c\u001d\u0002\u000bQL\b/Z:\n\u0005Et'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u00059q\u000e\u001d;j_:\u001cX#A;\u0011\tYTX0 \b\u0003ob\u0004\"AY.\n\u0005e\\\u0016A\u0002)sK\u0012,g-\u0003\u0002|y\n\u0019Q*\u00199\u000b\u0005e\\\u0006C\u0001<\u007f\u0013\tyHP\u0001\u0004TiJLgnZ\u0001\t_B$\u0018n\u001c8tA\u0005)1\r[5mIV\u0011\u0011q\u0001\t\u0004\u0007\u0006%\u0011bAA\u0006i\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0003\u0003'\u0001BAWA\u000b{&\u0019\u0011qC.\u0003\r=\u0003H/[8o\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\rqJg.\u001b;?))\ty\"!\t\u0002$\u0005\u0015\u0012q\u0005\t\u0003\u0007\u0002AQA[\u0005A\u00021DQa]\u0005A\u0002UDq!a\u0001\n\u0001\u0004\t9\u0001C\u0005\u0002\u0010%\u0001\n\u00111\u0001\u0002\u0014\u0005qa.\u001e7mC\ndWmU2iK6\f\u0017a\u00048vY2\f'\r\\3TG\",W.\u0019\u0011\u0002\u00119,H\u000e\\1cY\u0016,\"!!\r\u0011\u0007i\u000b\u0019$C\u0002\u00026m\u0013qAQ8pY\u0016\fg.\u0001\u000bo_\u0012,\u0007+\u0019;uKJt7/\u00138uKJt\u0017\r\u001c\u000b\u0003\u0003w\u0001R\u0001YA\u001f\u0003\u0003J1!a\u0010j\u0005\r\u0019V-\u001d\t\u0005\u0003\u0007\n)G\u0004\u0003\u0002F\u0005}c\u0002BA$\u00037rA!!\u0013\u0002Z9!\u00111JA,\u001d\u0011\ti%!\u0016\u000f\t\u0005=\u00131\u000b\b\u0004E\u0006E\u0013\"A \n\u0005ur\u0014BA\u001e=\u0013\tI$(\u0003\u00028q%\u0019\u0011Q\f\u001c\u0002\u000bQ\u0014X-Z:\n\t\u0005\u0005\u00141M\u0001\f)J,W\rU1ui\u0016\u0014hNC\u0002\u0002^YJA!a\u001a\u0002j\tYAK]3f!\u0006$H/\u001a:o\u0015\u0011\t\t'a\u0019\u0015\u0011\u0005}\u0011QNA8\u0003cBq!a\u0001\u000f\u0001\u0004\t9\u0001\u0003\u0004k\u001d\u0001\u0007\u0011q\u0001\u0005\u0006g:\u0001\r!\u001e\u000b\u0007\u0003?\t)(a\u001e\t\u000f\u0005\rq\u00021\u0001\u0002\b!1!n\u0004a\u0001\u0003\u000f!\u0002\"a\b\u0002|\u0005u\u0014q\u0010\u0005\b\u0003\u0007\u0001\u0002\u0019AA\u0004\u0011\u0019Q\u0007\u00031\u0001\u0002\b!11\u000f\u0005a\u0001\u0003\u000f\t1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!!\"\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#7\u0003!\tg.\u00197zg&\u001c\u0018\u0002BAH\u0003\u0013\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\nG>tg/\u001a:uKJ,\"!!&\u0011\u000fi\u000b9*a'\u0002*&\u0019\u0011\u0011T.\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#\u00021\u0002\u001e\u0006\u0005\u0016bAAPS\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002$\u0006\u0015V\"\u0001\u001c\n\u0007\u0005\u001dfGA\u0006J]R,'O\\1m%><(CBAV\u0003_\u000byL\u0002\u0004\u0002.\u0002\u0001\u0011\u0011\u0016\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0005\u0003c\u000bY,\u0004\u0002\u00024*!\u0011QWA\\\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0016\u0001\u00026bm\u0006LA!!0\u00024\n1qJ\u00196fGR\u0004B!!1\u0002H6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9,\u0001\u0002j_&\u0019\u0001.a1)\u0007I\tY\rE\u0002[\u0003\u001bL1!a4\\\u0005%!(/\u00198tS\u0016tG/A\noC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H-F\u0001~\u0003Qq\u0017-\\3PM\u000e{'O];qiJ+7m\u001c:eA\u00051\u0001/\u0019:tKJ,\"!a7\u0011\r\u0005u\u00171]At\u001b\t\tyNC\u0002\u0002bZ\nA!\u001e;jY&!\u0011Q]Ap\u0005E1\u0015-\u001b7ve\u0016\u001c\u0016MZ3QCJ\u001cXM\u001d\t\u0005\u0003S\f\t0\u0004\u0002\u0002l*\u0019q.!<\u000b\u0007\u0005=((\u0001\u0004v]N\fg-Z\u0005\u0005\u0003g\fYO\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD3!FAf\u0003!!\u0017\r^1UsB,\u0017\u0001D<ji\"$\u0016.\\3[_:,Gc\u0001$\u0002~\"1\u0011qB\fA\u0002u\fAB\\;mYN\u000bg-Z#wC2$BAa\u0001\u0003\nA\u0019!L!\u0002\n\u0007\t\u001d1LA\u0002B]fDqAa\u0003\u0019\u0001\u0004\u0011\u0019!\u0001\u0003kg>t\u0017AC5oaV$H+\u001f9fgV\u0011!\u0011\u0003\t\u0006A\u0006u\"1\u0003\t\u0004[\nU\u0011b\u0001B\f]\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,\u0017\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002 \t}\u0001b\u0002B\u00119\u0001\u0007\u0011qA\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z))\tyBa\n\u0003*\t-\"Q\u0006\u0005\bUv\u0001\n\u00111\u0001m\u0011\u001d\u0019X\u0004%AA\u0002UD\u0011\"a\u0001\u001e!\u0003\u0005\r!a\u0002\t\u0013\u0005=Q\u0004%AA\u0002\u0005M\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005gQ3\u0001\u001cB\u001bW\t\u00119\u0004\u0005\u0003\u0003:\t\rSB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B!7\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015#1\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0017R3!\u001eB\u001b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\u0015+\t\u0005\u001d!QG\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u00119F\u000b\u0003\u0002\u0014\tU\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003^A!\u0011\u0011\u0017B0\u0013\ry\u00181W\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005K\u00022A\u0017B4\u0013\r\u0011Ig\u0017\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0007\u0011y\u0007C\u0005\u0003r\u0011\n\t\u00111\u0001\u0003f\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u001e\u0011\r\te$q\u0010B\u0002\u001b\t\u0011YHC\u0002\u0003~m\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tyJa\u001f\u0002\u0011\r\fg.R9vC2$B!!\r\u0003\u0006\"I!\u0011\u000f\u0014\u0002\u0002\u0003\u0007!1A\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003^\t-\u0005\"\u0003B9O\u0005\u0005\t\u0019\u0001B3\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0007BI\u0011%\u0011\t\bKA\u0001\u0002\u0004\u0011\u0019!A\rtkB,'\u000fJ2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001c\u0018bAAA!\"\u001a\u0002A!'\u0003 \n\u0005&Q\u0015BT\u0005W\u0013iK!-\u00034B\u00191Ia'\n\u0007\tuEGA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t\r\u0016AY0G+:\u001bu\f\u000b6t_:\u001cFO\u001d\u0017!g\u000eDW-\\1\\Y\u0001z\u0007\u000f^5p]Nl\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\u000f\u001e:vGR\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!i\",\u0007eZ5wK:\u0004\u0003M[:p]N#(\u000f\u0019\u0011b]\u0012\u0004\u0003m]2iK6\f\u0007ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!\u0011V\u0001\u0005$)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u001f\u0012bEi\nD\u0006\t\u0012cEi\u0002d\u0006O?(Y\u0001:\u0013\rI%O)2\u0002#\r\t#P+\ncUiJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e2Y\t\u0012'E\u000f\u0019/quT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#i&lWM\t\u001e#eYz\u0003\u0007O\u00183aE*$%`\u0014-A\u001d\"\u0018.\\3!)&lWm\u001d;b[B<C\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(\u0005^5nK\nR$\u0007M\u00196[ABTF\r\u001c!aAR\u0004\u0007\r\u001e1auT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#i\u0016\f7\r[3sEi\u0002#%\u00117jG\u0016\u0014C\u0006\t\u0012tiV$WM\u001c;#u\u0001Z6P\t8b[\u0016\u0014#\b\t\u0012C_\n\u0014C\u0006\t\u0012sC:\\'E\u000f\u00112{2\u00023P\t8b[\u0016\u0014#\b\t\u0012DQ\u0006\u0014H.[3#Y\u0001\u0012#/\u00198lEi\u0002#'`/~O1\u0002se\u0015+S+\u000e#F\b^3bG\",'O\u000f\u0011T)JKej\u0012\u0017!gR,H-\u001a8uu\u0001\n%KU!ZyM#&+V\"Uy9\fW.\u001a\u001e!'R\u0013\u0016JT$-AI\fgn\u001b\u001e!\u0013:#fH\u0010 (SmR\u0001\u0005\t\u0011!A\u0001\u00023P\t;fC\u000eDWM\u001d\u0012;E\u0005c\u0017nY3#Y\t\u001aH/\u001e3f]R\u0014#hW>#]\u0006lWM\t\u001e#\u0005>\u0014'\u0005\f\u0012sC:\\'EO\u0019~Ym\u0014c.Y7fEi\u00123\t[1sY&,'\u0005\f\u0012sC:\\'E\u000f\u001a~;vT\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005_\u000b!B[:p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011),A\u00033]Ir\u0003'A\u0007Kg>tGk\\*ueV\u001cGo\u001d\t\u0003\u0007.\u001aRa\u000bB_\u0003\u007f\u0003BBa0\u0003F2,\u0018qAA\n\u0003?i!A!1\u000b\u0007\t\r7,A\u0004sk:$\u0018.\\3\n\t\t\u001d'\u0011\u0019\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001B]\u0003!!xn\u0015;sS:<GC\u0001B/\u0003\u0015\t\u0007\u000f\u001d7z))\tyBa5\u0003V\n]'\u0011\u001c\u0005\u0006U:\u0002\r\u0001\u001c\u0005\u0006g:\u0002\r!\u001e\u0005\b\u0003\u0007q\u0003\u0019AA\u0004\u0011%\tyA\fI\u0001\u0002\u0004\t\u0019\"A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BA!9\u0003jB)!,!\u0006\u0003dBI!L!:mk\u0006\u001d\u00111C\u0005\u0004\u0005O\\&A\u0002+va2,G\u0007C\u0005\u0003lB\n\t\u00111\u0001\u0002 \u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\u000b")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<UTF8String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs x$0) {
        return JsonToStructs$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private /* synthetic */ TypeCheckResult super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.JSON_TO_STRUCT()}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? (TypeCheckResult)ExprUtils$.MODULE$.checkJsonSchema(this.nullableSchema()).map((Function1 & Serializable)e -> new TypeCheckResult.TypeCheckFailure(e.getMessage())).getOrElse((Function0 & Serializable)() -> this.super$checkInputDataTypes()) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Input schema ").append(this.nullableSchema().catalogString()).append(" must be a struct, an array or a map.").toString());
        return typeCheckResult;
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable)rows -> rows.hasNext() ? (InternalRow)rows.next() : null;
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getArray(0) : null;
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getMap(0) : null;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<UTF8String> parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Tuple2 tuple2;
                DataType dataType;
                ParseMode mode;
                JSONOptions parsedOptions = new JSONOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_json", mode);
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType, parsedOptions.columnNameOfCorruptRecord());
                    tuple2 = new Tuple2((Object)structType, (Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)structType.filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JsonToStructs.$anonfun$parser$1(parsedOptions, x$6))))));
                } else {
                    StructField structField = new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil().$colon$colon((Object)structField)), (Object)dataType);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                StructType parserSchema = (StructType)tuple22._1();
                DataType actualSchema = (DataType)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                Tuple2 tuple24 = tuple23;
                StructType parserSchema2 = (StructType)tuple24._1();
                DataType actualSchema2 = (DataType)tuple24._2();
                JacksonParser rawParser = new JacksonParser(actualSchema2, parsedOptions, false, JacksonParser$.MODULE$.$lessinit$greater$default$4());
                Function2 & Serializable createParser = (Function2 & Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record);
                this.parser = new FailureSafeParser((Function1 & Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<UTF8String> parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        return this.converter().apply(this.parser().parse((UTF8String)json));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        String string = dataType instanceof MapType ? "entries" : super.sql();
        return string;
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    @Override
    public JsonToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "schema";
                break;
            }
            case 1: {
                string = "options";
                break;
            }
            case 2: {
                string = "child";
                break;
            }
            case 3: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(JSONOptions parsedOptions$1, StructField x$6) {
        String string = x$6.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
        Statics.releaseFence();
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

