/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToJson$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a JSON string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"26/08/2015\"}\n      > SELECT _FUNC_(array(named_struct('a', 1, 'b', 2)));\n       [{\"a\":1,\"b\":2}]\n      > SELECT _FUNC_(map('a', named_struct('b', 1)));\n       {\"a\":{\"b\":1}}\n      > SELECT _FUNC_(map(named_struct('a', 1),named_struct('b', 2)));\n       {\"[1]\":{\"b\":2}}\n      > SELECT _FUNC_(map('a', 1));\n       {\"a\":1}\n      > SELECT _FUNC_(array((map('a', 1))));\n       [{\"a\":1}]\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t\re\u0001\u0002\u0016,\u0001bB\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\tS\u0002\u0011\t\u0012)A\u00057\"A!\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005p\u0001\tE\t\u0015!\u0003m\u0011!\u0001\bA!f\u0001\n\u0003\t\b\u0002C;\u0001\u0005#\u0005\u000b\u0011\u0002:\t\u000bY\u0004A\u0011A<\t\u000bq\u0004A\u0011I?\t\rY\u0004A\u0011AA\u0002\u0011\u00191\b\u0001\"\u0001\u0002\n!1a\u000f\u0001C\u0001\u0003\u001bA!\"a\u0005\u0001\u0011\u000b\u0007I\u0011AA\u000b\u0011)\ty\u0003\u0001EC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0003\u0003\u0002\u0001R1A\u0005\u0002\u0005\r\u0003BCA*\u0001!\u0015\r\u0011\"\u0001\u0002V!9\u00111\u000f\u0001\u0005B\u0005\r\u0003bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!a%\u0001\t\u0003\n)\nC\u0004\u0002.\u0002!\t%a,\t\u000f\u0005E\u0006\u0001\"\u0015\u00024\"I\u0011\u0011\u0018\u0001\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u0007\u0004\u0011\u0013!C\u0001\u0003\u000bD\u0011\"a7\u0001#\u0003%\t!!8\t\u0013\u0005\u0005\b!%A\u0005\u0002\u0005\r\b\"CAt\u0001\u0005\u0005I\u0011IAu\u0011%\t)\u0010AA\u0001\n\u0003\t9\u0010C\u0005\u0002\u0000\u0002\t\t\u0011\"\u0001\u0003\u0002!I!q\u0001\u0001\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\n\u0005/\u0001\u0011\u0011!C\u0001\u00053A\u0011B!\b\u0001\u0003\u0003%\tEa\b\b\u0013\t\r3&!A\t\u0002\t\u0015c\u0001\u0003\u0016,\u0003\u0003E\tAa\u0012\t\rY\u0014C\u0011\u0001B+\u0011%\u00119FIA\u0001\n\u000b\u0012I\u0006C\u0005\u0003\\\t\n\t\u0011\"!\u0003^!I!Q\r\u0012\u0012\u0002\u0013\u0005\u00111\u001d\u0005\n\u0005O\u0012\u0013\u0011!CA\u0005SB\u0011Ba\u001e##\u0003%\t!a9\t\u0013\te$%!A\u0005\n\tm$!D*ueV\u001cGo\u001d+p\u0015N|gN\u0003\u0002-[\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqs&\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0014'A\u0002tc2T!AM\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001'!\u0001\u0011(\u0010!G\u0013B3\u0006C\u0001\u001e<\u001b\u0005Y\u0013B\u0001\u001f,\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001e?\u0013\ty4FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0011\tR\u0007\u0002\u0005*\u00111iK\u0001\bG>$WmZ3o\u0013\t)%IA\bD_\u0012,w-\u001a8GC2d'-Y2l!\tQt)\u0003\u0002IW\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005)keB\u0001\u001eL\u0013\ta5&A\u0004qC\u000e\\\u0017mZ3\n\u00059{%A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003\u0019.\u0002\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002R/&\u0011\u0001L\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\b_B$\u0018n\u001c8t+\u0005Y\u0006\u0003\u0002/dM\u001at!!X1\u0011\u0005y\u0013V\"A0\u000b\u0005\u0001<\u0014A\u0002\u001fs_>$h(\u0003\u0002c%\u00061\u0001K]3eK\u001aL!\u0001Z3\u0003\u00075\u000b\u0007O\u0003\u0002c%B\u0011AlZ\u0005\u0003Q\u0016\u0014aa\u0015;sS:<\u0017\u0001C8qi&|gn\u001d\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u00031\u0004\"AO7\n\u00059\\#AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n!\u0002^5nKj{g.Z%e+\u0005\u0011\bcA)tM&\u0011AO\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\taL(p\u001f\t\u0003u\u0001AQ!W\u0004A\u0002mCQA[\u0004A\u00021Dq\u0001]\u0004\u0011\u0002\u0003\u0007!/\u0001\u0005ok2d\u0017M\u00197f+\u0005q\bCA)\u0000\u0013\r\t\tA\u0015\u0002\b\u0005>|G.Z1o)\u0015A\u0018QAA\u0004\u0011\u0015I\u0016\u00021\u0001\\\u0011\u0015Q\u0017\u00021\u0001m)\rA\u00181\u0002\u0005\u0006U*\u0001\r\u0001\u001c\u000b\u0006q\u0006=\u0011\u0011\u0003\u0005\u0006U.\u0001\r\u0001\u001c\u0005\u00063.\u0001\r\u0001\\\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0003S>T!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\tYBA\bDQ\u0006\u0014\u0018I\u001d:bs^\u0013\u0018\u000e^3sQ\ra\u0011\u0011\u0006\t\u0004#\u0006-\u0012bAA\u0017%\nIAO]1og&,g\u000e^\u0001\u0004O\u0016tWCAA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d[\u0005!!n]8o\u0013\u0011\ti$a\u000e\u0003!)\u000b7m[:p]\u001e+g.\u001a:bi>\u0014\bfA\u0007\u0002*\u0005Y\u0011N\u001c9viN\u001b\u0007.Z7b+\t\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tYeL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u001f\nIE\u0001\u0005ECR\fG+\u001f9fQ\rq\u0011\u0011F\u0001\nG>tg/\u001a:uKJ,\"!a\u0016\u0011\u000fE\u000bI&!\u0018\u0002d%\u0019\u00111\f*\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA)\u0002`%\u0019\u0011\u0011\r*\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002f\u00055TBAA4\u0015\u0011\tY%!\u001b\u000b\u0007\u0005-\u0014'\u0001\u0004v]N\fg-Z\u0005\u0005\u0003_\n9G\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD3aDA\u0015\u0003!!\u0017\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA=!\u0011\tY(!!\u000e\u0005\u0005u$bAA@[\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u0004\u0006u$a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0007u\nI\tC\u0003q%\u0001\u0007a-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003\u0002^\u0005=\u0005bBAI'\u0001\u0007\u0011QL\u0001\u0006m\u0006dW/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAAL!\u0019\tI*!)\u0002(:!\u00111TAP\u001d\rq\u0016QT\u0005\u0002'&\u0011AJU\u0005\u0005\u0003G\u000b)KA\u0002TKFT!\u0001\u0014*\u0011\t\u0005\u001d\u0013\u0011V\u0005\u0005\u0003W\u000bIE\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003\u0019\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGc\u0001=\u00026\"1\u0011q\u0017\fA\u00021\f\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0004y\u0003{\u000by,!1\t\u000fe;\u0002\u0013!a\u00017\"9!n\u0006I\u0001\u0002\u0004a\u0007b\u00029\u0018!\u0003\u0005\rA]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9MK\u0002\\\u0003\u0013\\#!a3\u0011\t\u00055\u0017q[\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+\u0014\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011\\Ah\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyNK\u0002m\u0003\u0013\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002f*\u001a!/!3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\u0011\t\t0a\b\u0002\t1\fgnZ\u0005\u0004Q\u0006=\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA}!\r\t\u00161`\u0005\u0004\u0003{\u0014&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA/\u0005\u0007A\u0011B!\u0002\u001e\u0003\u0003\u0005\r!!?\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u0001\u0005\u0004\u0003\u000e\tM\u0011QL\u0007\u0003\u0005\u001fQ1A!\u0005S\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005+\u0011yA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001@\u0003\u001c!I!QA\u0010\u0002\u0002\u0003\u0007\u0011QL\u0001\u0007KF,\u0018\r\\:\u0015\u0007y\u0014\t\u0003C\u0005\u0003\u0006\u0001\n\t\u00111\u0001\u0002^!\u001a\u0002A!\n\u0003,\t5\"\u0011\u0007B\u001a\u0005o\u0011ID!\u0010\u0003@A\u0019!Ha\n\n\u0007\t%2FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t=\u0012!S0G+:\u001bu\fK3yaJ\\F\u0006I8qi&|gn]/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011K'>s\u0005e\u001d;sS:<\u0007e^5uQ\u0002\n\u0007eZ5wK:\u00043\u000f\u001e:vGR\u0004c/\u00197vK\u0006AQ\r_1na2,7/\t\u0002\u00036\u0005!9M\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015oC6,GmX:ueV\u001cG\u000fK\u0014bO1\u0002\u0013\u0007\f\u0011(E\u001eb\u0003EM\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;c1\u0012#M\t\u001e3{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc.Y7fI~\u001bHO];di\":C/[7fO1\u0002Co\\0uS6,7\u000f^1na\":#\u0007M\u00196[ABTF\r\u001c(Y\u0001:\u00130_=z[5kU\u0006\u001a3(S%b\u0003%\\1qQ\u001d\"\u0018.\\3ti\u0006l\u0007OR8s[\u0006$x\u0005\f\u0011(I\u0012|S*T\u0018zsfLx%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014C/[7fEi\u0012#GN\u00181q=\u0012\u0004'M\u001b#{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"r\u0017-\\3e?N$(/^2uQ\u001d\nw\u0005\f\u00112Y\u0001:#m\n\u0017!e%J\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\w\n\n'EO\u0019-E\t\u0014#HM?^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0017\r\u001d\u0015(C\u001eb\u0003E\\1nK\u0012|6\u000f\u001e:vGRDsEY\u0014-AEJ\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'EO>#E\nR\u0014'`?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\f\u0007\u000f\u000b8b[\u0016$wl\u001d;sk\u000e$\bfJ1(Y\u0001\n\u0014\u0006\f8b[\u0016$wl\u001d;sk\u000e$\bf\n2(Y\u0001\u0012\u0014&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u00143,M/#um\u0014#M\t\u001e3{vT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQ\u001d\nw\u0005\f\u00112S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012bEi\nTP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\u000b\u0015nCBDs%Y\u0014-AEJ\u0013&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u0019\u0012;cul&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tm\u0012A\u00036t_:|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!\u0011I\u0001\u0006e9\u0012d\u0006M\u0001\u000e'R\u0014Xo\u0019;t)>T5o\u001c8\u0011\u0005i\u00123\u0003\u0002\u0012\u0003JY\u0003\u0002Ba\u0013\u0003Rmc'\u000f_\u0007\u0003\u0005\u001bR1Aa\u0014S\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0015\u0003N\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t\u0015\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0018!B1qa2LHc\u0002=\u0003`\t\u0005$1\r\u0005\u00063\u0016\u0002\ra\u0017\u0005\u0006U\u0016\u0002\r\u0001\u001c\u0005\ba\u0016\u0002\n\u00111\u0001s\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005W\u0012\u0019\b\u0005\u0003Rg\n5\u0004CB)\u0003pmc'/C\u0002\u0003rI\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B;O\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003~A!\u0011Q\u001eB@\u0013\u0011\u0011\t)a<\u0003\r=\u0013'.Z2u\u0001")
public class StructsToJson
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient CharArrayWriter writer;
    private transient JacksonGenerator gen;
    private transient DataType inputSchema;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToJson$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToJson structsToJson) {
        return StructsToJson$.MODULE$.unapply(structsToJson);
    }

    public static Option<String> apply$default$3() {
        return StructsToJson$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToJson> tupled() {
        return StructsToJson$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToJson>>> curried() {
        return StructsToJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private JacksonGenerator gen$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.gen = new JacksonGenerator(this.inputSchema(), this.writer(), new JSONOptions(this.options(), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gen;
    }

    public JacksonGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private DataType inputSchema$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputSchema = this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputSchema;
    }

    public DataType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.inputSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)row -> {
                        this.gen().write((InternalRow)row);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)arr -> {
                        this.gen().write((ArrayData)arr);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)map -> {
                        this.gen().write((MapData)map);
                        return this.getAndReset$1();
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        DataType dataType = this.inputSchema();
        if (dataType instanceof StructType) {
            TypeCheckResult typeCheckResult2;
            StructType structType = (StructType)dataType;
            try {
                JacksonUtils$.MODULE$.verifySchema(structType);
                typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult2 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult2;
        } else if (dataType instanceof MapType) {
            TypeCheckResult typeCheckResult3;
            MapType mapType = (MapType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), mapType);
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult3 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult3;
        } else if (dataType instanceof ArrayType) {
            TypeCheckResult typeCheckResult4;
            ArrayType arrayType = (ArrayType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), arrayType);
                typeCheckResult4 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult4 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult4;
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("Input type ").append(this.child().dataType().catalogString()).append(" must be a struct, array of structs or ").append("a map or array of map.").toString());
        }
        return typeCheckResult;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, StructType$.MODULE$}));
        return Nil$.MODULE$.$colon$colon((Object)typeCollection);
    }

    @Override
    public String prettyName() {
        return "to_json";
    }

    @Override
    public StructsToJson withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    public StructsToJson copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToJson(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToJson";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToJson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToJson structsToJson = (StructsToJson)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToJson.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToJson.canEqual(this)) return false;
        return true;
    }

    private final UTF8String getAndReset$1() {
        this.gen().flush();
        String json = this.writer().toString();
        this.writer().reset();
        return UTF8String.fromString((String)json);
    }

    public StructsToJson(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StructsToJson(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

