/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeDTInterval$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([days[, hours[, mins[, secs]]]]) - Make DayTimeIntervalType duration from days, hours, mins and secs.", arguments="\n    Arguments:\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 12, 30, 01.001001);\n       1 12:30:01.001001000\n      > SELECT _FUNC_(2);\n       2 00:00:00.000000000\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n  ", since="3.2.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005%\"Aa\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003S\u0011!A\u0006A!f\u0001\n\u0003\t\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u0011i\u0003!Q3A\u0005\u0002EC\u0001b\u0017\u0001\u0003\u0012\u0003\u0006IA\u0015\u0005\u00069\u0002!\t!\u0018\u0005\u00069\u0002!\ta\u0019\u0005\u00069\u0002!\ta\u001a\u0005\u00069\u0002!\tA\u001b\u0005\u00069\u0002!\t\u0001\u001c\u0005\u0006[\u0002!\t%\u0015\u0005\u0006]\u0002!\t%\u0015\u0005\u0006_\u0002!\t%\u0015\u0005\u0006a\u0002!\t%\u0015\u0005\u0006c\u0002!\tE\u001d\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005}\u0003\u0001\"\u0015\u0002b!I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003o\u0002\u0011\u0013!C\u0001\u0003sB\u0011\"a$\u0001#\u0003%\t!!\u001f\t\u0013\u0005E\u0005!%A\u0005\u0002\u0005e\u0004\"CAJ\u0001E\u0005I\u0011AA=\u0011%\t)\nAA\u0001\n\u0003\n9\nC\u0005\u0002(\u0002\t\t\u0011\"\u0001\u0002*\"I\u0011\u0011\u0017\u0001\u0002\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003s\u0003\u0011\u0011!C!\u0003wC\u0011\"!3\u0001\u0003\u0003%\t!a3\t\u0013\u0005U\u0007!!A\u0005B\u0005]w!\u0003B\u0001W\u0005\u0005\t\u0012\u0001B\u0002\r!Q3&!A\t\u0002\t\u0015\u0001B\u0002/%\t\u0003\u0011\u0019\u0002C\u0005\u0003\u0016\u0011\n\t\u0011\"\u0012\u0003\u0018!I!\u0011\u0004\u0013\u0002\u0002\u0013\u0005%1\u0004\u0005\n\u0005K!\u0013\u0011!CA\u0005OA\u0011B!\u000f%\u0003\u0003%IAa\u000f\u0003\u001d5\u000b7.\u001a#U\u0013:$XM\u001d<bY*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001su\u0002u)\u0014\t\u0003umj\u0011aK\u0005\u0003y-\u0012A#U;bi\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001e?\u0013\ty4F\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\tEI\u0004\u0002;\u0005&\u00111iK\u0001\ba\u0006\u001c7.Y4f\u0013\t)eI\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\r[\u0003C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0011:K!aT%\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t\u0011\f\u0017p]\u000b\u0002%B\u0011!hU\u0005\u0003).\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015!\u0017-_:!\u0003\u0015Aw.\u001e:t\u0003\u0019Aw.\u001e:tA\u0005!Q.\u001b8t\u0003\u0015i\u0017N\\:!\u0003\u0011\u0019XmY:\u0002\u000bM,7m\u001d\u0011\u0002\rqJg.\u001b;?)\u0015qv\fY1c!\tQ\u0004\u0001C\u0003Q\u0013\u0001\u0007!\u000bC\u0003W\u0013\u0001\u0007!\u000bC\u0003Y\u0013\u0001\u0007!\u000bC\u0003[\u0013\u0001\u0007!\u000b\u0006\u0003_I\u00164\u0007\"\u0002)\u000b\u0001\u0004\u0011\u0006\"\u0002,\u000b\u0001\u0004\u0011\u0006\"\u0002-\u000b\u0001\u0004\u0011Fc\u00010iS\")\u0001k\u0003a\u0001%\")ak\u0003a\u0001%R\u0011al\u001b\u0005\u0006!2\u0001\rA\u0015\u000b\u0002=\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\faAZ8veRD\u0017AC5oaV$H+\u001f9fgV\t1\u000fE\u0002uwzt!!\u001e>\u000f\u0005YLX\"A<\u000b\u0005a<\u0014A\u0002\u001fs_>$h(C\u0001K\u0013\t\u0019\u0015*\u0003\u0002}{\n\u00191+Z9\u000b\u0005\rK\u0005cA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007y\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\u0004\u0003\u0003\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0004\u0011\u0007}\fy!\u0003\u0003\u0002\u0012\u0005\u0005!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0015\u0005]\u0011QDA\u0011\u0003K\tI\u0003E\u0002I\u00033I1!a\u0007J\u0005\r\te.\u001f\u0005\b\u0003?!\u0002\u0019AA\f\u0003\r!\u0017-\u001f\u0005\b\u0003G!\u0002\u0019AA\f\u0003\u0011Aw.\u001e:\t\u000f\u0005\u001dB\u00031\u0001\u0002\u0018\u0005\u0019Q.\u001b8\t\u000f\u0005-B\u00031\u0001\u0002\u0018\u0005\u00191/Z2\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0019\u0003{\t9\u0005\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9dK\u0001\bG>$WmZ3o\u0013\u0011\tY$!\u000e\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0010\u0016\u0001\u0004\t\t%A\u0002dib\u0004B!a\r\u0002D%!\u0011QIA\u001b\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0013\u0016\u0001\u0004\t\t$\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005=\u0003\u0003BA)\u00033rA!a\u0015\u0002VA\u0011a/S\u0005\u0004\u0003/J\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0005u#AB*ue&twMC\u0002\u0002X%\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0013y\u000b\u0019'!\u001a\u0002h\u0005%\u0004\"\u0002)\u0018\u0001\u0004\u0011\u0006\"\u0002,\u0018\u0001\u0004\u0011\u0006\"\u0002-\u0018\u0001\u0004\u0011\u0006\"\u0002.\u0018\u0001\u0004\u0011\u0016\u0001B2paf$\u0012BXA8\u0003c\n\u0019(!\u001e\t\u000fAC\u0002\u0013!a\u0001%\"9a\u000b\u0007I\u0001\u0002\u0004\u0011\u0006b\u0002-\u0019!\u0003\u0005\rA\u0015\u0005\b5b\u0001\n\u00111\u0001S\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001f+\u0007I\u000bih\u000b\u0002\u0002\u0000A!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015!C;oG\",7m[3e\u0015\r\tI)S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAG\u0003\u0007\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\n\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\t1\fgn\u001a\u0006\u0003\u0003G\u000bAA[1wC&!\u00111LAO\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u000bE\u0002I\u0003[K1!a,J\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9\"!.\t\u0013\u0005]v$!AA\u0002\u0005-\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002>B1\u0011qXAc\u0003/i!!!1\u000b\u0007\u0005\r\u0017*\u0001\u0006d_2dWm\u0019;j_:LA!a2\u0002B\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti-a5\u0011\u0007!\u000by-C\u0002\u0002R&\u0013qAQ8pY\u0016\fg\u000eC\u0005\u00028\u0006\n\t\u00111\u0001\u0002\u0018\u00051Q-];bYN$B!!4\u0002Z\"I\u0011q\u0017\u0012\u0002\u0002\u0003\u0007\u0011q\u0003\u0015\u0018\u0001\u0005u\u00171]As\u0003S\fY/a<\u0002r\u0006U\u0018q_A~\u0003{\u00042AOAp\u0013\r\t\to\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9/\u00017`\rVs5i\u0018\u0015\\I\u0006L8o\u0017\u0017!Q>,(o].-A5Lgn].-AM,7m]/^;vK\u0003%\f\u0011NC.,\u0007\u0005R1z)&lW-\u00138uKJ4\u0018\r\u001c+za\u0016\u0004C-\u001e:bi&|g\u000e\t4s_6\u0004C-Y=tY\u0001Bw.\u001e:tY\u0001j\u0017N\\:!C:$\u0007e]3dg:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u00055\u0018Aa\f\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0017-_:![\u0001\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002\"\u0017-_:-AA|7/\u001b;jm\u0016\u0004sN\u001d\u0011oK\u001e\fG/\u001b<f\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001Bw.\u001e:tA5\u0002C\u000f[3!]Vl'-\u001a:!_\u001a\u0004\u0003n\\;sg2\u0002\u0003o\\:ji&4X\rI8sA9,w-\u0019;jm\u0016T\u0001\u0005\t\u0011!A\u0001R\u0003%\\5og\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007%\\5okR,7\u000f\f\u0011q_NLG/\u001b<fA=\u0014\bE\\3hCRLg/\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016!g\u0016\u001c7\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!g\u0016\u001cwN\u001c3tA]LG\u000f\u001b\u0011uQ\u0016\u0004cM]1di&|g.\u00197!a\u0006\u0014H\u000fI5oA5L7M]8tK\u000e|g\u000e\u001a\u0011qe\u0016\u001c\u0017n]5p]:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111_\u0001\u0002\u0004*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013\u0007\f\u00112e1\u00023\u0007\r\u0017!aEr\u0003\u0007M\u00191aEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019!cIR4\u0007\r\u001e1c9\u0002\u0004'\r\u00191cA\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007\t\u00191uA\u0002$\b\r\u0019/aA\u0002\u0004\u0007\r\u00191aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u00191Y\u0001rW\u000f\u001c7-AMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003s\fQa\r\u00183]A\nQa\u001a:pkB\f#!a@\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006qQ*Y6f\tRKe\u000e^3sm\u0006d\u0007C\u0001\u001e%'\u0011!#qA'\u0011\u0013\t%!q\u0002*S%JsVB\u0001B\u0006\u0015\r\u0011i!S\u0001\beVtG/[7f\u0013\u0011\u0011\tBa\u0003\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0003\u0004\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u001a\u0006)\u0011\r\u001d9msRIaL!\b\u0003 \t\u0005\"1\u0005\u0005\u0006!\u001e\u0002\rA\u0015\u0005\u0006-\u001e\u0002\rA\u0015\u0005\u00061\u001e\u0002\rA\u0015\u0005\u00065\u001e\u0002\rAU\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IC!\u000e\u0011\u000b!\u0013YCa\f\n\u0007\t5\u0012J\u0001\u0004PaRLwN\u001c\t\b\u0011\nE\"K\u0015*S\u0013\r\u0011\u0019$\u0013\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\t]\u0002&!AA\u0002y\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tu\u0002\u0003BAN\u0005\u007fIAA!\u0011\u0002\u001e\n1qJ\u00196fGR\u0004")
public class MakeDTInterval
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(MakeDTInterval makeDTInterval) {
        return MakeDTInterval$.MODULE$.unapply(makeDTInterval);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Expression>, MakeDTInterval> tupled() {
        return MakeDTInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, MakeDTInterval>>>> curried() {
        return MakeDTInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    @Override
    public Expression first() {
        return this.days();
    }

    @Override
    public Expression second() {
        return this.hours();
    }

    @Override
    public Expression third() {
        return this.mins();
    }

    @Override
    public Expression fourth() {
        return this.secs();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)new DecimalType(Decimal$.MODULE$.MAX_LONG_DIGITS(), 6), (List)Nil$.MODULE$))));
    }

    @Override
    public DataType dataType() {
        return DayTimeIntervalType$.MODULE$.apply();
    }

    @Override
    public Object nullSafeEval(Object day, Object hour, Object min, Object sec) {
        return BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.makeDayTimeInterval(BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(day, hour, min, sec) -> {
            String iu = new StringOps(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            return new StringBuilder(28).append(iu).append(".makeDayTimeInterval(").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", ").append((String)sec).append(")").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_dt_interval";
    }

    @Override
    public MakeDTInterval withNewChildrenInternal(Expression days, Expression hours, Expression mins, Expression secs) {
        return this.copy(days, hours, mins, secs);
    }

    public MakeDTInterval copy(Expression days, Expression hours, Expression mins, Expression secs) {
        return new MakeDTInterval(days, hours, mins, secs);
    }

    public Expression copy$default$1() {
        return this.days();
    }

    public Expression copy$default$2() {
        return this.hours();
    }

    public Expression copy$default$3() {
        return this.mins();
    }

    public Expression copy$default$4() {
        return this.secs();
    }

    @Override
    public String productPrefix() {
        return "MakeDTInterval";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.days();
                break;
            }
            case 1: {
                expression = this.hours();
                break;
            }
            case 2: {
                expression = this.mins();
                break;
            }
            case 3: {
                expression = this.secs();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDTInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDTInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDTInterval makeDTInterval = (MakeDTInterval)x$1;
        Expression expression = this.days();
        Expression expression2 = makeDTInterval.days();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.hours();
        Expression expression4 = makeDTInterval.hours();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.mins();
        Expression expression6 = makeDTInterval.mins();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.secs();
        Expression expression8 = makeDTInterval.secs();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!makeDTInterval.canEqual(this)) return false;
        return true;
    }

    public MakeDTInterval(Expression days, Expression hours, Expression mins, Expression secs) {
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        ExpectsInputTypes.$init$(this);
    }

    public MakeDTInterval(Expression days, Expression hours, Expression mins) {
        this(days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
    }

    public MakeDTInterval(Expression days, Expression hours) {
        this(days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeDTInterval(Expression days) {
        this(days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeDTInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

