/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Elt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(n, input1, input2, ...) - Returns the `n`-th input, e.g., returns `input2` when `n` is 2.\n    The function returns NULL if the index exceeds the length of the array\n    and `spark.sql.ansi.enabled` is set to false. If `spark.sql.ansi.enabled` is set to true,\n    it throws ArrayIndexOutOfBoundsException for invalid indices.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 'scala', 'java');\n       scala\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0011#\u0001>B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u007f!AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0006\u0001\"\u0001X\u0011!I\u0006\u0001#b\u0001\n\u0013Q\u0006\u0002C.\u0001\u0011\u000b\u0007I\u0011\u0002/\t\u000b\u0001\u0004A\u0011I'\t\u000b\u0005\u0004A\u0011\t2\t\u000b%\u0004A\u0011\t6\t\u000bE\u0004A\u0011\t:\t\u000bq\u0004A\u0011K?\t\u000f\u0005]\u0001\u0001\"\u0015\u0002\u001a!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003[\u0001\u0011\u0013!C\u0001\u0003_A\u0011\"!\u0012\u0001#\u0003%\t!a\u0012\t\u0013\u0005-\u0003!!A\u0005B\u00055\u0003\"CA0\u0001\u0005\u0005I\u0011AA1\u0011%\tI\u0007AA\u0001\n\u0003\tY\u0007C\u0005\u0002r\u0001\t\t\u0011\"\u0011\u0002t!I\u0011\u0011\u0011\u0001\u0002\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u000f\u0003\u0011\u0011!C!\u0003\u0013;\u0011\"!,#\u0003\u0003E\t!a,\u0007\u0011\u0005\u0012\u0013\u0011!E\u0001\u0003cCaAU\r\u0005\u0002\u0005}\u0006\"CAa3\u0005\u0005IQIAb\u0011%\t)-GA\u0001\n\u0003\u000b9\rC\u0005\u0002Nf\t\n\u0011\"\u0001\u0002H!I\u0011qZ\r\u0002\u0002\u0013\u0005\u0015\u0011\u001b\u0005\n\u0003GL\u0012\u0013!C\u0001\u0003\u000fB\u0011\"!:\u001a\u0003\u0003%I!a:\u0003\u0007\u0015cGO\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0007\u000e\u001e\u0011\u0005E\u0012T\"\u0001\u0012\n\u0005M\u0012#AC#yaJ,7o]5p]B\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t9\u0001K]8ek\u000e$\bCA\u001b<\u0013\tadG\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005dQ&dGM]3o+\u0005y\u0004c\u0001!Ia9\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t:\na\u0001\u0010:p_Rt\u0014\"A\u001c\n\u0005\u001d3\u0014a\u00029bG.\fw-Z\u0005\u0003\u0013*\u00131aU3r\u0015\t9e'A\u0005dQ&dGM]3oA\u0005Ya-Y5m\u001f:,%O]8s+\u0005q\u0005CA\u001bP\u0013\t\u0001fGA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\r!VK\u0016\t\u0003c\u0001AQ!P\u0003A\u0002}Bq\u0001T\u0003\u0011\u0002\u0003\u0007a\n\u0006\u0002U1\")QH\u0002a\u0001\u007f\u0005I\u0011N\u001c3fq\u0016C\bO]\u000b\u0002a\u0005Q\u0011N\u001c9vi\u0016C\bO]:\u0016\u0003u\u00032!\u000e01\u0013\tyfGA\u0003BeJ\f\u00170\u0001\u0005ok2d\u0017M\u00197f\u0003!!\u0017\r^1UsB,W#A2\u0011\u0005\u0011<W\"A3\u000b\u0005\u00194\u0013!\u0002;za\u0016\u001c\u0018B\u00015f\u0005!!\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A6\u0011\u00051|W\"A7\u000b\u00059$\u0013\u0001C1oC2L8/[:\n\u0005Al'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\t\u00154\u0018\r\u001c\u000b\u0003gZ\u0004\"!\u000e;\n\u0005U4$aA!os\"9q\u000f\u0004I\u0001\u0002\u0004A\u0018!B5oaV$\bCA={\u001b\u0005!\u0013BA>%\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,G#\u0002@\u0002\n\u0005M\u0001cA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007\u0011\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u000f\t\tA\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tY!\u0004a\u0001\u0003\u001b\t1a\u0019;y!\ry\u0018qB\u0005\u0005\u0003#\t\tA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005UQ\u00021\u0001\u007f\u0003\t)g/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019A+a\u0007\t\u000f\u0005ua\u00021\u0001\u0002 \u0005Ya.Z<DQ&dGM]3o!\u0011\u0001\u0015\u0011\u0005\u0019\n\u0007\u0005\r\"J\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsR)A+!\u000b\u0002,!9Qh\u0004I\u0001\u0002\u0004y\u0004b\u0002'\u0010!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tDK\u0002@\u0003gY#!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007f1\u0014AC1o]>$\u0018\r^5p]&!\u00111IA\u001d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIEK\u0002O\u0003g\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA(!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\nA\u0001\\1oO*\u0011\u0011\u0011L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002^\u0005M#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002dA\u0019Q'!\u001a\n\u0007\u0005\u001ddGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002t\u0003[B\u0011\"a\u001c\u0015\u0003\u0003\u0005\r!a\u0019\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\bE\u0003\u0002x\u0005u4/\u0004\u0002\u0002z)\u0019\u00111\u0010\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0000\u0005e$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2ATAC\u0011!\tyGFA\u0001\u0002\u0004\u0019\u0018AB3rk\u0006d7\u000fF\u0002O\u0003\u0017C\u0001\"a\u001c\u0018\u0003\u0003\u0005\ra\u001d\u0015\u0014\u0001\u0005=\u0015QSAL\u00037\u000bi*!)\u0002$\u0006\u001d\u0016\u0011\u0016\t\u0004c\u0005E\u0015bAAJE\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAM\u0003\t\u001d&\u0002\t\u0011!A}3UKT\"`Q9d\u0003%\u001b8qkR\fD\u0006I5oaV$(\u0007\f\u0011/]9J\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005\u00198a[QD\u0007%\u001b8qkRd\u0003%\u001a\u0018h]1\u0002#/\u001a;ve:\u001c\b\u0005Y5oaV$(\u0007\u0019\u0011xQ\u0016t\u0007\u0005\u00198aA%\u001c\bE\r\u0018\u000bA\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bET+M\u0019\u0002Jg\r\t;iK\u0002Jg\u000eZ3yA\u0015D8-Z3eg\u0002\"\b.\u001a\u0011mK:<G\u000f\u001b\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017P\u0003\u0011!A\u0001\ng\u000e\u001a\u0011agB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011gC2\u001cXM\f\u0011JM\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u0002\u001aX\r\u001e\u0011u_\u0002\"(/^3-\u0015\u0001\u0002\u0003\u0005I5uAQD'o\\<tA\u0005\u0013(/Y=J]\u0012,\u0007pT;u\u001f\u001a\u0014u.\u001e8eg\u0016C8-\u001a9uS>t\u0007EZ8sA%tg/\u00197jI\u0002Jg\u000eZ5dKNt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a(\u0002\u0013*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013\u0007\f\u0011(g\u000e\fG.Y\u0014-A\u001dR\u0017M^1(SmR\u0001\u0005\t\u0011!A\u0001\u00023oY1mC*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002&\u0006)!G\f\u0019/a\u0005)qM]8va\u0006\u0012\u00111V\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\u0004\u000b2$\bCA\u0019\u001a'\u0011I\u00121\u0017\u001e\u0011\u000f\u0005U\u00161X O)6\u0011\u0011q\u0017\u0006\u0004\u0003s3\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003{\u000b9LA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a,\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0014\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bQ\u000bI-a3\t\u000bub\u0002\u0019A \t\u000f1c\u0002\u0013!a\u0001\u001d\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005M\u0017q\u001c\t\u0006k\u0005U\u0017\u0011\\\u0005\u0004\u0003/4$AB(qi&|g\u000eE\u00036\u00037|d*C\u0002\u0002^Z\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAq=\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002jB!\u0011\u0011KAv\u0013\u0011\ti/a\u0015\u0003\r=\u0013'.Z2u\u0001")
public class Elt
extends Expression
implements scala.Serializable {
    private Expression indexExpr;
    private Expression[] inputExprs;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Elt$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Elt elt) {
        return Elt$.MODULE$.unapply(elt);
    }

    public static boolean apply$default$2() {
        return Elt$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Elt> tupled() {
        return Elt$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Elt>> curried() {
        return Elt$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private Expression indexExpr$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.indexExpr = (Expression)this.children().head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.indexExpr;
    }

    private Expression indexExpr() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.indexExpr$lzycompute() : this.indexExpr;
    }

    private Expression[] inputExprs$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.inputExprs = (Expression[])((TraversableOnce)this.children().tail()).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.inputExprs;
    }

    private Expression[] inputExprs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.inputExprs$lzycompute() : this.inputExprs;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (this.children().size() < 2) {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure("elt function requires at least two arguments");
        } else {
            Tuple2 tuple2 = new Tuple2((Object)this.indexExpr().dataType(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType indexType = (DataType)tuple2._1();
            DataType[] inputTypes = (DataType[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)inputTypes);
            Tuple2 tuple23 = tuple22;
            DataType indexType2 = (DataType)tuple23._1();
            DataType[] inputTypes2 = (DataType[])tuple23._2();
            DataType dataType = indexType2;
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append("first input to function ").append(this.prettyName()).append(" should ").append("have ").append(IntegerType$.MODULE$.catalogString()).append(", but it's ").append(indexType2.catalogString()).toString());
            }
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputTypes2)).exists((Function1 & Serializable & scala.Serializable)tpe -> BoxesRunTime.boxToBoolean((boolean)Elt.$anonfun$checkInputDataTypes$2(tpe)))) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("input to function ").append(this.prettyName()).append(" should have ").append(StringType$.MODULE$.catalogString()).append(" or ").append(BinaryType$.MODULE$.catalogString()).append(", but it's ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputTypes2)).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.catalogString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ", ", "]")).toString());
            }
            typeCheckResult = TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)Predef$.MODULE$.wrapRefArray((Object[])inputTypes2), new StringBuilder(9).append("function ").append(this.prettyName()).toString());
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object indexObj = this.indexExpr().eval(input);
        if (indexObj == null) {
            object = null;
        } else {
            int index = BoxesRunTime.unboxToInt((Object)indexObj);
            if (index <= 0 || index > this.inputExprs().length) {
                if (this.failOnError()) {
                    throw QueryExecutionErrors$.MODULE$.invalidArrayIndexError(index, this.inputExprs().length);
                }
                object = null;
            } else {
                object = this.inputExprs()[index - 1].eval(input);
            }
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode index = this.indexExpr().genCode(ctx);
        ExprCode[] inputs = (ExprCode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.genCode(ctx), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExprCode.class)));
        String indexVal = ctx.freshName("index");
        String indexMatched = ctx.freshName("eltIndexMatched");
        String inputVal = ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), "inputVal", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String[] assignInputValue = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExprCode eval = (ExprCode)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n         |if (").append(indexVal).append(" == ").append(index + 1).append(") {\n         |  ").append(eval.code()).append("\n         |  ").append(inputVal).append(" = ").append(eval.isNull()).append(" ? null : ").append(eval.value()).append(";\n         |  ").append(indexMatched).append(" = true;\n         |  continue;\n         |}\n      ").toString())).stripMargin();
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Tuple2 tuple2 = new Tuple2((Object)"int", (Object)indexVal);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])assignInputValue), "eltFunc", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple2), "boolean", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)body -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n           |").append("boolean").append(" ").append(indexMatched).append(" = false;\n           |do {\n           |  ").append((String)body).append("\n           |} while (false);\n           |return ").append(indexMatched).append(";\n         ").toString())).stripMargin(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)x$26 -> ((TraversableOnce)x$26.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("\n           |").append(indexMatched).append(" = ").append((String)funcCall).append(";\n           |if (").append(indexMatched).append(") {\n           |  continue;\n           |}\n         ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom())).mkString());
        String indexOutOfBoundBranch = this.failOnError() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(106).append("\n         |if (!").append(indexMatched).append(") {\n         |  throw QueryExecutionErrors.invalidArrayIndexError(").append(index.value()).append(", ").append(this.inputExprs().length).append(");\n         |}\n       ").toString())).stripMargin() : "";
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |final int ", " = ", ";\n         |", " ", " = false;\n         |", " = null;\n         |do {\n         |  ", "\n         |} while (false);\n         |", "\n         |final ", " ", " = ", ";\n         |final boolean ", " = ", " == null;\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{index.code(), indexVal, index.value(), "boolean", indexMatched, inputVal, codes, indexOutOfBoundBranch, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), inputVal, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public Elt withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public Elt copy(Seq<Expression> children2, boolean failOnError) {
        return new Elt(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Elt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Elt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Elt)) return false;
        boolean bl = true;
        if (!bl) return false;
        Elt elt = (Elt)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = elt.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.failOnError() != elt.failOnError()) return false;
        if (!elt.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(DataType tpe) {
        return !((SeqLike)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$))).contains((Object)tpe);
    }

    public Elt(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
    }

    public Elt(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

