/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class EstimationUtils$ {
    public static final EstimationUtils$ MODULE$;

    static {
        new EstimationUtils$();
    }

    public boolean rowCountsExist(SQLConf conf, Seq<LogicalPlan> plans2) {
        return plans2.forall((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final SQLConf conf$1;

            public final boolean apply(LogicalPlan x$1) {
                return x$1.stats(this.conf$1).rowCount().isDefined();
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    public boolean columnStatsExist(Seq<Tuple2<Statistics, Attribute>> statsAndAttr) {
        return statsAndAttr.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Statistics, Attribute> x0$1) {
                Tuple2<Statistics, Attribute> tuple2 = x0$1;
                if (tuple2 != null) {
                    Statistics stats2 = (Statistics)tuple2._1();
                    Attribute attr = (Attribute)tuple2._2();
                    boolean bl = stats2.attributeStats().contains(attr);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public ColumnStat nullColumnStat(DataType dataType2, BigInt rowCount) {
        return new ColumnStat(BigInt$.MODULE$.int2bigInt(0), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, rowCount, dataType2.defaultSize(), dataType2.defaultSize());
    }

    public BigInt updateNdv(BigInt oldNumRows, BigInt newNumRows, BigInt oldNdv) {
        return newNumRows.$less(oldNumRows) ? this.ceil(package$.MODULE$.BigDecimal().apply(oldNdv).$times(package$.MODULE$.BigDecimal().apply(newNumRows)).$div(package$.MODULE$.BigDecimal().apply(oldNumRows))) : oldNdv;
    }

    public BigInt ceil(BigDecimal bigDecimal) {
        return bigDecimal.setScale(0, BigDecimal.RoundingMode$.MODULE$.CEILING()).toBigInt();
    }

    public AttributeMap<ColumnStat> getOutputMap(AttributeMap<ColumnStat> inputMap, Seq<Attribute> output2) {
        return AttributeMap$.MODULE$.apply((Seq)output2.flatMap((Function1)new Serializable(inputMap){
            public static final long serialVersionUID = 0L;
            private final AttributeMap inputMap$1;

            public final Iterable<Tuple2<Attribute, ColumnStat>> apply(Attribute a) {
                return Option$.MODULE$.option2Iterable(this.inputMap$1.get(a).map((Function1)new Serializable(this, a){
                    public static final long serialVersionUID = 0L;
                    private final Attribute a$1;

                    public final Tuple2<Attribute, ColumnStat> apply(ColumnStat x$2) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.a$1), (Object)x$2);
                    }
                    {
                        this.a$1 = a$1;
                    }
                }));
            }
            {
                this.inputMap$1 = inputMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public BigInt getOutputSize(Seq<Attribute> attributes, BigInt outputRowCount, AttributeMap<ColumnStat> attrStats) {
        long sizePerRow = 8L + BoxesRunTime.unboxToLong((Object)((TraversableOnce)attributes.map((Function1)new Serializable(attrStats){
            public static final long serialVersionUID = 0L;
            private final AttributeMap attrStats$1;

            public final long apply(Attribute attr) {
                long l;
                if (this.attrStats$1.contains(attr)) {
                    DataType dataType2 = attr.dataType();
                    StringType$ stringType$ = StringType$.MODULE$;
                    DataType dataType3 = dataType2;
                    long l2 = !(stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null) ? ((ColumnStat)this.attrStats$1.apply(attr)).avgLen() + 8L + 4L : ((ColumnStat)this.attrStats$1.apply(attr)).avgLen();
                    l = l2;
                } else {
                    l = attr.dataType().defaultSize();
                }
                return l;
            }
            {
                this.attrStats$1 = attrStats$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return outputRowCount.$greater(BigInt$.MODULE$.int2bigInt(0)) ? outputRowCount.$times(BigInt$.MODULE$.long2bigInt(sizePerRow)) : BigInt$.MODULE$.int2bigInt(1);
    }

    public AttributeMap<ColumnStat> getOutputSize$default$3() {
        return AttributeMap$.MODULE$.apply(Nil$.MODULE$);
    }

    public Decimal toDecimal(Object value2, DataType dataType2) {
        DataType dataType3;
        block9: {
            Decimal decimal;
            block8: {
                block7: {
                    boolean bl;
                    dataType3 = dataType2;
                    if (dataType3 instanceof NumericType) {
                        bl = true;
                    } else {
                        DateType$ dateType$ = DateType$.MODULE$;
                        DataType dataType4 = dataType3;
                        if (!(dateType$ != null ? !dateType$.equals(dataType4) : dataType4 != null)) {
                            bl = true;
                        } else {
                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                            DataType dataType5 = dataType3;
                            bl = !(timestampType$ != null ? !timestampType$.equals(dataType5) : dataType5 != null);
                        }
                    }
                    if (!bl) break block7;
                    decimal = Decimal$.MODULE$.apply(value2.toString());
                    break block8;
                }
                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                DataType dataType6 = dataType3;
                if (booleanType$ != null ? !booleanType$.equals(dataType6) : dataType6 != null) break block9;
                decimal = BoxesRunTime.unboxToBoolean((Object)value2) ? Decimal$.MODULE$.apply(1) : Decimal$.MODULE$.apply(0);
            }
            return decimal;
        }
        throw new MatchError((Object)dataType3);
    }

    public Object fromDecimal(Decimal dec, DataType dataType2) {
        DataType dataType3;
        block12: {
            Object object;
            block3: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    dataType3 = dataType2;
                                                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                                    DataType dataType4 = dataType3;
                                                    if (booleanType$ != null ? !booleanType$.equals(dataType4) : dataType4 != null) break block2;
                                                    object = BoxesRunTime.boxToBoolean((dec.toLong() == 1L ? 1 : 0) != 0);
                                                    break block3;
                                                }
                                                DateType$ dateType$ = DateType$.MODULE$;
                                                DataType dataType5 = dataType3;
                                                if (dateType$ != null ? !dateType$.equals(dataType5) : dataType5 != null) break block4;
                                                object = BoxesRunTime.boxToInteger((int)dec.toInt());
                                                break block3;
                                            }
                                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                            DataType dataType6 = dataType3;
                                            if (timestampType$ != null ? !timestampType$.equals(dataType6) : dataType6 != null) break block5;
                                            object = BoxesRunTime.boxToLong((long)dec.toLong());
                                            break block3;
                                        }
                                        ByteType$ byteType$ = ByteType$.MODULE$;
                                        DataType dataType7 = dataType3;
                                        if (byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null) break block6;
                                        object = BoxesRunTime.boxToByte((byte)dec.toByte());
                                        break block3;
                                    }
                                    ShortType$ shortType$ = ShortType$.MODULE$;
                                    DataType dataType8 = dataType3;
                                    if (shortType$ != null ? !shortType$.equals(dataType8) : dataType8 != null) break block7;
                                    object = BoxesRunTime.boxToShort((short)dec.toShort());
                                    break block3;
                                }
                                IntegerType$ integerType$ = IntegerType$.MODULE$;
                                DataType dataType9 = dataType3;
                                if (integerType$ != null ? !integerType$.equals(dataType9) : dataType9 != null) break block8;
                                object = BoxesRunTime.boxToInteger((int)dec.toInt());
                                break block3;
                            }
                            LongType$ longType$ = LongType$.MODULE$;
                            DataType dataType10 = dataType3;
                            if (longType$ != null ? !longType$.equals(dataType10) : dataType10 != null) break block9;
                            object = BoxesRunTime.boxToLong((long)dec.toLong());
                            break block3;
                        }
                        FloatType$ floatType$ = FloatType$.MODULE$;
                        DataType dataType11 = dataType3;
                        if (floatType$ != null ? !floatType$.equals(dataType11) : dataType11 != null) break block10;
                        object = BoxesRunTime.boxToFloat((float)dec.toFloat());
                        break block3;
                    }
                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                    DataType dataType12 = dataType3;
                    if (doubleType$ != null ? !doubleType$.equals(dataType12) : dataType12 != null) break block11;
                    object = BoxesRunTime.boxToDouble((double)dec.toDouble());
                    break block3;
                }
                if (!(dataType3 instanceof DecimalType)) break block12;
                object = dec;
            }
            return object;
        }
        throw new MatchError((Object)dataType3);
    }

    private EstimationUtils$() {
        MODULE$ = this;
    }
}

