/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr[, relativeSD]) - Returns the estimated cardinality by HyperLogLog++.\n      `relativeSD` defines the maximum estimation error allowed.\n  ")
@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u0001\u0003\u0001F\u00111\u0003S=qKJdun\u001a'pOBcWo\u001d)mkNT!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011b\u0003\b\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tA\u0001\u0011)\u001a!C\u0001C\u0005)1\r[5mIV\t!\u0005\u0005\u0002$I5\tA!\u0003\u0002&\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\t\naa\u00195jY\u0012\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0016\u0002\u0015I,G.\u0019;jm\u0016\u001cF)F\u0001,!\t9B&\u0003\u0002.1\t1Ai\\;cY\u0016D\u0001b\f\u0001\u0003\u0012\u0003\u0006IaK\u0001\fe\u0016d\u0017\r^5wKN#\u0005\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A\u001a\u0011\u0005]!\u0014BA\u001b\u0019\u0005\rIe\u000e\u001e\u0005\to\u0001\u0011\t\u0012)A\u0005g\u00059R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\t\u0005\ts\u0001\u0011)\u001a!C\u0001e\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0001b\u000f\u0001\u0003\u0012\u0003\u0006IaM\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q)q\bQ!C\u0007B\u00111\u0003\u0001\u0005\u0006Aq\u0002\rA\t\u0005\bSq\u0002\n\u00111\u0001,\u0011\u001d\tD\b%AA\u0002MBq!\u000f\u001f\u0011\u0002\u0003\u00071\u0007C\u0003>\u0001\u0011\u0005Q\t\u0006\u0002@\r\")\u0001\u0005\u0012a\u0001E!)Q\b\u0001C\u0001\u0011R\u0019q(\u0013&\t\u000b\u0001:\u0005\u0019\u0001\u0012\t\u000b%:\u0005\u0019\u0001\u0012\t\u000b1\u0003A\u0011I'\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001O!\ty%K\u0004\u0002\u0018!&\u0011\u0011\u000bG\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R1!)a\u000b\u0001C!/\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0002\u00131\")\u0011,\u0016a\u0001g\u0005Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u0015Y\u0006\u0001\"\u0011]\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0011!#\u0018\u0005\u0006=j\u0003\raM\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0011\u0002\u0019\u0001\u0003\u0002\u0003\u0005\u000b\u0011A\u001a\u0002\u0015>\u0014x\rJ1qC\u000eDW\rJ:qCJ\\Ge]9mI\r\fG/\u00197zgR$S\r\u001f9sKN\u001c\u0018n\u001c8tI\u0005<wM]3hCR,G\u0005S=qKJdun\u001a'pOBcWo\u001d)mkN$C\u0005\u001d\u0005\u0007E\u0002\u0001\u000b\u0011B\u001a\u0002\u0011%$\u0007p\u00155jMRDa\u0001\u001a\u0001!\u0002\u0013)\u0017\u0001C<QC\u0012$\u0017N\\4\u0011\u0005]1\u0017BA4\u0019\u0005\u0011auN\\4\t\u0013%\u0004!\u0011!A!\u0002\u0003\u0019\u0014AS8sO\u0012\n\u0007/Y2iK\u0012\u001a\b/\u0019:lIM\fH\u000eJ2bi\u0006d\u0017p\u001d;%Kb\u0004(/Z:tS>t7\u000fJ1hOJ,w-\u0019;fI!K\b/\u001a:M_\u001edun\u001a)mkN\u0004F.^:%I5Daa\u001b\u0001!\u0002\u0013Y\u0013aB1ma\"\fWJ\r\u0005\u0007[\u0002\u0001\u000b\u0011B\u001a\u0002\u00119,XnV8sINDQa\u001c\u0001\u0005BA\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002cB\u0019!O\u001f\u0012\u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<\u0011\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002z1\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005\r\u0019V-\u001d\u0006\u0003sbAQA \u0001\u0005B}\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003\u0003\u00012aFA\u0002\u0013\r\t)\u0001\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\t\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'A\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\f\u0003#\u0011\u0001\u0002R1uCRK\b/\u001a\u0005\b\u00037\u0001A\u0011IA\u000f\u0003=\twm\u001a\"vM\u001a,'oU2iK6\fWCAA\u0010!\u0011\ty!!\t\n\t\u0005\r\u0012\u0011\u0003\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"CA\u0014\u0001\t\u0007I\u0011IA\u0015\u0003M\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t+\t\tY\u0003\u0005\u0003su\u00065\u0002cA\u0012\u00020%\u0019\u0011\u0011\u0007\u0003\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-\u001a\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002,\u0005!\u0012mZ4Ck\u001a4WM]!uiJL'-\u001e;fg\u0002B\u0011\"!\u000f\u0001\u0005\u0004%\t%!\u000b\u00021%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7\u000f\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u0016\u0003eIg\u000e];u\u0003\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm\u001d\u0011\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\t\u0005\u0015\u00131\n\t\u0004/\u0005\u001d\u0013bAA%1\t!QK\\5u\u0011!\ti%a\u0010A\u0002\u0005=\u0013A\u00022vM\u001a,'\u000f\u0005\u0003\u0002R\u0005MS\"\u0001\u0004\n\u0007\u0005UcAA\u0006J]R,'O\\1m%><\bbBA-\u0001\u0011\u0005\u00131L\u0001\u0007kB$\u0017\r^3\u0015\r\u0005\u0015\u0013QLA0\u0011!\ti%a\u0016A\u0002\u0005=\u0003\u0002CA1\u0003/\u0002\r!a\u0014\u0002\u000b%t\u0007/\u001e;\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h\u0005)Q.\u001a:hKR1\u0011QIA5\u0003[B\u0001\"a\u001b\u0002d\u0001\u0007\u0011qJ\u0001\bEV4g-\u001a:2\u0011!\ty'a\u0019A\u0002\u0005=\u0013a\u00022vM\u001a,'O\r\u0005\b\u0003g\u0002A\u0011AA;\u00031)7\u000f^5nCR,')[1t)\rY\u0013q\u000f\u0005\b\u0003s\n\t\b1\u0001,\u0003\u0005)\u0007bBA?\u0001\u0011\u0005\u0013qP\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002\u0002\u0006\u001d\u0005cA\f\u0002\u0004&\u0019\u0011Q\u0011\r\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002N\u0005m\u0004\u0013!a\u0001\u0003\u001fBa!a#\u0001\t\u0003Q\u0013a\u0002;sk\u0016\u00146\u000f\u001a\u0005\n\u0003\u001f\u0003\u0011\u0011!C\u0001\u0003#\u000bAaY8qsRIq(a%\u0002\u0016\u0006]\u0015\u0011\u0014\u0005\tA\u00055\u0005\u0013!a\u0001E!A\u0011&!$\u0011\u0002\u0003\u00071\u0006\u0003\u00052\u0003\u001b\u0003\n\u00111\u00014\u0011!I\u0014Q\u0012I\u0001\u0002\u0004\u0019\u0004\"CAO\u0001E\u0005I\u0011AAP\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!)+\u0007\t\n\u0019k\u000b\u0002\u0002&B!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016!C;oG\",7m[3e\u0015\r\ty\u000bG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAZ\u0003S\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\fAI\u0001\n\u0003\tI,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m&fA\u0016\u0002$\"I\u0011q\u0018\u0001\u0012\u0002\u0013\u0005\u0011\u0011Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019MK\u00024\u0003GC\u0011\"a2\u0001#\u0003%\t!!1\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!I\u00111\u001a\u0001\u0002\u0002\u0013\u0005\u0013QZ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0007\u0003BAi\u00037l!!a5\u000b\t\u0005U\u0017q[\u0001\u0005Y\u0006twM\u0003\u0002\u0002Z\u0006!!.\u0019<b\u0013\r\u0019\u00161\u001b\u0005\t\u0003?\u0004\u0011\u0011!C\u0001e\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u00111\u001d\u0001\u0002\u0002\u0013\u0005\u0011Q]\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t)a:\t\u0013\u0005%\u0018\u0011]A\u0001\u0002\u0004\u0019\u0014a\u0001=%c!I\u0011Q\u001e\u0001\u0002\u0002\u0013\u0005\u0013q^\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001f\t\u0007\u0003g\fI0!!\u000e\u0005\u0005U(bAA|1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0018Q\u001f\u0002\t\u0013R,'/\u0019;pe\"I\u0011q \u0001\u0002\u0002\u0013\u0005!\u0011A\u0001\tG\u0006tW)];bYR!\u0011\u0011\u0001B\u0002\u0011)\tI/!@\u0002\u0002\u0003\u0007\u0011\u0011\u0011\u0005\n\u0005\u000f\u0001\u0011\u0011!C!\u0005\u0013\ta!Z9vC2\u001cH\u0003BA\u0001\u0005\u0017A!\"!;\u0003\u0006\u0005\u0005\t\u0019AAAQ\u001d\u0001!q\u0002B\u000b\u0005/\u00012a\tB\t\u0013\r\u0011\u0019\u0002\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011I\"AA\u001a\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJ\\F\u0006\t:fY\u0006$\u0018N^3T\tvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%Z:uS6\fG/\u001a3!G\u0006\u0014H-\u001b8bY&$\u0018\u0010\t2zA!K\b/\u001a:M_\u001edunZ\u0016,])\u0001\u0003\u0005\t\u0011!A\u0001\u0014X\r\\1uSZ,7\u000b\u00121!I\u00164\u0017N\\3tAQDW\rI7bq&lW/\u001c\u0011fgRLW.\u0019;j_:\u0004SM\u001d:pe\u0002\nG\u000e\\8xK\u0012t#\u0002\t\u0011\b\u000f\tu!\u0001#\u0001\u0003 \u0005\u0019\u0002*\u001f9fe2{w\rT8h!2,8\u000f\u00157vgB\u00191C!\t\u0007\r\u0005\u0011\u0001\u0012\u0001B\u0012'\u0015\u0011\tC!\n\u001d!\r9\"qE\u0005\u0004\u0005SA\"AB!osJ+g\rC\u0004>\u0005C!\tA!\f\u0015\u0005\t}\u0001\"\u0003B\u0019\u0005C\u0011\r\u0011\"\u00013\u0003%9vJ\u0015#`'&SV\t\u0003\u0005\u00036\t\u0005\u0002\u0015!\u00034\u0003)9vJ\u0015#`'&SV\t\t\u0005\n\u0005s\u0011\tC1A\u0005\u0002I\nQBU#H\u0013N#VIU0T\u0013j+\u0005\u0002\u0003B\u001f\u0005C\u0001\u000b\u0011B\u001a\u0002\u001dI+u)S*U\u000bJ{6+\u0013.FA!Q!\u0011\tB\u0011\u0005\u0004%\tAa\u0011\u0002%I+u)S*U\u000bJ{vk\u0014*E?6\u000b5kS\u000b\u0002K\"A!q\tB\u0011A\u0003%Q-A\nS\u000b\u001eK5\u000bV#S?^{%\u000bR0N\u0003N[\u0005\u0005C\u0005\u0003L\t\u0005\"\u0019!C\u0001e\u0005\u0011\"+R$J'R+%kU0Q\u000bJ{vk\u0014*E\u0011!\u0011yE!\t!\u0002\u0013\u0019\u0014a\u0005*F\u000f&\u001bF+\u0012*T?B+%kX,P%\u0012\u0003\u0003\"\u0003B*\u0005C\u0011\r\u0011\"\u00013\u0003\u0005Y\u0005\u0002\u0003B,\u0005C\u0001\u000b\u0011B\u001a\u0002\u0005-\u0003\u0003B\u0003B.\u0005C\u0011\r\u0011\"\u0001\u0003^\u0005QA\u000b\u0013*F'\"{E\nR*\u0016\u0005\t}\u0003\u0003B\f\u0003b-J1Aa\u0019\u0019\u0005\u0015\t%O]1z\u0011%\u00119G!\t!\u0002\u0013\u0011y&A\u0006U\u0011J+5\u000bS(M\tN\u0003\u0003B\u0003B6\u0005C\u0011\r\u0011\"\u0001\u0003n\u0005\t\"+Q,`\u000bN#\u0016*T!U\u000b~#\u0015\tV!\u0016\u0005\t=\u0004#B\f\u0003b\t}\u0003\"\u0003B:\u0005C\u0001\u000b\u0011\u0002B8\u0003I\u0011\u0016iV0F'RKU*\u0011+F?\u0012\u000bE+\u0011\u0011\t\u0015\t]$\u0011\u0005b\u0001\n\u0003\u0011i'A\u0005C\u0013\u0006\u001bv\fR!U\u0003\"I!1\u0010B\u0011A\u0003%!qN\u0001\u000b\u0005&\u000b5k\u0018#B)\u0006\u0003\u0003\u0002\u0003B@\u0005C!IA!!\u0002+Y\fG.\u001b3bi\u0016$u.\u001e2mK2KG/\u001a:bYR\u00191Fa!\t\u000f\t\u0015%Q\u0010a\u0001E\u0005\u0019Q\r\u001f9\t\u0015\t%%\u0011EA\u0001\n\u0003\u0013Y)A\u0003baBd\u0017\u0010F\u0005@\u0005\u001b\u0013yI!%\u0003\u0014\"1\u0001Ea\"A\u0002\tB\u0001\"\u000bBD!\u0003\u0005\ra\u000b\u0005\tc\t\u001d\u0005\u0013!a\u0001g!A\u0011Ha\"\u0011\u0002\u0003\u00071\u0007\u0003\u0006\u0003\u0018\n\u0005\u0012\u0011!CA\u00053\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001c\n\u001d\u0006#B\f\u0003\u001e\n\u0005\u0016b\u0001BP1\t1q\n\u001d;j_:\u0004ra\u0006BRE-\u001a4'C\u0002\u0003&b\u0011a\u0001V;qY\u0016$\u0004\"\u0003BU\u0005+\u000b\t\u00111\u0001@\u0003\rAH\u0005\r\u0005\u000b\u0005[\u0013\t#%A\u0005\u0002\u0005e\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\t\u0015\tE&\u0011EI\u0001\n\u0003\t\t-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011)\u0011)L!\t\u0012\u0002\u0013\u0005\u0011\u0011Y\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i!Q!\u0011\u0018B\u0011#\u0003%\t!!/\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011)\u0011iL!\t\u0012\u0002\u0013\u0005\u0011\u0011Y\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0015\t\u0005'\u0011EI\u0001\n\u0003\t\t-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0005\u000b\u0014\t#!A\u0005\n\t\u001d\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!3\u0011\t\u0005E'1Z\u0005\u0005\u0005\u001b\f\u0019N\u0001\u0004PE*,7\r\u001e")
public class HyperLogLogPlusPlus
extends ImperativeAggregate
implements Serializable {
    private final Expression child;
    private final double relativeSD;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
    private final int idxShift;
    private final long wPadding;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
    private final double alphaM2;
    private final int numWords;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<AttributeReference> inputAggBufferAttributes;

    public static int $lessinit$greater$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$2();
    }

    public static int apply$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$2();
    }

    public static double[][] BIAS_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.BIAS_DATA();
    }

    public static double[][] RAW_ESTIMATE_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA();
    }

    public static double[] THRESHOLDS() {
        return HyperLogLogPlusPlus$.MODULE$.THRESHOLDS();
    }

    public static int K() {
        return HyperLogLogPlusPlus$.MODULE$.K();
    }

    public static int REGISTERS_PER_WORD() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
    }

    public static long REGISTER_WORD_MASK() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
    }

    public static int REGISTER_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
    }

    public static int WORD_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.WORD_SIZE();
    }

    public Expression child() {
        return this.child;
    }

    public double relativeSD() {
        return this.relativeSD;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "approx_count_distinct";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$2 = newMutableAggBufferOffset;
        Expression x$3 = this.copy$default$1();
        double x$4 = this.copy$default$2();
        int x$5 = this.copy$default$4();
        return this.copy(x$3, x$4, x$2, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$6 = newInputAggBufferOffset;
        Expression x$7 = this.copy$default$1();
        double x$8 = this.copy$default$2();
        int x$9 = this.copy$default$3();
        return this.copy(x$7, x$8, x$9, x$6);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public StructType aggBufferSchema() {
        return StructType$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        for (int word = 0; word < this.numWords; ++word) {
            buffer.setLong(this.mutableAggBufferOffset() + word, 0L);
        }
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        Object v = this.child().eval(input);
        if (v != null) {
            long x = XxHash64Function$.MODULE$.hash(v, this.child().dataType(), 42L);
            int idx = (int)(x >>> this.idxShift);
            long pw = (long)Long.numberOfLeadingZeros(x << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p | this.wPadding) + 1L;
            int wordOffset = idx / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE() * (idx - wordOffset * HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD());
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK() << shift;
            long Midx = (word & mask) >>> shift;
            if (pw > Midx) {
                buffer.setLong(this.mutableAggBufferOffset() + wordOffset, word & (mask ^ 0xFFFFFFFFFFFFFFFFL) | pw << shift);
            }
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word1 = buffer1.getLong(this.mutableAggBufferOffset() + wordOffset);
            long word2 = buffer2.getLong(this.inputAggBufferOffset() + wordOffset);
            long word = 0L;
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                word |= Math.max(word1 & mask, word2 & mask);
                mask <<= HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
            buffer1.setLong(this.mutableAggBufferOffset() + wordOffset, word);
        }
    }

    public double estimateBias(double e) {
        int high;
        double[] estimates = HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        int numEstimates = estimates.length;
        int n = Arrays.binarySearch(estimates, 0, numEstimates, e);
        switch (n) {
            default: 
        }
        int nearestEstimateIndex = n < 0 ? -(n + 1) : n;
        int low = package$.MODULE$.max(nearestEstimateIndex - HyperLogLogPlusPlus$.MODULE$.K() + 1, 0);
        for (high = package$.MODULE$.min(low + HyperLogLogPlusPlus$.MODULE$.K(), numEstimates); high < numEstimates && this.distance$1(high, e, estimates) < this.distance$1(low, e, estimates); ++high) {
            ++low;
        }
        double[] biases = HyperLogLogPlusPlus$.MODULE$.BIAS_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        double biasSum = 0.0;
        for (int i = low; i < high; ++i) {
            biasSum += biases[i];
        }
        return biasSum / (double)(high - low);
    }

    @Override
    public Object eval(InternalRow buffer) {
        double d;
        double zInverse = 0.0;
        double V = 0.0;
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = 0;
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                long Midx = word >>> shift & HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
                zInverse += 1.0 / (double)(1L << (int)Midx);
                if (Midx == 0L) {
                    V += 1.0;
                }
                shift += HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
        }
        double E = this.alphaM2 / zInverse;
        if (V > 0.0) {
            double H = (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * Math.log((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / V);
            d = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && H <= HyperLogLogPlusPlus$.MODULE$.THRESHOLDS()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4] || E <= 2.5 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? H : this.EBiasCorrected$1(E);
        } else {
            d = this.EBiasCorrected$1(E);
        }
        double estimate2 = d;
        return BoxesRunTime.boxToLong((long)Math.round(estimate2));
    }

    public double trueRsd() {
        return 1.04 / package$.MODULE$.sqrt((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m);
    }

    public HyperLogLogPlusPlus copy(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HyperLogLogPlusPlus(child, relativeSD, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public double copy$default$2() {
        return this.relativeSD();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HyperLogLogPlusPlus";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.relativeSD());
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HyperLogLogPlusPlus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HyperLogLogPlusPlus)) return false;
        boolean bl = true;
        if (!bl) return false;
        HyperLogLogPlusPlus hyperLogLogPlusPlus = (HyperLogLogPlusPlus)x$1;
        Expression expression = this.child();
        Expression expression2 = hyperLogLogPlusPlus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.relativeSD() != hyperLogLogPlusPlus.relativeSD()) return false;
        if (this.mutableAggBufferOffset() != hyperLogLogPlusPlus.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hyperLogLogPlusPlus.inputAggBufferOffset()) return false;
        if (!hyperLogLogPlusPlus.canEqual(this)) return false;
        return true;
    }

    private final double distance$1(int i, double e$1, double[] estimates$1) {
        double diff = e$1 - estimates$1[i];
        return diff * diff;
    }

    private final double EBiasCorrected$1(double E$1) {
        double d = E$1;
        double d2 = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && d < 5.0 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? d - this.estimateBias(d) : d;
        return d2;
    }

    public HyperLogLogPlusPlus(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        double d;
        this.child = child;
        this.relativeSD = relativeSD;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p = (int)Math.ceil(2.0 * Math.log(1.106 / relativeSD) / Math.log(2.0));
        Predef$.MODULE$.require(this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p >= 4, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "HLL++ requires at least 4 bits for addressing. Use a lower error, at most 39%.";
            }
        });
        this.idxShift = 64 - this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        this.wPadding = 1L << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 1;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m = 1 << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        int n = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        switch (n) {
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m) * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 6: {
                d = 0.709 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 5: {
                d = 0.697 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 4: {
                d = 0.673 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
            }
        }
        this.alphaM2 = d;
        this.numWords = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD() + 1;
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.tabulate(this.numWords, (Function1)new $anonfun$2(this));
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1)new $anonfun$3(this), Seq$.MODULE$.canBuildFrom());
    }

    public HyperLogLogPlusPlus(Expression child) {
        this(child, 0.05, 0, 0);
    }

    public HyperLogLogPlusPlus(Expression child, Expression relativeSD) {
        this(child, HyperLogLogPlusPlus$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$validateDoubleLiteral(relativeSD), 0, 0);
    }
}

