/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.PreemptiveAuth;
import org.apache.solr.client.solrj.impl.SolrHttpRequestRetryHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    public static final String PROP_SO_TIMEOUT = "socketTimeout";
    public static final String PROP_CONNECTION_TIMEOUT = "connTimeout";
    public static final String PROP_MAX_CONNECTIONS_PER_HOST = "maxConnectionsPerHost";
    public static final String PROP_MAX_CONNECTIONS = "maxConnections";
    public static final String PROP_USE_RETRY = "retry";
    public static final String PROP_ALLOW_COMPRESSION = "allowCompression";
    public static final String PROP_FOLLOW_REDIRECTS = "followRedirects";
    public static final String PROP_BASIC_AUTH_USER = "httpBasicAuthUser";
    public static final String PROP_BASIC_AUTH_PASS = "httpBasicAuthPassword";
    public static final String SYS_PROP_CHECK_PEER_NAME = "solr.ssl.checkPeerName";
    public static final String SYS_PROP_HTTP_CLIENT_BUILDER_FACTORY = "solr.httpclient.builder.factory";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final DefaultHttpRequestRetryHandler NO_RETRY = new DefaultHttpRequestRetryHandler(0, false);
    private static final List<HttpClientConfigurer> configurers = Collections.synchronizedList(new ArrayList<HttpClientConfigurer>(Collections.singletonList(new HttpClientConfigurer())));
    private static final List<HttpRequestInterceptor> interceptors = Collections.synchronizedList(new ArrayList());

    @Deprecated
    public static void setConfigurer(HttpClientConfigurer newConfigurer) {
        HttpClientUtil.addConfigurer(newConfigurer);
    }

    public static void addConfigurer(HttpClientConfigurer newConfigurer) {
        configurers.add(newConfigurer);
    }

    public static void removeConfigurer(HttpClientConfigurer configurer) {
        configurers.remove(configurer);
    }

    public static void resetConfigurers() {
        configurers.clear();
        configurers.add(new HttpClientConfigurer());
    }

    public static CloseableHttpClient createClient(SolrParams params) {
        ModifiableSolrParams config = new ModifiableSolrParams(params);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new http client, config:" + config);
        }
        SystemDefaultHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpClientUtil.configureClient((DefaultHttpClient)httpClient, config);
        return httpClient;
    }

    static PoolingClientConnectionManager createPoolingConnectionManager() {
        return new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
    }

    public static CloseableHttpClient createClient(SolrParams params, ClientConnectionManager cm) {
        ModifiableSolrParams config = new ModifiableSolrParams(params);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new http client, config:" + config);
        }
        DefaultHttpClient httpClient = HttpClientFactory.createHttpClient(cm);
        HttpClientUtil.configureClient(httpClient, config);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureClient(DefaultHttpClient httpClient, SolrParams config) {
        List<HttpClientConfigurer> list = configurers;
        synchronized (list) {
            for (HttpClientConfigurer configurer : configurers) {
                configurer.configure(httpClient, config);
            }
        }
        list = interceptors;
        synchronized (list) {
            for (HttpRequestInterceptor interceptor : interceptors) {
                httpClient.addRequestInterceptor(interceptor);
            }
        }
    }

    public static void close(HttpClient httpClient) {
        if (httpClient instanceof CloseableHttpClient) {
            IOUtils.closeQuietly((Closeable)((CloseableHttpClient)httpClient));
        } else {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static void addRequestInterceptor(HttpRequestInterceptor interceptor) {
        interceptors.add(interceptor);
    }

    public static void removeRequestInterceptor(HttpRequestInterceptor interceptor) {
        interceptors.remove(interceptor);
    }

    public static void clearRequestInterceptors() {
        interceptors.clear();
    }

    public static void setAllowCompression(DefaultHttpClient httpClient, boolean allowCompression) {
        httpClient.removeRequestInterceptorByClass(UseCompressionRequestInterceptor.class);
        httpClient.removeResponseInterceptorByClass(UseCompressionResponseInterceptor.class);
        if (allowCompression) {
            httpClient.addRequestInterceptor((HttpRequestInterceptor)new UseCompressionRequestInterceptor());
            httpClient.addResponseInterceptor((HttpResponseInterceptor)new UseCompressionResponseInterceptor());
        }
    }

    public static void setBasicAuth(DefaultHttpClient httpClient, String basicAuthUser, String basicAuthPass) {
        if (basicAuthUser != null && basicAuthPass != null) {
            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthUser, basicAuthPass));
        } else {
            httpClient.getCredentialsProvider().clear();
            httpClient.removeRequestInterceptorByClass(PreemptiveAuth.class);
        }
    }

    public static void setMaxConnectionsPerHost(HttpClient httpClient, int max) {
        if (httpClient.getConnectionManager() instanceof ThreadSafeClientConnManager) {
            ThreadSafeClientConnManager mgr = (ThreadSafeClientConnManager)httpClient.getConnectionManager();
            mgr.setDefaultMaxPerRoute(max);
        } else if (httpClient.getConnectionManager() instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager mgr = (PoolingClientConnectionManager)httpClient.getConnectionManager();
            mgr.setDefaultMaxPerRoute(max);
        }
    }

    public static void setMaxConnections(HttpClient httpClient, int max) {
        if (httpClient.getConnectionManager() instanceof ThreadSafeClientConnManager) {
            ThreadSafeClientConnManager mgr = (ThreadSafeClientConnManager)httpClient.getConnectionManager();
            mgr.setMaxTotal(max);
        } else if (httpClient.getConnectionManager() instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager mgr = (PoolingClientConnectionManager)httpClient.getConnectionManager();
            mgr.setMaxTotal(max);
        }
    }

    public static void setSoTimeout(HttpClient httpClient, int timeout) {
        HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)timeout);
    }

    public static void setUseRetry(DefaultHttpClient httpClient, boolean useRetry) {
        if (!useRetry) {
            httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)NO_RETRY);
        } else {
            httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new SolrHttpRequestRetryHandler(3));
        }
    }

    public static void setConnectionTimeout(HttpClient httpClient, int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)timeout);
    }

    public static void setFollowRedirects(HttpClient httpClient, boolean followRedirects) {
        new ClientParamBean(httpClient.getParams()).setHandleRedirects(followRedirects);
    }

    public static void setHostNameVerifier(DefaultHttpClient httpClient, X509HostnameVerifier hostNameVerifier) {
        Scheme httpsScheme = httpClient.getConnectionManager().getSchemeRegistry().get("https");
        if (httpsScheme != null) {
            SSLSocketFactory sslSocketFactory = (SSLSocketFactory)httpsScheme.getSchemeSocketFactory();
            sslSocketFactory.setHostnameVerifier(hostNameVerifier);
        }
    }

    public static void setStaleCheckingEnabled(HttpClient httpClient, boolean enabled) {
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpClient.getParams(), (boolean)enabled);
    }

    public static void setTcpNoDelay(HttpClient httpClient, boolean tcpNoDelay) {
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpClient.getParams(), (boolean)tcpNoDelay);
    }

    public static HttpClientContext createNewHttpClientRequestContext() {
        HttpClientContext context = new HttpClientContext();
        context.setUserToken(HttpSolrClient.cacheKey);
        return context;
    }

    static {
        String factoryClassName = System.getProperty(SYS_PROP_HTTP_CLIENT_BUILDER_FACTORY);
        if (factoryClassName != null) {
            logger.debug("Using " + factoryClassName);
            try {
                HttpClientConfigurer factory = (HttpClientConfigurer)Class.forName(factoryClassName).newInstance();
                HttpClientUtil.addConfigurer(factory);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Unable to instantiate Solr HttpClientBuilderFactory", e);
            }
        }
    }

    public static class HttpClientFactory {
        private static Class<? extends DefaultHttpClient> defaultHttpClientClass = DefaultHttpClient.class;
        private static Class<? extends SystemDefaultHttpClient> systemDefaultHttpClientClass = SystemDefaultHttpClient.class;

        public static SystemDefaultHttpClient createHttpClient() {
            try {
                Constructor<? extends SystemDefaultHttpClient> constructor = systemDefaultHttpClientClass.getDeclaredConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create HttpClient instance. ", (Throwable)e);
            }
        }

        public static DefaultHttpClient createHttpClient(ClientConnectionManager cm) {
            try {
                Constructor<? extends DefaultHttpClient> constructor = defaultHttpClientClass.getDeclaredConstructor(ClientConnectionManager.class);
                return constructor.newInstance(cm);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create HttpClient instance, registered class is: " + defaultHttpClientClass, (Throwable)e);
            }
        }

        public static void setHttpClientImpl(Class<? extends DefaultHttpClient> defaultHttpClient, Class<? extends SystemDefaultHttpClient> systemDefaultHttpClient) {
            defaultHttpClientClass = defaultHttpClient;
            systemDefaultHttpClientClass = systemDefaultHttpClient;
        }
    }

    private static class DeflateDecompressingEntity
    extends GzipDecompressingEntity {
        public DeflateDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return new InflaterInputStream(this.wrappedEntity.getContent());
        }
    }

    private static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }

    private static class UseCompressionResponseInterceptor
    implements HttpResponseInterceptor {
        private UseCompressionResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpEntity entity = response.getEntity();
            Header ceheader = entity.getContentEncoding();
            if (ceheader != null) {
                HeaderElement[] codecs = ceheader.getElements();
                for (int i = 0; i < codecs.length; ++i) {
                    if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                    if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    private static class UseCompressionRequestInterceptor
    implements HttpRequestInterceptor {
        private UseCompressionRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (!request.containsHeader("Accept-Encoding")) {
                request.addHeader("Accept-Encoding", "gzip, deflate");
            }
        }
    }
}

