/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.converter.ReadwriteSplittingRuleStatementConverter;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.CreateReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.spi.ReplicaLoadBalanceAlgorithm;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class CreateReadwriteSplittingRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateReadwriteSplittingRuleStatement, ReadwriteSplittingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, CreateReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkDuplicateRuleNames(schemaName, sqlStatement, currentRuleConfig, shardingSphereMetaData.getResource());
        this.checkToBeCreatedResources(schemaName, sqlStatement, shardingSphereMetaData);
        this.checkToBeCreatedLoadBalancers(sqlStatement);
    }

    private void checkDuplicateRuleNames(String schemaName, CreateReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig, ShardingSphereResource resource) throws DistSQLException {
        ArrayList currentRuleNames = new ArrayList();
        if (null != resource && null != resource.getDataSources()) {
            currentRuleNames.addAll(resource.getDataSources().keySet());
        }
        Collection duplicateRuleNames = sqlStatement.getRules().stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
        if (!duplicateRuleNames.isEmpty()) {
            throw new InvalidRuleConfigurationException("readwrite splitting", duplicateRuleNames, Collections.singleton(String.format("%s already exists in resource", duplicateRuleNames)));
        }
        if (null != currentRuleConfig) {
            currentRuleNames.addAll(currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList()));
        }
        duplicateRuleNames = sqlStatement.getRules().stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
        if (!duplicateRuleNames.isEmpty()) {
            throw new DuplicateRuleException("readwrite splitting", schemaName, duplicateRuleNames);
        }
    }

    private void checkToBeCreatedResources(String schemaName, CreateReadwriteSplittingRuleStatement sqlStatement, ShardingSphereMetaData shardingSphereMetaData) throws DistSQLException {
        LinkedHashSet requireResources = new LinkedHashSet();
        LinkedHashSet requireDiscoverableResources = new LinkedHashSet();
        sqlStatement.getRules().forEach(each -> {
            if (Strings.isNullOrEmpty((String)each.getAutoAwareResource())) {
                requireResources.add(each.getWriteDataSource());
                requireResources.addAll(each.getReadDataSources());
            } else {
                requireDiscoverableResources.add(each.getAutoAwareResource());
            }
        });
        Collection notExistResources = shardingSphereMetaData.getResource().getNotExistedResources(requireResources);
        DistSQLException.predictionThrow((boolean)notExistResources.isEmpty(), () -> new RequiredResourceMissedException(schemaName, notExistResources));
        Collection<String> logicResources = this.getLogicResources(shardingSphereMetaData);
        Set notExistLogicResources = requireDiscoverableResources.stream().filter(each -> !logicResources.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistLogicResources.isEmpty(), () -> new RequiredResourceMissedException(schemaName, (Collection)notExistLogicResources));
    }

    private Collection<String> getLogicResources(ShardingSphereMetaData shardingSphereMetaData) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Optional<ExportableRule> exportableRule = shardingSphereMetaData.getRuleMetaData().findRules(ExportableRule.class).stream().filter(each -> each.containExportableKey(Collections.singletonList("primary_data_source"))).findAny();
        exportableRule.ifPresent(optional -> {
            Map exportData = optional.export(Collections.singletonList("primary_data_source"));
            Set logicResources = exportData.getOrDefault("primary_data_source", Collections.emptyMap()).keySet();
            result.addAll(logicResources);
        });
        return result;
    }

    private void checkToBeCreatedLoadBalancers(CreateReadwriteSplittingRuleStatement sqlStatement) throws InvalidAlgorithmConfigurationException {
        Collection notExistedLoadBalancers = sqlStatement.getRules().stream().map(ReadwriteSplittingRuleSegment::getLoadBalancer).filter(Objects::nonNull).distinct().filter(each -> !TypedSPIRegistry.findRegisteredService(ReplicaLoadBalanceAlgorithm.class, (String)each, (Properties)new Properties()).isPresent()).collect(Collectors.toList());
        if (!notExistedLoadBalancers.isEmpty()) {
            throw new InvalidAlgorithmConfigurationException("Load balancers", notExistedLoadBalancers);
        }
    }

    public ReadwriteSplittingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateReadwriteSplittingRuleStatement sqlStatement) {
        return ReadwriteSplittingRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDataSources().addAll(toBeCreatedRuleConfig.getDataSources());
            currentRuleConfig.getLoadBalancers().putAll(toBeCreatedRuleConfig.getLoadBalancers());
        }
    }

    public Class<ReadwriteSplittingRuleConfiguration> getRuleConfigurationClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }

    public String getType() {
        return CreateReadwriteSplittingRuleStatement.class.getName();
    }

    static {
        ShardingSphereServiceLoader.register(ReplicaLoadBalanceAlgorithm.class);
    }
}

