/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.impl;

import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.sql.SQLBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.ComposableSQLToken;

public abstract class AbstractSQLBuilder
implements SQLBuilder {
    private final SQLRewriteContext context;

    @Override
    public final String toSQL() {
        if (this.context.getSqlTokens().isEmpty()) {
            return this.context.getSql();
        }
        Collections.sort(this.context.getSqlTokens());
        StringBuilder result = new StringBuilder();
        result.append(this.context.getSql(), 0, this.context.getSqlTokens().get(0).getStartIndex());
        for (SQLToken each : this.context.getSqlTokens()) {
            result.append(each instanceof ComposableSQLToken ? this.getComposableSQLTokenText((ComposableSQLToken)each) : this.getSQLTokenText(each));
            result.append(this.getConjunctionText(each));
        }
        return result.toString();
    }

    protected abstract String getSQLTokenText(SQLToken var1);

    private String getComposableSQLTokenText(ComposableSQLToken composableSQLToken) {
        StringBuilder result = new StringBuilder();
        for (SQLToken each : composableSQLToken.getSqlTokens()) {
            result.append(this.getSQLTokenText(each));
            result.append(this.getConjunctionText(each));
        }
        return result.toString();
    }

    private String getConjunctionText(SQLToken sqlToken) {
        return this.context.getSql().substring(this.getStartIndex(sqlToken), this.getStopIndex(sqlToken));
    }

    private int getStartIndex(SQLToken sqlToken) {
        int startIndex = sqlToken instanceof Substitutable ? ((Substitutable)((Object)sqlToken)).getStopIndex() + 1 : sqlToken.getStartIndex();
        return Math.min(startIndex, this.context.getSql().length());
    }

    private int getStopIndex(SQLToken sqlToken) {
        int currentSQLTokenIndex = this.context.getSqlTokens().indexOf(sqlToken);
        return this.context.getSqlTokens().size() - 1 == currentSQLTokenIndex ? this.context.getSql().length() : this.context.getSqlTokens().get(currentSQLTokenIndex + 1).getStartIndex();
    }

    @Generated
    public AbstractSQLBuilder(SQLRewriteContext context) {
        this.context = context;
    }
}

