/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite;

import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecoratorFactory;
import org.apache.shardingsphere.infra.rewrite.engine.GenericSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.RouteSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sqltranslator.api.config.SQLTranslatorRuleConfiguration;
import org.apache.shardingsphere.sqltranslator.rule.SQLTranslatorRule;

public final class SQLRewriteEntry {
    private final ShardingSphereDatabase database;
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators;

    public SQLRewriteEntry(ShardingSphereDatabase database, ConfigurationProperties props) {
        this.database = database;
        this.props = props;
        this.decorators = SQLRewriteContextDecoratorFactory.getInstance(database.getRuleMetaData().getRules());
    }

    public SQLRewriteResult rewrite(String sql, List<Object> parameters, SQLStatementContext<?> sqlStatementContext, RouteContext routeContext) {
        SQLRewriteContext sqlRewriteContext = this.createSQLRewriteContext(sql, parameters, sqlStatementContext, routeContext);
        SQLTranslatorRule rule = this.database.getRuleMetaData().findSingleRule(SQLTranslatorRule.class).orElseGet(() -> new SQLTranslatorRule(new SQLTranslatorRuleConfiguration()));
        DatabaseType protocolType = this.database.getProtocolType();
        DatabaseType storageType = this.database.getResource().getDatabaseType();
        return routeContext.getRouteUnits().isEmpty() ? new GenericSQLRewriteEngine(rule, protocolType, storageType).rewrite(sqlRewriteContext) : new RouteSQLRewriteEngine(rule, protocolType, storageType).rewrite(sqlRewriteContext, routeContext);
    }

    private SQLRewriteContext createSQLRewriteContext(String sql, List<Object> parameters, SQLStatementContext<?> sqlStatementContext, RouteContext routeContext) {
        SQLRewriteContext result = new SQLRewriteContext(this.database.getName(), this.database.getSchemas(), sqlStatementContext, sql, parameters);
        this.decorate(this.decorators, result, routeContext);
        result.generateSQLTokens();
        return result;
    }

    private void decorate(Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        for (Map.Entry<ShardingSphereRule, SQLRewriteContextDecorator> entry : decorators.entrySet()) {
            entry.getValue().decorate(entry.getKey(), this.props, sqlRewriteContext, routeContext);
        }
    }
}

