/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.segment.expression.impl;

import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.optimize.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;

public final class BetweenExpressionConverter
implements SQLSegmentConverter<BetweenExpression, SqlBasicCall> {
    private final boolean not;

    public BetweenExpressionConverter() {
        this.not = false;
    }

    @Override
    public Optional<SqlBasicCall> convertToSQLNode(BetweenExpression expression) {
        if (null == expression) {
            return Optional.empty();
        }
        LinkedList sqlNodes = new LinkedList();
        ExpressionConverter expressionConverter = new ExpressionConverter();
        expressionConverter.convertToSQLNode(expression.getLeft()).ifPresent(sqlNodes::add);
        expressionConverter.convertToSQLNode(expression.getBetweenExpr()).ifPresent(sqlNodes::add);
        expressionConverter.convertToSQLNode(expression.getAndExpr()).ifPresent(sqlNodes::add);
        SqlBasicCall sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.BETWEEN, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        return expression.isNot() ? Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.NOT, new SqlNode[]{sqlNode}, SqlParserPos.ZERO)) : Optional.of(sqlNode);
    }

    @Override
    public Optional<BetweenExpression> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        if (null == sqlBasicCall) {
            return Optional.empty();
        }
        ExpressionConverter expressionConverter = new ExpressionConverter();
        ExpressionSegment between = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(1)).orElseThrow(IllegalStateException::new);
        ExpressionSegment and = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(2)).orElseThrow(IllegalStateException::new);
        ExpressionSegment left = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(0)).orElseThrow(IllegalStateException::new);
        return Optional.of(new BetweenExpression(left.getStartIndex(), and.getStopIndex(), left, between, and, this.not));
    }

    @Generated
    public BetweenExpressionConverter(boolean not) {
        this.not = not;
    }
}

