/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.database.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapCreator;

public final class DataSourceGeneratedDatabaseConfiguration
implements DatabaseConfiguration {
    private final Collection<RuleConfiguration> ruleConfigurations;
    private final Map<String, StorageUnit> storageUnits;
    private final Map<StorageNode, DataSource> dataSources;

    public DataSourceGeneratedDatabaseConfiguration(Map<String, DataSourceConfiguration> dataSourceConfigs, Collection<RuleConfiguration> ruleConfigs) {
        this.ruleConfigurations = ruleConfigs;
        Map dataSourcePoolPropertiesMap = dataSourceConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.create((DataSourceConfiguration)((DataSourceConfiguration)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        Map<String, StorageNode> storageUnitNodeMap = StorageUnitNodeMapCreator.create(dataSourcePoolPropertiesMap);
        Map<StorageNode, DataSource> storageNodeDataSources = this.getStorageNodeDataSourceMap(dataSourcePoolPropertiesMap, storageUnitNodeMap);
        this.storageUnits = new LinkedHashMap<String, StorageUnit>(dataSourceConfigs.size(), 1.0f);
        for (Map.Entry<String, DataSourceConfiguration> entry2 : dataSourceConfigs.entrySet()) {
            String storageUnitName = entry2.getKey();
            StorageNode storageNode = storageUnitNodeMap.get(storageUnitName);
            DataSource dataSource = storageNodeDataSources.get(storageNode);
            StorageUnit storageUnit = new StorageUnit(storageNode, (DataSourcePoolProperties)dataSourcePoolPropertiesMap.get(storageUnitName), dataSource);
            this.storageUnits.put(storageUnitName, storageUnit);
        }
        this.dataSources = storageNodeDataSources;
    }

    private Map<StorageNode, DataSource> getStorageNodeDataSourceMap(Map<String, DataSourcePoolProperties> dataSourcePoolPropertiesMap, Map<String, StorageNode> storageUnitNodeMap) {
        LinkedHashMap<StorageNode, DataSource> result = new LinkedHashMap<StorageNode, DataSource>(storageUnitNodeMap.size(), 1.0f);
        for (Map.Entry<String, StorageNode> entry : storageUnitNodeMap.entrySet()) {
            result.computeIfAbsent(entry.getValue(), key -> DataSourcePoolCreator.create((String)((String)entry.getKey()), (DataSourcePoolProperties)((DataSourcePoolProperties)dataSourcePoolPropertiesMap.get(entry.getKey())), (boolean)true, result.values()));
        }
        return result;
    }

    @Override
    @Generated
    public Collection<RuleConfiguration> getRuleConfigurations() {
        return this.ruleConfigurations;
    }

    @Override
    @Generated
    public Map<String, StorageUnit> getStorageUnits() {
        return this.storageUnits;
    }

    @Override
    @Generated
    public Map<StorageNode, DataSource> getDataSources() {
        return this.dataSources;
    }
}

