/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader.metadata.dialect;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.common.SchemaMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.datatype.DataTypeLoader;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.metadata.DialectSchemaMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;

public final class OpenGaussSchemaMetaDataLoader
implements DialectSchemaMetaDataLoader {
    private static final String BASIC_TABLE_META_DATA_SQL = "SELECT table_name, column_name, ordinal_position, data_type, udt_name, column_default, table_schema FROM information_schema.columns WHERE table_schema IN (%s)";
    private static final String TABLE_META_DATA_SQL_WITHOUT_TABLES = "SELECT table_name, column_name, ordinal_position, data_type, udt_name, column_default, table_schema FROM information_schema.columns WHERE table_schema IN (%s) ORDER BY ordinal_position";
    private static final String TABLE_META_DATA_SQL_WITH_TABLES = "SELECT table_name, column_name, ordinal_position, data_type, udt_name, column_default, table_schema FROM information_schema.columns WHERE table_schema IN (%s) AND table_name IN (%s) ORDER BY ordinal_position";
    private static final String PRIMARY_KEY_META_DATA_SQL = "SELECT tc.table_name, kc.column_name, kc.table_schema FROM information_schema.table_constraints tc JOIN information_schema.key_column_usage kc ON kc.table_schema = tc.table_schema AND kc.table_name = tc.table_name AND kc.constraint_name = tc.constraint_name WHERE tc.constraint_type = 'PRIMARY KEY' AND kc.ordinal_position IS NOT NULL AND kc.table_schema IN (%s)";
    private static final String BASIC_INDEX_META_DATA_SQL = "SELECT tablename, indexname, schemaname FROM pg_indexes WHERE schemaname IN (%s)";

    @Override
    public Collection<SchemaMetaData> load(DataSource dataSource, Collection<String> tables, String defaultSchemaName) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            Collection<String> schemaNames = SchemaMetaDataLoader.loadSchemaNames(connection, (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)"openGauss"));
            Map<String, Multimap<String, IndexMetaData>> schemaIndexMetaDataMap = this.loadIndexMetaDataMap(connection, schemaNames);
            Map<String, Multimap<String, ColumnMetaData>> schemaColumnMetaDataMap = this.loadColumnMetaDataMap(connection, tables, schemaNames);
            LinkedList<SchemaMetaData> result = new LinkedList<SchemaMetaData>();
            for (String each : schemaNames) {
                Multimap<String, IndexMetaData> tableIndexMetaDataMap = schemaIndexMetaDataMap.getOrDefault(each, (Multimap<String, IndexMetaData>)LinkedHashMultimap.create());
                Multimap<String, ColumnMetaData> tableColumnMetaDataMap = schemaColumnMetaDataMap.getOrDefault(each, (Multimap<String, ColumnMetaData>)LinkedHashMultimap.create());
                result.add(new SchemaMetaData(each, this.createTableMetaDataList(tableIndexMetaDataMap, tableColumnMetaDataMap)));
            }
            LinkedList<SchemaMetaData> linkedList = result;
            return linkedList;
        }
    }

    private Map<String, Multimap<String, IndexMetaData>> loadIndexMetaDataMap(Connection connection, Collection<String> schemaNames) throws SQLException {
        LinkedHashMap<String, Multimap<String, IndexMetaData>> result = new LinkedHashMap<String, Multimap<String, IndexMetaData>>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(schemaNames));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String schemaName = resultSet.getString("schemaname");
                String tableName = resultSet.getString("tablename");
                String indexName = resultSet.getString("indexname");
                Multimap indexMetaDataMap = result.computeIfAbsent(schemaName, key -> LinkedHashMultimap.create());
                indexMetaDataMap.put((Object)tableName, (Object)new IndexMetaData(indexName));
            }
        }
        return result;
    }

    private String getIndexMetaDataSQL(Collection<String> schemaNames) {
        return String.format(BASIC_INDEX_META_DATA_SQL, schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Multimap<String, ColumnMetaData>> loadColumnMetaDataMap(Connection connection, Collection<String> tables, Collection<String> schemaNames) throws SQLException {
        LinkedHashMap<String, Multimap<String, ColumnMetaData>> result = new LinkedHashMap<String, Multimap<String, ColumnMetaData>>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getColumnMetaDataSQL(schemaNames, tables));
             ResultSet resultSet = preparedStatement.executeQuery();){
            Map<String, Integer> dataTypes = new DataTypeLoader().load(connection.getMetaData(), (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)this.getType()));
            Collection<String> primaryKeys = this.loadPrimaryKeys(connection, schemaNames);
            while (resultSet.next()) {
                String tableName = resultSet.getString("table_name");
                String schemaName = resultSet.getString("table_schema");
                Multimap columnMetaDataMap = result.computeIfAbsent(schemaName, key -> LinkedHashMultimap.create());
                columnMetaDataMap.put((Object)tableName, (Object)this.loadColumnMetaData(dataTypes, primaryKeys, resultSet));
            }
        }
        return result;
    }

    private String getColumnMetaDataSQL(Collection<String> schemaNames, Collection<String> tables) {
        String schemaNameParam = schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(","));
        return tables.isEmpty() ? String.format(TABLE_META_DATA_SQL_WITHOUT_TABLES, schemaNameParam) : String.format(TABLE_META_DATA_SQL_WITH_TABLES, schemaNameParam, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Collection<String> loadPrimaryKeys(Connection connection, Collection<String> schemaNames) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getPrimaryKeyMetaDataSQL(schemaNames));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String schemaName = resultSet.getString("table_schema");
                String tableName = resultSet.getString("table_name");
                String columnName = resultSet.getString("column_name");
                result.add(schemaName + "," + tableName + "," + columnName);
            }
        }
        return result;
    }

    private String getPrimaryKeyMetaDataSQL(Collection<String> schemaNames) {
        return String.format(PRIMARY_KEY_META_DATA_SQL, schemaNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private ColumnMetaData loadColumnMetaData(Map<String, Integer> dataTypeMap, Collection<String> primaryKeys, ResultSet resultSet) throws SQLException {
        String schemaName = resultSet.getString("table_schema");
        String tableName = resultSet.getString("table_name");
        String columnName = resultSet.getString("column_name");
        String dataType = resultSet.getString("udt_name");
        boolean isPrimaryKey = primaryKeys.contains(schemaName + "," + tableName + "," + columnName);
        String columnDefault = resultSet.getString("column_default");
        boolean generated = null != columnDefault && columnDefault.startsWith("nextval(");
        boolean caseSensitive = true;
        return new ColumnMetaData(columnName, dataTypeMap.get(dataType), isPrimaryKey, generated, caseSensitive, true, false);
    }

    private Collection<TableMetaData> createTableMetaDataList(Multimap<String, IndexMetaData> tableIndexMetaDataMap, Multimap<String, ColumnMetaData> tableColumnMetaDataMap) {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        for (String each : tableColumnMetaDataMap.keySet()) {
            Collection columnMetaDataList = tableColumnMetaDataMap.get((Object)each);
            Collection indexMetaDataList = tableIndexMetaDataMap.get((Object)each);
            result.add(new TableMetaData(each, columnMetaDataList, indexMetaDataList, Collections.emptyList()));
        }
        return result;
    }

    public String getType() {
        return "openGauss";
    }
}

