/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.IndexMetaData;

public final class IndexMetaDataLoader {
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final int ORACLE_VIEW_NOT_APPROPRIATE_VENDOR_CODE = 1702;

    public static Collection<IndexMetaData> load(Connection connection, String table) throws SQLException {
        HashSet<IndexMetaData> result;
        block9: {
            result = new HashSet<IndexMetaData>();
            try (ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), connection.getSchema(), table, false, false);){
                while (resultSet.next()) {
                    String indexName = resultSet.getString(INDEX_NAME);
                    if (null == indexName) continue;
                    result.add(new IndexMetaData(indexName));
                }
            }
            catch (SQLException ex) {
                if (1702 == ex.getErrorCode()) break block9;
                throw ex;
            }
        }
        return result;
    }

    @Generated
    private IndexMetaDataLoader() {
    }
}

