/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.SchemaMetaDataLoaderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.common.TableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.spi.DialectSchemaMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.spi.DialectSchemaMetaDataLoaderFactory;
import org.apache.shardingsphere.infra.util.exception.sql.UnknownSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaMetaDataLoaderEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaMetaDataLoaderEngine.class);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShardingSphere-SchemaMetaDataLoaderEngine-%d").build());

    public static Map<String, SchemaMetaData> load(Collection<SchemaMetaDataLoaderMaterials> materials, DatabaseType databaseType) throws SQLException {
        Optional<DialectSchemaMetaDataLoader> dialectTableMetaDataLoader = DialectSchemaMetaDataLoaderFactory.findInstance(databaseType);
        if (dialectTableMetaDataLoader.isPresent()) {
            try {
                return SchemaMetaDataLoaderEngine.loadByDialect(dialectTableMetaDataLoader.get(), materials);
            }
            catch (SQLException ex) {
                log.error("Dialect load table meta data error.", (Throwable)ex);
                return SchemaMetaDataLoaderEngine.loadByDefault(materials, databaseType);
            }
        }
        return SchemaMetaDataLoaderEngine.loadByDefault(materials, databaseType);
    }

    private static Map<String, SchemaMetaData> loadByDefault(Collection<SchemaMetaDataLoaderMaterials> materials, DatabaseType databaseType) throws SQLException {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        String defaultSchemaName = null;
        for (SchemaMetaDataLoaderMaterials each : materials) {
            defaultSchemaName = each.getDefaultSchemaName();
            for (String tableName : each.getActualTableNames()) {
                TableMetaDataLoader.load(each.getDataSource(), tableName, databaseType).ifPresent(result::add);
            }
        }
        return Collections.singletonMap(defaultSchemaName, new SchemaMetaData(defaultSchemaName, result));
    }

    private static Map<String, SchemaMetaData> loadByDialect(DialectSchemaMetaDataLoader loader, Collection<SchemaMetaDataLoaderMaterials> materials) throws SQLException {
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>();
        LinkedList<Future<Collection>> futures = new LinkedList<Future<Collection>>();
        for (SchemaMetaDataLoaderMaterials schemaMetaDataLoaderMaterials : materials) {
            futures.add(EXECUTOR_SERVICE.submit(() -> loader.load(schemaMetaDataLoaderMaterials.getDataSource(), schemaMetaDataLoaderMaterials.getActualTableNames(), schemaMetaDataLoaderMaterials.getDefaultSchemaName())));
        }
        try {
            for (Future future : futures) {
                SchemaMetaDataLoaderEngine.mergeSchemaMetaDataMap(result, (Collection)future.get());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw (SQLException)ex.getCause();
            }
            throw new UnknownSQLException(ex).toSQLException();
        }
        return result;
    }

    private static void mergeSchemaMetaDataMap(Map<String, SchemaMetaData> schemaMetaDataMap, Collection<SchemaMetaData> addedSchemaMetaDataList) {
        for (SchemaMetaData each : addedSchemaMetaDataList) {
            SchemaMetaData schemaMetaData = schemaMetaDataMap.computeIfAbsent(each.getName(), key -> new SchemaMetaData(each.getName(), new LinkedList<TableMetaData>()));
            schemaMetaData.getTables().addAll(each.getTables());
        }
    }

    @Generated
    private SchemaMetaDataLoaderEngine() {
    }
}

