/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.context.cursor.CursorConnectionContext;
import org.apache.shardingsphere.infra.context.transaction.TransactionConnectionContext;

public final class ConnectionContext
implements AutoCloseable {
    private final CursorConnectionContext cursorConnectionContext = new CursorConnectionContext();
    private final TransactionConnectionContext transactionConnectionContext = new TransactionConnectionContext();
    private String trafficInstanceId;

    public Optional<String> getTrafficInstanceId() {
        return Optional.ofNullable(this.trafficInstanceId);
    }

    @Override
    public void close() {
        this.clearTrafficInstance();
        this.clearCursorConnectionContext();
        this.clearTransactionConnectionContext();
    }

    public void clearTrafficInstance() {
        this.trafficInstanceId = null;
    }

    public void clearCursorConnectionContext() {
        this.cursorConnectionContext.close();
    }

    public void clearTransactionConnectionContext() {
        this.transactionConnectionContext.close();
    }

    @Generated
    public CursorConnectionContext getCursorConnectionContext() {
        return this.cursorConnectionContext;
    }

    @Generated
    public TransactionConnectionContext getTransactionConnectionContext() {
        return this.transactionConnectionContext;
    }

    @Generated
    public void setTrafficInstanceId(String trafficInstanceId) {
        this.trafficInstanceId = trafficInstanceId;
    }
}

