/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.schema.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereConstraint;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlColumnMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlConstraintMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlIndexMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;

public final class TableMetaDataYamlSwapper
implements YamlConfigurationSwapper<YamlTableMetaData, ShardingSphereTable> {
    @Override
    public YamlTableMetaData swapToYamlConfiguration(ShardingSphereTable table) {
        YamlTableMetaData result = new YamlTableMetaData();
        result.setColumns(this.swapYamlColumns(table.getColumns()));
        result.setIndexes(this.swapYamlIndexes(table.getIndexes()));
        result.setConstraints(this.swapYamlConstraints(table.getConstrains()));
        result.setName(table.getName());
        return result;
    }

    @Override
    public ShardingSphereTable swapToObject(YamlTableMetaData yamlConfig) {
        return new ShardingSphereTable(yamlConfig.getName(), this.swapColumns(yamlConfig.getColumns()), this.swapIndexes(yamlConfig.getIndexes()), this.swapConstraints(yamlConfig.getConstraints()));
    }

    private Collection<ShardingSphereConstraint> swapConstraints(Map<String, YamlConstraintMetaData> constraints) {
        return null == constraints ? Collections.emptyList() : (Collection)constraints.values().stream().map(this::swapConstraint).collect(Collectors.toList());
    }

    private ShardingSphereConstraint swapConstraint(YamlConstraintMetaData constraint) {
        return new ShardingSphereConstraint(constraint.getName(), constraint.getReferencedTableName());
    }

    private Collection<ShardingSphereIndex> swapIndexes(Map<String, YamlIndexMetaData> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this::swapIndex).collect(Collectors.toList());
    }

    private ShardingSphereIndex swapIndex(YamlIndexMetaData index) {
        return new ShardingSphereIndex(index.getName());
    }

    private Collection<ShardingSphereColumn> swapColumns(Map<String, YamlColumnMetaData> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this::swapColumn).collect(Collectors.toList());
    }

    private ShardingSphereColumn swapColumn(YamlColumnMetaData column) {
        return new ShardingSphereColumn(column.getName(), column.getDataType(), column.isPrimaryKey(), column.isGenerated(), column.isCaseSensitive());
    }

    private Map<String, YamlConstraintMetaData> swapYamlConstraints(Map<String, ShardingSphereConstraint> constrains) {
        return constrains.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapYamlConstraint((ShardingSphereConstraint)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlConstraintMetaData swapYamlConstraint(ShardingSphereConstraint constraint) {
        YamlConstraintMetaData result = new YamlConstraintMetaData();
        result.setName(constraint.getName());
        result.setReferencedTableName(constraint.getReferencedTableName());
        return result;
    }

    private Map<String, YamlIndexMetaData> swapYamlIndexes(Map<String, ShardingSphereIndex> indexes) {
        return indexes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapYamlIndex((ShardingSphereIndex)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlIndexMetaData swapYamlIndex(ShardingSphereIndex index) {
        YamlIndexMetaData result = new YamlIndexMetaData();
        result.setName(index.getName());
        return result;
    }

    private Map<String, YamlColumnMetaData> swapYamlColumns(Map<String, ShardingSphereColumn> columns) {
        return columns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapYamlColumn((ShardingSphereColumn)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlColumnMetaData swapYamlColumn(ShardingSphereColumn column) {
        YamlColumnMetaData result = new YamlColumnMetaData();
        result.setName(column.getName());
        result.setCaseSensitive(column.isCaseSensitive());
        result.setGenerated(column.isGenerated());
        result.setPrimaryKey(column.isPrimaryKey());
        result.setDataType(column.getDataType());
        return result;
    }
}

