/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.properties;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.properties.TypedPropertyKey;
import org.apache.shardingsphere.infra.properties.TypedPropertyValue;
import org.apache.shardingsphere.infra.properties.TypedPropertyValueException;

public abstract class TypedProperties<E extends Enum<?>> {
    private final Properties props;
    private final Map<E, TypedPropertyValue> cache;

    protected TypedProperties(Class<E> keyClass, Properties props) {
        this.props = null == props ? new Properties() : props;
        this.cache = this.preload(keyClass);
    }

    private Map<E, TypedPropertyValue> preload(Class<E> keyClass) {
        Enum[] enumConstants = (Enum[])keyClass.getEnumConstants();
        HashMap<Enum, TypedPropertyValue> result = new HashMap<Enum, TypedPropertyValue>(enumConstants.length, 1.0f);
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (Enum each : enumConstants) {
            TypedPropertyValue value = null;
            try {
                value = new TypedPropertyValue((TypedPropertyKey)((Object)each), this.props.getOrDefault((Object)((TypedPropertyKey)((Object)each)).getKey(), ((TypedPropertyKey)((Object)each)).getDefaultValue()).toString());
            }
            catch (TypedPropertyValueException ex) {
                errorMessages.add(ex.getMessage());
            }
            result.put(each, value);
        }
        if (!errorMessages.isEmpty()) {
            throw new ShardingSphereConfigurationException(String.join((CharSequence)System.lineSeparator(), errorMessages), new Object[0]);
        }
        return result;
    }

    public final <T> T getValue(E key) {
        return (T)this.cache.get(key).getValue();
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

