/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.loader.spi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.spi.annotation.SingletonSPI;
import org.apache.shardingsphere.spi.type.typed.TypedSPI;

@SingletonSPI
public interface DialectSchemaMetaDataLoader
extends TypedSPI {
    public Collection<SchemaMetaData> load(DataSource var1, Collection<String> var2, String var3) throws SQLException;

    default public Collection<String> loadSchemaNames(DataSource dataSource, DatabaseType databaseType) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (Connection connection = dataSource.getConnection();
             ResultSet resultSet = connection.getMetaData().getSchemas();){
            while (resultSet.next()) {
                String schema = resultSet.getString("TABLE_SCHEM");
                if (databaseType.getSystemSchemas().contains(schema)) continue;
                result.add(schema);
            }
        }
        return result;
    }
}

