/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.decorator.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class ShardingSphereSchema {
    private final Map<String, ShardingSphereTable> tables;

    public ShardingSphereSchema() {
        this.tables = new ConcurrentHashMap<String, ShardingSphereTable>();
    }

    public ShardingSphereSchema(Map<String, ShardingSphereTable> tables) {
        this.tables = new ConcurrentHashMap<String, ShardingSphereTable>(tables.size(), 1.0f);
        tables.forEach((key, value) -> this.tables.put(key.toLowerCase(), (ShardingSphereTable)value));
    }

    public Collection<String> getAllTableNames() {
        return this.tables.keySet();
    }

    public ShardingSphereTable get(String tableName) {
        return this.tables.get(tableName.toLowerCase());
    }

    public void put(String tableName, ShardingSphereTable table) {
        this.tables.put(tableName.toLowerCase(), table);
    }

    public void putAll(Map<String, ShardingSphereTable> tables) {
        for (Map.Entry<String, ShardingSphereTable> entry : tables.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void remove(String tableName) {
        this.tables.remove(tableName.toLowerCase());
    }

    public boolean containsTable(String tableName) {
        return this.tables.containsKey(tableName.toLowerCase());
    }

    public boolean containsColumn(String tableName, String columnName) {
        return this.containsTable(tableName) && this.get(tableName).getColumns().containsKey(columnName.toLowerCase());
    }

    public List<String> getAllColumnNames(String tableName) {
        return this.containsTable(tableName) ? this.get(tableName).getColumnNames() : Collections.emptyList();
    }

    @Generated
    public Map<String, ShardingSphereTable> getTables() {
        return this.tables;
    }
}

