/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;

public final class ShardingSphereResource {
    private final Map<String, DataSource> dataSources;
    private final DatabaseType databaseType;
    private final Map<String, DataSourceMetaData> dataSourceMetaDataMap;

    public ShardingSphereResource(Map<String, DataSource> dataSources) {
        this.dataSources = dataSources;
        this.databaseType = this.getDatabaseType(dataSources);
        this.dataSourceMetaDataMap = this.createDataSourceMetaDataMap(dataSources);
    }

    private DatabaseType getDatabaseType(Map<String, DataSource> dataSources) {
        return dataSources.isEmpty() ? null : DatabaseTypeEngine.getDatabaseType(dataSources.values());
    }

    private Map<String, DataSourceMetaData> createDataSourceMetaDataMap(Map<String, DataSource> dataSources) {
        LinkedHashMap<String, DataSourceMetaData> result = new LinkedHashMap<String, DataSourceMetaData>(dataSources.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            Map<String, Object> standardProps = DataSourcePropertiesCreator.create(entry.getValue()).getConnectionPropertySynonyms().getStandardProperties();
            result.put(entry.getKey(), this.databaseType.getDataSourceMetaData(standardProps.get("url").toString(), standardProps.get("username").toString()));
        }
        return result;
    }

    public Collection<DataSource> getAllInstanceDataSources() {
        return this.dataSources.entrySet().stream().filter(entry -> this.getAllInstanceDataSourceNames().contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public Collection<String> getAllInstanceDataSourceNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, DataSourceMetaData> entry : this.dataSourceMetaDataMap.entrySet()) {
            if (this.isExisted(entry.getKey(), result)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean isExisted(String dataSourceName, Collection<String> existedDataSourceNames) {
        return existedDataSourceNames.stream().anyMatch(each -> this.dataSourceMetaDataMap.get(dataSourceName).isInSameDatabaseInstance(this.dataSourceMetaDataMap.get(each)));
    }

    public DataSourceMetaData getDataSourceMetaData(String dataSourceName) {
        return this.dataSourceMetaDataMap.get(dataSourceName);
    }

    public Collection<String> getNotExistedResources(Collection<String> resourceNames) {
        return resourceNames.stream().filter(each -> !this.dataSources.containsKey(each)).collect(Collectors.toSet());
    }

    public void close(DataSource dataSource) {
        new DataSourcePoolDestroyer(dataSource).asyncDestroy();
    }

    @Generated
    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

