/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.BranchDatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.database.type.SchemaSupportedDatabaseType;

public final class DatabaseTypeEngine {
    private static final String DEFAULT_DATABASE_TYPE = "MySQL";

    public static DatabaseType getProtocolType(Map<String, ? extends DatabaseConfiguration> databaseConfigs, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeEngine.findConfiguredDatabaseType(props);
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Collection dataSources = databaseConfigs.values().stream().filter(DatabaseTypeEngine::hasDataSource).findFirst().map(optional -> optional.getDataSources().values()).orElseGet(Collections::emptyList);
        return DatabaseTypeEngine.getDatabaseType(dataSources);
    }

    public static DatabaseType getStorageType(Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        return DatabaseTypeEngine.getDatabaseType(databaseConfigs.values().stream().filter(DatabaseTypeEngine::hasDataSource).findFirst().map(optional -> optional.getDataSources().values()).orElseGet(Collections::emptyList));
    }

    public static DatabaseType getDatabaseType(String url) {
        return DatabaseTypeFactory.getInstances().stream().filter(each -> DatabaseTypeEngine.matchURLs(url, each)).findAny().orElseGet(() -> DatabaseTypeFactory.getInstance("SQL92"));
    }

    public static DatabaseType getDatabaseType(Collection<DataSource> dataSources) {
        DatabaseType result = null;
        for (DataSource each : dataSources) {
            DatabaseType databaseType = DatabaseTypeEngine.getDatabaseType(each);
            Preconditions.checkState((null == result || result == databaseType ? 1 : 0) != 0, (String)"Database type inconsistent with '%s' and '%s'", (Object)result, (Object)databaseType);
            result = databaseType;
        }
        return null == result ? DatabaseTypeFactory.getInstance(DEFAULT_DATABASE_TYPE) : result;
    }

    private static DatabaseType getDatabaseType(DataSource dataSource) {
        DatabaseType databaseType;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                databaseType = DatabaseTypeEngine.getDatabaseType(connection.getMetaData().getURL());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new IllegalArgumentException(ex.getMessage(), ex);
                }
            }
            connection.close();
        }
        return databaseType;
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType(ConfigurationProperties props) {
        String configuredDatabaseType = (String)props.getValue(ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return configuredDatabaseType.isEmpty() ? Optional.empty() : Optional.of(DatabaseTypeEngine.getTrunkDatabaseType(configuredDatabaseType));
    }

    private static boolean hasDataSource(DatabaseConfiguration databaseConfig) {
        return !databaseConfig.getDataSources().isEmpty();
    }

    private static boolean matchURLs(String url, DatabaseType databaseType) {
        return databaseType.getJdbcUrlPrefixes().stream().anyMatch(url::startsWith);
    }

    public static DatabaseType getTrunkDatabaseType(String name) {
        DatabaseType databaseType = DatabaseTypeFactory.getInstance(name);
        return databaseType instanceof BranchDatabaseType ? ((BranchDatabaseType)databaseType).getTrunkDatabaseType() : databaseType;
    }

    public static String getTrunkDatabaseTypeName(DatabaseType databaseType) {
        return databaseType instanceof BranchDatabaseType ? ((BranchDatabaseType)databaseType).getTrunkDatabaseType().getType() : databaseType.getType();
    }

    public static String getDefaultSchemaName(DatabaseType databaseType, String databaseName) {
        return databaseType instanceof SchemaSupportedDatabaseType ? ((SchemaSupportedDatabaseType)databaseType).getDefaultSchema() : databaseName;
    }

    @Generated
    private DatabaseTypeEngine() {
    }
}

