/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.database.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.datasource.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;

public final class DataSourceGeneratedDatabaseConfiguration
implements DatabaseConfiguration {
    private final Map<String, DataSource> dataSources;
    private final Collection<RuleConfiguration> ruleConfigurations;
    private final Map<String, DataSourceProperties> dataSourceProperties;

    public DataSourceGeneratedDatabaseConfiguration(Map<String, DataSourceConfiguration> dataSources, Collection<RuleConfiguration> ruleConfigs) {
        this.dataSources = DataSourcePoolCreator.create(this.createDataSourcePropertiesMap(dataSources));
        this.ruleConfigurations = ruleConfigs;
        this.dataSourceProperties = this.createDataSourcePropertiesMap(dataSources);
    }

    private Map<String, DataSourceProperties> createDataSourcePropertiesMap(Map<String, DataSourceConfiguration> dataSources) {
        return dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePropertiesCreator.create("com.zaxxer.hikari.HikariDataSource", (DataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Override
    @Generated
    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    @Generated
    public Collection<RuleConfiguration> getRuleConfigurations() {
        return this.ruleConfigurations;
    }

    @Generated
    public Map<String, DataSourceProperties> getDataSourceProperties() {
        return this.dataSourceProperties;
    }
}

