/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.props;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.InvalidDataSourcePropertiesException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;

public final class DataSourcePropertiesValidator {
    public void validate(Map<String, DataSourceProperties> dataSourcePropertiesMap) throws InvalidResourcesException {
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (Map.Entry<String, DataSourceProperties> entry : dataSourcePropertiesMap.entrySet()) {
            try {
                this.validate(entry.getKey(), entry.getValue());
            }
            catch (InvalidDataSourcePropertiesException ex) {
                errorMessages.add(ex.getMessage());
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new InvalidResourcesException(errorMessages);
        }
    }

    private void validate(String dataSourceName, DataSourceProperties dataSourceProps) throws InvalidDataSourcePropertiesException {
        DataSource dataSource = null;
        try {
            dataSource = DataSourcePoolCreator.create(dataSourceProps);
            this.checkFailFast(dataSource);
        }
        catch (Exception ex) {
            throw new InvalidDataSourcePropertiesException(dataSourceName, ex.getMessage());
        }
        finally {
            if (null != dataSource) {
                new DataSourcePoolDestroyer(dataSource).asyncDestroy();
            }
        }
    }

    private void checkFailFast(DataSource dataSource) throws SQLException {
        dataSource.getConnection();
    }
}

