/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.infra.distsql.exception;

import java.sql.SQLException;
import java.util.function.Supplier;

/**
 * Dist SQL exception.
 */
public abstract class DistSQLException extends SQLException {
    
    private static final long serialVersionUID = -6464411607608071400L;
    
    public DistSQLException(final int errorCode, final String reason) {
        super(reason, "C" + errorCode, errorCode);
    }
    
    /**
     * Predict and throw an exception.
     *
     * @param state state
     * @param exceptionSupplier exception supplier
     * @throws DistSQLException distSQLException
     */
    public static void predictionThrow(final boolean state, final Supplier<DistSQLException> exceptionSupplier) throws DistSQLException {
        if (!state) {
            throw exceptionSupplier.get();
        }
    }
}
