/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.refresher.type;

import java.util.Collection;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.refresher.SchemaRefresher;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropViewStatement;

public final class DropViewStatementSchemaRefresher
implements SchemaRefresher<DropViewStatement> {
    @Override
    public void refresh(ShardingSphereMetaData schemaMetaData, Collection<String> logicDataSourceNames, DropViewStatement sqlStatement, ConfigurationProperties props) {
        sqlStatement.getViews().forEach(each -> schemaMetaData.getSchema().remove(each.getTableName().getIdentifier().getValue()));
        Collection<MutableDataNodeRule> rules = schemaMetaData.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (SimpleTableSegment each2 : sqlStatement.getViews()) {
            rules.forEach(rule -> rule.dropDataNode(each2.getTableName().getIdentifier().getValue()));
        }
    }
}

