/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeUtil;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;

public final class DataNodes {
    private final Collection<ShardingSphereRule> rules;

    public Collection<DataNode> getDataNodes(String tableName) {
        Optional<DataNodeContainedRule> dataNodeContainedRule = this.rules.stream().filter(each -> this.isDataNodeContainedRuleContainsTable((ShardingSphereRule)each, tableName)).findFirst().map(rule -> (DataNodeContainedRule)rule);
        if (!dataNodeContainedRule.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<DataNode> result = new LinkedList<DataNode>(dataNodeContainedRule.get().getAllDataNodes().get(tableName));
        for (ShardingSphereRule each2 : this.rules) {
            if (!(each2 instanceof DataSourceContainedRule)) continue;
            for (Map.Entry<String, Collection<String>> entry : ((DataSourceContainedRule)each2).getDataSourceMapper().entrySet()) {
                Collection<DataNode> dataNodes = this.findDataNodes(result, entry.getKey());
                result.removeAll(dataNodes);
                result.addAll(this.rebuildDataNodes(dataNodes, entry.getValue()));
            }
        }
        return result;
    }

    private boolean isDataNodeContainedRuleContainsTable(ShardingSphereRule each, String tableName) {
        return each instanceof DataNodeContainedRule && ((DataNodeContainedRule)each).getAllDataNodes().containsKey(tableName);
    }

    private Collection<DataNode> findDataNodes(Collection<DataNode> dataNodes, String logicDataSource) {
        return dataNodes.stream().filter(each -> each.getDataSourceName().equals(logicDataSource)).collect(Collectors.toList());
    }

    private Collection<DataNode> rebuildDataNodes(Collection<DataNode> dataNodes, Collection<String> actualDataSources) {
        LinkedHashSet<DataNode> result = new LinkedHashSet<DataNode>();
        for (DataNode each : dataNodes) {
            result.addAll(this.rebuildDataNodes(actualDataSources, each.getTableName()));
        }
        return result;
    }

    private Collection<DataNode> rebuildDataNodes(Collection<String> dataSources, String table) {
        return dataSources.stream().map(each -> new DataNode((String)each, table)).collect(Collectors.toCollection(() -> new LinkedHashSet(dataSources.size(), 1.0f)));
    }

    public Map<String, List<DataNode>> getDataNodeGroups(String tableName) {
        return DataNodeUtil.getDataNodeGroups(this.getDataNodes(tableName));
    }

    @Generated
    public DataNodes(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
    }
}

