/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config.rulealtered.yaml;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.job.JobSubType;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.RuleAlteredJobId;
import org.apache.shardingsphere.data.pipeline.spi.rulealtered.RuleAlteredJobConfigurationPreparerFactory;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YamlRuleAlteredJobConfiguration
implements YamlConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YamlRuleAlteredJobConfiguration.class);
    private String jobId;
    private String databaseName;
    private Integer activeVersion;
    private Integer newVersion;
    private String sourceDatabaseType;
    private String targetDatabaseType;
    private YamlPipelineDataSourceConfiguration source;
    private YamlPipelineDataSourceConfiguration target;
    private Map<String, List<String>> alteredRuleYamlClassNameTablesMap;
    private String logicTables;
    private String tablesFirstDataNodes;
    private List<String> jobShardingDataNodes;
    private int concurrency = 3;
    private int retryTimes = 3;

    public void setSource(YamlPipelineDataSourceConfiguration source) {
        this.checkParameters(source);
        this.source = source;
    }

    public void setTarget(YamlPipelineDataSourceConfiguration target) {
        this.checkParameters(target);
        this.target = target;
    }

    private void checkParameters(YamlPipelineDataSourceConfiguration yamlConfig) {
        Preconditions.checkNotNull((Object)yamlConfig);
        Preconditions.checkNotNull((Object)yamlConfig.getType());
        Preconditions.checkNotNull((Object)yamlConfig.getParameter());
    }

    public void extendConfiguration() {
        if (null == this.getJobShardingDataNodes()) {
            RuleAlteredJobConfigurationPreparerFactory.getInstance().extendJobConfiguration(this);
        }
        if (null == this.jobId) {
            this.jobId = this.generateJobId();
        }
        if (Strings.isNullOrEmpty((String)this.getSourceDatabaseType())) {
            PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance(this.source.getType(), this.source.getParameter());
            this.setSourceDatabaseType(sourceDataSourceConfig.getDatabaseType().getType());
        }
        if (Strings.isNullOrEmpty((String)this.getTargetDatabaseType())) {
            PipelineDataSourceConfiguration targetDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance(this.target.getType(), this.target.getParameter());
            this.setTargetDatabaseType(targetDataSourceConfig.getDatabaseType().getType());
        }
    }

    private String generateJobId() {
        RuleAlteredJobId jobId = new RuleAlteredJobId();
        jobId.setType(JobType.RULE_ALTERED.getValue());
        jobId.setFormatVersion("01");
        jobId.setSubTypes(Collections.singletonList(JobSubType.SCALING.getValue()));
        jobId.setCurrentMetadataVersion(this.activeVersion);
        jobId.setNewMetadataVersion(this.newVersion);
        jobId.setDatabaseName(this.databaseName);
        return jobId.marshal();
    }

    public String toString() {
        return "YamlRuleAlteredJobConfiguration{jobId='" + this.jobId + '\'' + ", databaseName='" + this.databaseName + '\'' + ", activeVersion=" + this.activeVersion + ", newVersion=" + this.newVersion + ", sourceDatabaseType='" + this.sourceDatabaseType + '\'' + ", targetDatabaseType='" + this.targetDatabaseType + '\'' + '}';
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public Integer getActiveVersion() {
        return this.activeVersion;
    }

    @Generated
    public Integer getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public String getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Generated
    public String getTargetDatabaseType() {
        return this.targetDatabaseType;
    }

    @Generated
    public YamlPipelineDataSourceConfiguration getSource() {
        return this.source;
    }

    @Generated
    public YamlPipelineDataSourceConfiguration getTarget() {
        return this.target;
    }

    @Generated
    public Map<String, List<String>> getAlteredRuleYamlClassNameTablesMap() {
        return this.alteredRuleYamlClassNameTablesMap;
    }

    @Generated
    public String getLogicTables() {
        return this.logicTables;
    }

    @Generated
    public String getTablesFirstDataNodes() {
        return this.tablesFirstDataNodes;
    }

    @Generated
    public List<String> getJobShardingDataNodes() {
        return this.jobShardingDataNodes;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setActiveVersion(Integer activeVersion) {
        this.activeVersion = activeVersion;
    }

    @Generated
    public void setNewVersion(Integer newVersion) {
        this.newVersion = newVersion;
    }

    @Generated
    public void setSourceDatabaseType(String sourceDatabaseType) {
        this.sourceDatabaseType = sourceDatabaseType;
    }

    @Generated
    public void setTargetDatabaseType(String targetDatabaseType) {
        this.targetDatabaseType = targetDatabaseType;
    }

    @Generated
    public void setAlteredRuleYamlClassNameTablesMap(Map<String, List<String>> alteredRuleYamlClassNameTablesMap) {
        this.alteredRuleYamlClassNameTablesMap = alteredRuleYamlClassNameTablesMap;
    }

    @Generated
    public void setLogicTables(String logicTables) {
        this.logicTables = logicTables;
    }

    @Generated
    public void setTablesFirstDataNodes(String tablesFirstDataNodes) {
        this.tablesFirstDataNodes = tablesFirstDataNodes;
    }

    @Generated
    public void setJobShardingDataNodes(List<String> jobShardingDataNodes) {
        this.jobShardingDataNodes = jobShardingDataNodes;
    }

    @Generated
    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    @Generated
    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }
}

