/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.event.JobEvent;
import org.apache.shardingsphere.elasticjob.tracing.exception.TracingConfigurationException;
import org.apache.shardingsphere.elasticjob.tracing.listener.TracingListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobTracingEventBus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobTracingEventBus.class);
    private final ExecutorService executorService;
    private final EventBus eventBus;
    private volatile boolean isRegistered;

    public JobTracingEventBus() {
        this.executorService = null;
        this.eventBus = null;
    }

    public JobTracingEventBus(TracingConfiguration<?> tracingConfig) {
        this.executorService = this.createExecutorService(Runtime.getRuntime().availableProcessors() * 2);
        this.eventBus = new AsyncEventBus((Executor)this.executorService);
        this.register(tracingConfig);
    }

    private ExecutorService createExecutorService(int threadSize) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadSize, threadSize, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(String.join((CharSequence)"-", "job-event", "%s")).build());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)threadPoolExecutor));
    }

    private void register(TracingConfiguration<?> tracingConfig) {
        try {
            this.eventBus.register((Object)TracingListenerFactory.getListener(tracingConfig));
            this.isRegistered = true;
        }
        catch (TracingConfigurationException ex) {
            log.error("Elastic job: create tracing listener failure, error is: ", (Throwable)ex);
        }
    }

    public void post(JobEvent event) {
        if (this.isRegistered && !this.executorService.isShutdown()) {
            this.eventBus.post((Object)event);
        }
    }
}

