/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.BitmapIndexOptions;
import com.hazelcast.config.IndexType;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.IndexUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IndexConfig
implements IdentifiedDataSerializable {
    public static final IndexType DEFAULT_TYPE = IndexType.SORTED;
    private String name;
    private IndexType type = DEFAULT_TYPE;
    private List<String> attributes;
    private BitmapIndexOptions bitmapIndexOptions;

    public IndexConfig() {
    }

    public IndexConfig(IndexType type) {
        this.setType(type);
    }

    public IndexConfig(IndexType type, String ... attributes) {
        this(type);
        if (attributes != null) {
            for (String attribute : attributes) {
                this.addAttribute(attribute);
            }
        }
    }

    public IndexConfig(IndexConfig other) {
        this.name = other.name;
        this.type = other.type;
        this.bitmapIndexOptions = other.bitmapIndexOptions == null ? null : new BitmapIndexOptions(other.bitmapIndexOptions);
        for (String attribute : other.getAttributes()) {
            this.addAttributeInternal(attribute);
        }
    }

    public String getName() {
        return this.name;
    }

    public IndexConfig setName(String name) {
        this.name = name;
        return this;
    }

    public IndexType getType() {
        return this.type;
    }

    public IndexConfig setType(IndexType type) {
        this.type = Preconditions.checkNotNull(type, "Index type cannot be null.");
        return this;
    }

    public List<String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        return this.attributes;
    }

    public IndexConfig addAttribute(String attribute) {
        this.addAttributeInternal(attribute);
        return this;
    }

    public void addAttributeInternal(String attribute) {
        IndexUtils.validateAttribute(attribute);
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        this.attributes.add(attribute);
    }

    public IndexConfig setAttributes(List<String> attributes) {
        Preconditions.checkNotNull(attributes, "Index attributes cannot be null.");
        this.attributes = new ArrayList<String>(attributes.size());
        for (String attribute : attributes) {
            this.addAttribute(attribute);
        }
        return this;
    }

    public BitmapIndexOptions getBitmapIndexOptions() {
        if (this.bitmapIndexOptions == null) {
            this.bitmapIndexOptions = new BitmapIndexOptions();
        }
        return this.bitmapIndexOptions;
    }

    public IndexConfig setBitmapIndexOptions(BitmapIndexOptions bitmapIndexOptions) {
        this.bitmapIndexOptions = bitmapIndexOptions == null ? null : new BitmapIndexOptions(bitmapIndexOptions);
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.type.getId());
        SerializationUtil.writeNullableList(this.attributes, out);
        out.writeObject(this.bitmapIndexOptions);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.type = IndexType.getById(in.readInt());
        this.attributes = SerializationUtil.readNullableList(in);
        this.bitmapIndexOptions = (BitmapIndexOptions)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexConfig that = (IndexConfig)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.type, (Object)that.type)) {
            return false;
        }
        if (!this.getBitmapIndexOptions().equals(that.getBitmapIndexOptions())) {
            return false;
        }
        return this.getAttributes().equals(that.getAttributes());
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.getAttributes().hashCode();
        result = 31 * result + this.getBitmapIndexOptions().hashCode();
        return result;
    }

    public String toString() {
        String string = "IndexConfig{name=" + this.name + ", type=" + (Object)((Object)this.type) + ", attributes=" + this.getAttributes();
        if (this.bitmapIndexOptions != null && !this.bitmapIndexOptions.areDefault()) {
            string = string + ", bitmapIndexOptions=" + this.bitmapIndexOptions;
        }
        return string + '}';
    }
}

