/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeekBlockingQueue<E> {
    private static final Logger log = LoggerFactory.getLogger(PeekBlockingQueue.class);
    private final BlockingQueue<E> queue = new LinkedBlockingQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();

    public void put(E element) {
        this.lock.lock();
        try {
            this.queue.put(element);
            this.notEmpty.signalAll();
        }
        catch (InterruptedException e) {
            log.error("Put element into queue failed. {}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
        finally {
            this.lock.unlock();
        }
    }

    public E take() throws InterruptedException {
        return this.queue.take();
    }

    public void release() {
        this.lock.lock();
        try {
            if (this.queue.isEmpty()) {
                return;
            }
            this.notEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public E peekBlocking() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.queue.peek() == null) {
                this.notEmpty.await();
            }
            Object e = this.queue.peek();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Integer size() {
        this.lock.lock();
        try {
            Integer n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

