/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.metrics.exports;

import com.hazelcast.instance.impl.Node;
import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.engine.server.telemetry.metrics.AbstractCollector;
import org.apache.seatunnel.engine.server.telemetry.metrics.entity.ThreadPoolStatus;

public class JobThreadPoolStatusExports
extends AbstractCollector {
    private static String HELP = "The %s of seatunnel coordinator job's executor cached thread pool";

    public JobThreadPoolStatusExports(Node node) {
        super(node);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        if (this.isMaster()) {
            ThreadPoolStatus threadPoolStatusMetrics = this.getServer().getThreadPoolStatusMetrics();
            List<String> labelNames = this.clusterLabelNames(ADDRESS, "type");
            GaugeMetricFamily activeCount = new GaugeMetricFamily("job_thread_pool_activeCount", String.format(HELP, "activeCount"), labelNames);
            activeCount.addMetric(this.labelValues(this.localAddress(), "activeCount"), (double)threadPoolStatusMetrics.getActiveCount());
            mfs.add((Collector.MetricFamilySamples)activeCount);
            CounterMetricFamily completedTask = new CounterMetricFamily("job_thread_pool_completedTask", String.format(HELP, "completedTask"), labelNames);
            completedTask.addMetric(this.labelValues(this.localAddress(), "completedTask"), (double)threadPoolStatusMetrics.getCompletedTaskCount());
            mfs.add((Collector.MetricFamilySamples)completedTask);
            GaugeMetricFamily corePoolSize = new GaugeMetricFamily("job_thread_pool_corePoolSize", String.format(HELP, "corePoolSize"), labelNames);
            corePoolSize.addMetric(this.labelValues(this.localAddress(), "corePoolSize"), (double)threadPoolStatusMetrics.getCorePoolSize());
            mfs.add((Collector.MetricFamilySamples)corePoolSize);
            GaugeMetricFamily maximumPoolSize = new GaugeMetricFamily("job_thread_pool_maximumPoolSize", String.format(HELP, "maximumPoolSize"), labelNames);
            maximumPoolSize.addMetric(this.labelValues(this.localAddress(), "maximumPoolSize"), (double)threadPoolStatusMetrics.getMaximumPoolSize());
            mfs.add((Collector.MetricFamilySamples)maximumPoolSize);
            GaugeMetricFamily poolSize = new GaugeMetricFamily("job_thread_pool_poolSize", String.format(HELP, "poolSize"), labelNames);
            poolSize.addMetric(this.labelValues(this.localAddress(), "poolSize"), (double)threadPoolStatusMetrics.getPoolSize());
            mfs.add((Collector.MetricFamilySamples)poolSize);
            CounterMetricFamily taskCount = new CounterMetricFamily("job_thread_pool_task", String.format(HELP, "taskCount"), labelNames);
            taskCount.addMetric(this.labelValues(this.localAddress(), "taskCount"), (double)threadPoolStatusMetrics.getTaskCount());
            mfs.add((Collector.MetricFamilySamples)taskCount);
            GaugeMetricFamily queueTaskCount = new GaugeMetricFamily("job_thread_pool_queueTaskCount", String.format(HELP, "queueTaskCount"), labelNames);
            queueTaskCount.addMetric(this.labelValues(this.localAddress(), "queueTaskCount"), (double)threadPoolStatusMetrics.getQueueTaskCount());
            mfs.add((Collector.MetricFamilySamples)queueTaskCount);
            CounterMetricFamily rejectedTaskCount = new CounterMetricFamily("job_thread_pool_rejection", String.format(HELP, "rejectionCount"), labelNames);
            rejectedTaskCount.addMetric(this.labelValues(this.localAddress(), "rejectionCount"), (double)threadPoolStatusMetrics.getRejectionCount());
            mfs.add((Collector.MetricFamilySamples)rejectedTaskCount);
        }
        return mfs;
    }
}

